from dataiku.eda.types import Literal

import scipy.stats as sps

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import SkewnessModel, SkewnessResultModel


class Skewness(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["skewness"]:
        return "skewness"

    @staticmethod
    def build(params: SkewnessModel) -> 'Skewness':
        return Skewness(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> SkewnessResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {"type": self.get_type(), "value": sps.skew(series, bias=False)}
