import logging

from . import DatabricksWriter

logger = logging.getLogger(__name__)


class DatabricksCSVWriter(DatabricksWriter):
    NAME = "INPUT_DATABRICKS_CSV"

    def __init__(self, client):
        super(DatabricksCSVWriter, self).__init__(client)

    def build_request_payload(self, input_df):
        return input_df.to_csv(index=False, header=False)

    def write(self, input_df):
        return self.client.call_endpoint(self.build_request_payload(input_df), {"Content-Type": 'text/csv'})