from dataiku.llm.python import BaseLLM


class GenericLangChainAgentWrapper(BaseLLM):
    def __init__(self, agent_executor):
        self.agent_executor = agent_executor

    async def aprocess_stream(self, query, settings, trace):
        from dataiku.langchain.dku_tracer import LangchainToDKUTracer
        tracer = LangchainToDKUTracer(dku_trace=trace)

        async for event in self.agent_executor.astream_events({"input": query["messages"]}, version="v2", config={"callbacks": [tracer]}):
            kind = event["event"]
            if kind == "on_chat_model_stream":
                content = event["data"]["chunk"].content
                if content:
                    yield {"chunk": {"type": "content", "text": content}}                    
            elif kind == "on_tool_start":
                yield {"chunk": {"type" : "event", "eventKind": "tool_call", "eventData" : {"toolName": event["name"]}}}
