/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.oauth;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.ClientCredentialOAuthProvider;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSHeader;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.ECDSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.RSASSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.BaseJWSProvider;
import com.databricks.client.jdbc42.internal.nimbusjwt.JWTClaimsSet;
import com.databricks.client.jdbc42.internal.nimbusjwt.SignedJWT;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.FileReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.UUID;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class ClientCredential_JWT_OAuthProvider
extends ClientCredentialOAuthProvider {
    private final String RS256_KEY = "RS256";
    private final String RS384_KEY = "RS384";
    private final String RS512_KEY = "RS512 ";
    private final String PS256_KEY = "PS256";
    private final String PS384_KEY = "PS384";
    private final String PS512_KEY = "PS512";
    private final String ES256_KEY = "ES256";
    private final String ES384_KEY = "ES384";
    private final String ES512_KEY = "ES512";
    private final String RSA_KEY = "RSA";
    private final String DSA_KEY = "ECDSA";
    private final String RSA_SEGMENT_KEY = "SunRsaSign";
    private final String DSA_SEGMENT_KEY = "SunEC";

    public ClientCredential_JWT_OAuthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void obtainAccessToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (this.hasValidDatabricksToken()) {
                return;
            }
            if (!this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                this.m_settings.m_oAuthSettings.m_authorizationUrl = this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint;
            }
            if (this.m_settings.m_oAuthSettings.m_OAuthUseJWTAssertion.booleanValue()) {
                PrivateKey privateKey = this.getPrivateKey(this.m_oAuthSettings);
                SignedJWT signedJWT = this.fetchAccessToken(privateKey, this.m_oAuthSettings);
                this.m_oAuthSettings.m_OAuthClientAssertion = signedJWT.serialize();
            }
            super.obtainAccessToken();
        }
        catch (ErrorException errorException) {
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, errorException.getCause());
            throw tException;
        }
    }

    private PrivateKey getPrivateKey(OAuthSettings oAuthSettings) throws ErrorException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Object object;
            PEMParser pEMParser = new PEMParser((Reader)new FileReader(oAuthSettings.m_OAuth2KeyFilePath));
            while ((object = pEMParser.readObject()) != null) {
                try {
                    return this.parseSegment(oAuthSettings, object);
                }
                catch (Exception exception) {
                }
            }
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
    }

    private PrivateKey parseSegment(OAuthSettings oAuthSettings, Object object) throws ErrorException {
        try {
            try {
                oAuthSettings.m_OAuthJWTKeyType = "ECDSA";
                return this.checkSegment(oAuthSettings, object, "SunEC");
            }
            catch (PEMException pEMException) {
                oAuthSettings.m_OAuthJWTKeyType = "RSA";
                return this.checkSegment(oAuthSettings, object, "SunRsaSign");
            }
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
    }

    private PrivateKey checkSegment(OAuthSettings oAuthSettings, Object object, String string) throws OperatorCreationException, PKCSException, PEMException {
        PrivateKeyInfo privateKeyInfo;
        Object object2;
        if (oAuthSettings.m_OAuth2KeyPassphrase != null) {
            object2 = (PKCS8EncryptedPrivateKeyInfo)object;
            JceOpenSSLPKCS8DecryptorProviderBuilder jceOpenSSLPKCS8DecryptorProviderBuilder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
            jceOpenSSLPKCS8DecryptorProviderBuilder.setProvider("BC");
            InputDecryptorProvider inputDecryptorProvider = jceOpenSSLPKCS8DecryptorProviderBuilder.build(oAuthSettings.m_OAuth2KeyPassphrase.toCharArray());
            privateKeyInfo = object2.decryptPrivateKeyInfo(inputDecryptorProvider);
        } else {
            try {
                privateKeyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
            }
            catch (ClassCastException classCastException) {
                privateKeyInfo = (PrivateKeyInfo)object;
            }
        }
        JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter().setProvider(string);
        object2 = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
        return object2;
    }

    private SignedJWT fetchAccessToken(PrivateKey privateKey, OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        BaseJWSProvider baseJWSProvider;
        if (oAuthSettings.m_OAuthJWTKeyType.equals("RSA")) {
            baseJWSProvider = new RSASSASigner(privateKey);
            jWSHeader = this.buildRSAHeader(oAuthSettings);
        } else if (oAuthSettings.m_OAuthJWTKeyType.equals("ECDSA")) {
            try {
                baseJWSProvider = new ECDSASigner((ECPrivateKey)privateKey);
                jWSHeader = this.buildECHeader(oAuthSettings);
            }
            catch (JOSEException jOSEException) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{jOSEException.getMessage()});
                throw errorException;
            }
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        String string = oAuthSettings.m_authClientID;
        Timestamp timestamp = Timestamp.valueOf(LocalDateTime.now());
        UUID uUID = UUID.randomUUID();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        JWTClaimsSet jWTClaimsSet = builder.issuer(string).subject(string).issueTime(timestamp).expirationTime(timestamp).audience(oAuthSettings.m_authorizationUrl).jwtID(uUID.toString()).build();
        SignedJWT signedJWT = new SignedJWT(jWSHeader, jWTClaimsSet);
        try {
            signedJWT.sign((JWSSigner)((Object)baseJWSProvider));
            return signedJWT;
        }
        catch (JOSEException jOSEException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{jOSEException.getMessage()});
            throw errorException;
        }
    }

    private JWSHeader buildECHeader(OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm == null) {
            oAuthSettings.m_OAuthJWTAssertionAlgorithm = "ES256";
        }
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("ES256")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("ES384")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("ES512")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.INVALID_ASSERTION_ALGORITHM_ERROR.name());
            throw errorException;
        }
        return jWSHeader;
    }

    private JWSHeader buildRSAHeader(OAuthSettings oAuthSettings) throws ErrorException {
        JWSHeader jWSHeader;
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm == null) {
            oAuthSettings.m_OAuthJWTAssertionAlgorithm = "RS256";
        }
        if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("RS256")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("RS384")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("RS512 ")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.RS512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("PS256")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS256).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("PS384")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS384).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else if (oAuthSettings.m_OAuthJWTAssertionAlgorithm.equals("PS512")) {
            jWSHeader = new JWSHeader.Builder(JWSAlgorithm.PS512).keyID(oAuthSettings.m_OAuth2KeyID).build();
        } else {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.INVALID_ASSERTION_ALGORITHM_ERROR.name(), oAuthSettings.m_OAuthJWTAssertionAlgorithm);
            throw errorException;
        }
        return jWSHeader;
    }
}

