/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.kerberos;

import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.auth.kerberos.BaseGSSContextProvider;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class DelegatedConstrainedContextProvider
extends BaseGSSContextProvider {
    private final GSSCredential gssCredential;

    public DelegatedConstrainedContextProvider(GSSCredential gssCredential) {
        this.gssCredential = Objects.requireNonNull(gssCredential, "gssCredential is null");
    }

    @Override
    public GSSContext getContext(String servicePrincipal) throws GSSException {
        if ((double)this.gssCredential.getRemainingLifetime() < MIN_CREDENTIAL_LIFETIME.getValue(TimeUnit.SECONDS)) {
            throw new ClientException(String.format("Kerberos credential is expired: %s seconds", this.gssCredential.getRemainingLifetime()));
        }
        return this.createContext(servicePrincipal, this.gssCredential);
    }
}

