/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.GlueSchema;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.S3CatalogHudiSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3CatalogHudiSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String database;
    private String table;
    private Map<String, String> additionalHudiOptions;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3CatalogHudiSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public S3CatalogHudiSource withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public S3CatalogHudiSource withTable(String table) {
        this.setTable(table);
        return this;
    }

    public Map<String, String> getAdditionalHudiOptions() {
        return this.additionalHudiOptions;
    }

    public void setAdditionalHudiOptions(Map<String, String> additionalHudiOptions) {
        this.additionalHudiOptions = additionalHudiOptions;
    }

    public S3CatalogHudiSource withAdditionalHudiOptions(Map<String, String> additionalHudiOptions) {
        this.setAdditionalHudiOptions(additionalHudiOptions);
        return this;
    }

    public S3CatalogHudiSource addAdditionalHudiOptionsEntry(String key, String value) {
        if (null == this.additionalHudiOptions) {
            this.additionalHudiOptions = new HashMap<String, String>();
        }
        if (this.additionalHudiOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalHudiOptions.put(key, value);
        return this;
    }

    public S3CatalogHudiSource clearAdditionalHudiOptionsEntries() {
        this.additionalHudiOptions = null;
        return this;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public S3CatalogHudiSource withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public S3CatalogHudiSource withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getAdditionalHudiOptions() != null) {
            sb.append("AdditionalHudiOptions: ").append(this.getAdditionalHudiOptions()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CatalogHudiSource)) {
            return false;
        }
        S3CatalogHudiSource other = (S3CatalogHudiSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getAdditionalHudiOptions() == null ^ this.getAdditionalHudiOptions() == null) {
            return false;
        }
        if (other.getAdditionalHudiOptions() != null && !other.getAdditionalHudiOptions().equals(this.getAdditionalHudiOptions())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalHudiOptions() == null ? 0 : this.getAdditionalHudiOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public S3CatalogHudiSource clone() {
        try {
            return (S3CatalogHudiSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3CatalogHudiSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

