/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.deser;

import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.core.StreamReadCapability;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.core.io.NumberInput;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import com.dataiku.dss.legacy.aws.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.dataiku.dss.legacy.aws.org.joda.time.Duration;
import java.io.IOException;

public class DurationDeserializer
extends JodaDeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    protected final JacksonJodaPeriodFormat _format;

    public DurationDeserializer() {
        this(FormatConfig.DEFAULT_PERIOD_FORMAT);
    }

    public DurationDeserializer(JacksonJodaPeriodFormat format) {
        super(Duration.class);
        this._format = format;
    }

    @Override
    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p.getLongValue());
            }
            case 6: {
                return this._fromString(p, ctxt, p.getText());
            }
            case 1: {
                return this._fromString(p, ctxt, ctxt.extractScalarFromObject(p, this, this.handledType()));
            }
        }
        return (Duration)this._handleNotNumberOrString(p, ctxt);
    }

    protected Duration _fromString(JsonParser p, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (Duration)this._fromEmptyString(p, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        return this._format.parsePeriod(ctxt, value).toStandardDuration();
    }

    protected Duration _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new Duration(ts);
    }
}

