/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.server;

import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.exceptions.ExceptionWithDebuggingHint;
import com.dataiku.dip.exceptions.ExceptionWithForeignStackTrace;
import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.exceptions.StackTraceElt;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

@UIModel
public class SerializedError {
    public String errorType;
    public String message;
    public String detailedMessage;
    public String detailedMessageHTML;
    public String stackTraceStr;
    public List<StackTraceElt> stackTrace = new ArrayList<StackTraceElt>();
    public SmartLogTail logTail;
    public ExceptionWithDebuggingHint.DebuggingHint debuggingHint;
    public String additionalInformationToLog;
    @UINullable
    public String code;
    @UINullable
    public String title;
    @UINullable
    public InfoMessage.FixabilityCategory fixability;
    public Object payload;
    public transient Throwable originalThrowable;

    public SerializedError() {
    }

    public SerializedError(Throwable t, boolean storeStack) {
        this(t, storeStack, true, true);
    }

    public SerializedError withRememberedOriginalThrowable(Throwable t) {
        this.originalThrowable = t;
        return this;
    }

    public SerializedError(Throwable t, boolean storeStack, boolean storeForeignStack, boolean storeLogTail) {
        List foreignStackTrace;
        boolean isNestedException = "org.springframework.web.util.NestedServletException".equals(t.getClass().getCanonicalName());
        if (t instanceof NullPointerException || t instanceof IndexOutOfBoundsException || t instanceof AssertionError || isNestedException && t.getCause() instanceof AssertionError) {
            t = new DSSInternalErrorException("Internal error", t);
        }
        if (t instanceof IOException && t.getMessage() != null) {
            String message = t.getMessage();
            if (message.contains("No space left on device")) {
                this.withCode(MiscCodes.ERR_MISC_ENOSPC);
            } else if (message.contains("Too many open files")) {
                this.withCode(MiscCodes.ERR_MISC_EOPENF);
            }
        }
        this.errorType = t.getClass().getName();
        this.message = t.getMessage();
        this.detailedMessage = com.dataiku.dip.utils.ExceptionUtils.getMessageWithCauses((Throwable)t);
        this.detailedMessageHTML = com.dataiku.dip.utils.ExceptionUtils.getMessageWithCausesHTML((Throwable)t);
        if (storeStack) {
            this.storeStack(t);
        }
        if (t instanceof ExceptionWithDebuggingHint) {
            this.debuggingHint = ((ExceptionWithDebuggingHint)t).getDebuggingHint();
        }
        if (t instanceof ExceptionWithLogTail && storeLogTail) {
            this.logTail = ((ExceptionWithLogTail)t).getLogTail();
        }
        if (t instanceof ExceptionWithForeignStackTrace && storeForeignStack && !(foreignStackTrace = ((ExceptionWithForeignStackTrace)t).getForeignStackTrace()).isEmpty()) {
            this.stackTrace.add(new StackTraceElt("CausedBy", "foreign code", 0));
            for (StackTraceElt elt : foreignStackTrace) {
                String eltLine = elt.getForeignRepr();
                if (StringUtils.isNotBlank((String)eltLine)) {
                    this.stackTraceStr = StringUtils.defaultIfBlank((String)this.stackTraceStr, (String)"") + eltLine + "\n";
                }
                this.stackTrace.add(elt);
            }
        }
        Throwable cur = t;
        do {
            if (!(cur instanceof ICodedException)) continue;
            ICodedException ie = (ICodedException)cur;
            InfoMessage.MessageCode ieCode = ie.getCode();
            if (ieCode != null) {
                this.withCode(ieCode);
            }
            this.payload = ie.getPayload();
        } while ((cur = cur.getCause()) != null);
    }

    public void appendCause(Throwable t) {
        if (this.detailedMessage == null) {
            this.detailedMessage = this.message;
        }
        if (this.detailedMessageHTML == null) {
            this.detailedMessageHTML = "<span><span class=\"err-msg\">" + StringEscapeUtils.escapeHtml((String)this.message) + "</span>";
        }
        this.detailedMessage = com.dataiku.dip.utils.ExceptionUtils.appendCause((String)this.detailedMessage, (Throwable)t);
        this.detailedMessageHTML = com.dataiku.dip.utils.ExceptionUtils.appendCause((String)this.detailedMessageHTML, (Throwable)t);
    }

    public void storeStack(Throwable t) {
        this.stackTraceStr = ExceptionUtils.getFullStackTrace((Throwable)t);
        SerializedError.fillStack(this, t);
    }

    public SerializedError withCode(InfoMessage.MessageCode code) {
        this.code = code.getCode();
        this.title = code.getCodeTitle();
        this.fixability = code.getFixability();
        return this;
    }

    public static void fillStack(SerializedError ret, Throwable t) {
        Throwable cur = t;
        while (cur != null) {
            String message;
            for (StackTraceElement nativeElt : cur.getStackTrace()) {
                StackTraceElt parsed = new StackTraceElt();
                parsed.file = nativeElt.getFileName();
                parsed.line = nativeElt.getLineNumber();
                parsed.function = nativeElt.getClassName() + "." + nativeElt.getMethodName();
                ret.stackTrace.add(parsed);
            }
            if ((cur = cur.getCause()) == null) continue;
            StackTraceElt parsed = new StackTraceElt();
            parsed.file = "CausedBy";
            try {
                message = cur.getMessage();
            }
            catch (AssertionError e) {
                message = cur.toString();
            }
            parsed.function = "Cause: " + cur.getClass().getCanonicalName() + ": " + message;
            ret.stackTrace.add(parsed);
        }
    }

    public String getLoggable() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.message);
        if (this.stackTraceStr != null && !this.stackTraceStr.isEmpty()) {
            parts.add(this.stackTraceStr);
        }
        if (this.logTail != null && !this.logTail.lines.isEmpty()) {
            parts.add("Log tail:");
            parts.addAll(this.logTail.lines);
        }
        return String.join((CharSequence)"\n", parts);
    }
}

