/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;

public abstract class FutureThreadBase<T>
extends Thread {
    public String tenantId;
    public String jobId;
    public final long creationTime;
    public long finishTime = 0L;
    protected FutureProgress progress;
    public FutureAborter aborter;
    public Exception storedException;
    public Error storedError;
    public boolean aborted = false;
    private final AuditContextBase.AuditContextData mainAuditContextData = AuditContextBase.getContextData();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.futures");

    public FutureThreadBase(String tenantId, String jobIdPrefix) {
        this.tenantId = tenantId;
        this.jobId = (String)(jobIdPrefix == null ? "" : jobIdPrefix + "_") + SecretKeyGenerator.generate(8);
        this.creationTime = System.currentTimeMillis();
    }

    public void throwExceptionIfAny() throws Exception {
        if (this.storedException != null) {
            throw this.storedException;
        }
        if (this.storedError != null) {
            throw this.storedError;
        }
    }

    public void abort() {
        FuturePayload payload = this.getPayload();
        String displayName = payload != null ? payload.displayName : "Unnamed future";
        logger.info((Object)("Trying to abort " + String.valueOf(this) + " (" + displayName + ")"));
        if (!this.aborted && this.aborter != null) {
            this.aborter.abort();
        } else if (this.aborter == null) {
            logger.warn((Object)("No aborter available, not aborting " + String.valueOf(this) + " (" + displayName + ")"));
        } else {
            logger.warn((Object)("Already aborted: " + String.valueOf(this) + " (" + displayName + ")"));
        }
        this.aborted = true;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public abstract FuturePayload getPayload();

    public String getPayloadForStartDoneMessage() {
        return null;
    }

    public abstract double getDangerosity();

    public abstract T getResult();

    public FutureProgressStateSnapshot getProgressSnapshot() {
        return this.progress != null ? this.progress.getSnapshot() : null;
    }

    public SmartLogTail getLog() {
        return null;
    }

    public Integer getUsedFekPort() {
        return null;
    }

    public abstract void execute() throws Exception;

    public abstract String getOwnerIdentifier();

    public abstract void preExecute();

    public void postRunCleanup() {
    }

    protected String getNameForThreadNameAndMetrics() {
        String clazzName = this.getClass().getSimpleName();
        try {
            if (StringUtils.isEmpty((String)clazzName)) {
                clazzName = this.getClass().toString();
                int idxOfLastDot = clazzName.lastIndexOf(".");
                clazzName = idxOfLastDot > 0 && idxOfLastDot < clazzName.length() - 1 ? clazzName.substring(idxOfLastDot + 1) : clazzName.replace("class ", "");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed computing better name for future", (Throwable)e);
        }
        return clazzName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String name = this.getNameForThreadNameAndMetrics();
        this.setName("FT-" + name + "-" + this.jobId + "-" + this.getId());
        Object suffix = this.getPayloadForStartDoneMessage();
        suffix = suffix == null ? "" : " (" + (String)suffix + ")";
        try (DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx("dku.futures.execute.overall", "dku.futures.execute.byClass." + name);){
            DKULogger.startCurrentCall();
            logger.info((Object)("Starting future execution: " + name + (String)suffix));
            this.progress = FutureProgress.init();
            this.aborter = FutureAborter.init();
            this.preExecute();
            try (FutureAborter.AutoCloseableAbortHook aborterHook = FutureAborter.pushAutoCloseableHook((Runnable)new FutureThreadInterrupt(this));){
                if (this.mainAuditContextData != null) {
                    AuditContextBase.setContextData(this.mainAuditContextData);
                }
                this.execute();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Future thread failed", (Throwable)e);
            this.storedException = e;
        }
        catch (Error e) {
            logger.warn((Object)"Future thread failed", (Throwable)e);
            this.storedError = e;
        }
        finally {
            this.finishTime = System.currentTimeMillis();
            logger.info((Object)("Completed future execution: " + name + (String)suffix));
            if (this.progress != null) {
                FutureProgress.deinit();
            }
            if (this.aborter != null) {
                FutureAborter.deinit();
            }
            DKULogger.endCurrentCall();
            NDC.remove();
            if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.BACKEND) {
                this.postRunCleanup();
            }
        }
    }

    private class FutureThreadInterrupt
    implements Runnable {
        private final Thread thread;

        public FutureThreadInterrupt(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            logger.info((Object)("Executing default abort hook (interrupt) on " + String.valueOf(this.thread)));
            if (this.thread.isAlive()) {
                FutureThreadBase.this.aborted = true;
                this.thread.interrupt();
                logger.info((Object)"Done interrupting the thread");
            } else {
                logger.warn((Object)"Thread not alive anymore, not aborting it");
            }
        }
    }
}

