/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations;

import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationChannelsRegistry;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

@UIModel
@JsonAdapter(value=IntegrationChannelAdapter.class)
public class IntegrationChannel {
    public String type;
    public String id;
    public IntegrationChannelParams configuration;
    public List<IntegrationChannelPermissionsService.IntegrationChannelPermissionItem> permissions = Collections.singletonList(new IntegrationChannelPermissionsService.IntegrationChannelPermissionItem(null, "$$ALL_USERS$$").withCanUse());

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public IntegrationChannelParams getConfiguration() {
        return this.configuration;
    }

    public <T extends IntegrationChannelParams> T getConfigurationAs(Class<T> clazz) {
        return (T)((IntegrationChannelParams)clazz.cast(this.configuration));
    }

    public IntegrationChannel withType(String type) {
        this.type = type;
        return this;
    }

    public IntegrationChannel withId(String id) {
        this.id = id;
        return this;
    }

    public IntegrationChannel withConfiguration(IntegrationChannelParams configuration) {
        this.configuration = configuration;
        return this;
    }

    public IntegrationChannel withPermissions(List<IntegrationChannelPermissionsService.IntegrationChannelPermissionItem> permissions) {
        this.permissions = permissions;
        return this;
    }

    public static void registerAdapter() {
        JSON.registerAdapter(IntegrationChannel.class, (Object)new IntegrationChannelAdapter());
    }

    static class IntegrationChannelAdapter
    implements JSON.Adapter<IntegrationChannel> {
        IntegrationChannelAdapter() {
        }

        public IntegrationChannel deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            JsonElement jsonPermissions;
            JsonElement jsonParams;
            JsonObject jsonObj = json.getAsJsonObject();
            IntegrationChannel integrationChannel = new IntegrationChannel();
            integrationChannel = integrationChannel.withType(jsonObj.get("type").getAsString());
            JsonElement jsonId = jsonObj.get("id");
            if (jsonId != null) {
                integrationChannel = integrationChannel.withId(jsonId.getAsString());
            }
            if ((jsonParams = jsonObj.get("configuration")) != null) {
                integrationChannel = integrationChannel.withConfiguration((IntegrationChannelParams)ctx.deserialize(jsonParams, IntegrationChannelsRegistry.getMeta(integrationChannel.type).paramsClass()));
            }
            if ((jsonPermissions = jsonObj.get("permissions")) != null) {
                integrationChannel.permissions = (List)ctx.deserialize(jsonPermissions, new TypeToken<List<IntegrationChannelPermissionsService.IntegrationChannelPermissionItem>>(){}.getType());
            }
            return integrationChannel;
        }

        public JsonElement serialize(IntegrationChannel integrationChannel, Type type, JsonSerializationContext ctx) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("id", integrationChannel.id);
            jsonObj.addProperty("type", integrationChannel.getType());
            if (integrationChannel.getConfiguration() != null) {
                jsonObj.add("configuration", ctx.serialize((Object)integrationChannel.getConfiguration(), IntegrationChannelsRegistry.getMeta(integrationChannel.type).paramsClass()));
            }
            jsonObj.add("permissions", ctx.serialize(integrationChannel.permissions));
            return jsonObj;
        }
    }
}

