/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelib.com.azure.identity.ClientSecretCredential;
import com.dataiku.dss.shadelib.com.azure.identity.ClientSecretCredentialBuilder;
import com.dataiku.dss.shadelib.com.microsoft.graph.authentication.IAuthenticationProvider;
import com.dataiku.dss.shadelib.com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.dataiku.dss.shadelib.com.microsoft.graph.core.IBaseClient;
import com.dataiku.dss.shadelib.com.microsoft.graph.http.CustomRequest;
import com.dataiku.dss.shadelib.com.microsoft.graph.options.HeaderOption;
import com.dataiku.dss.shadelib.com.microsoft.graph.requests.GraphServiceClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.mail.Message;
import javax.mail.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class MicrosoftGraphMailSender
extends AbstractMailSender {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        @Override
        public String getType() {
            return "microsoft-graph-mail";
        }

        @Override
        public Class<? extends IntegrationChannelParams> paramsClass() {
            return MicrosoftGraphChannelConfiguration.class;
        }

        @Override
        public String getAssociatedIntegrationType() {
            return "mail-scenario";
        }
    };
    private final MicrosoftGraphChannelConfiguration channelParams;
    @Autowired
    private PasswordEncryptionService symmetricCryptoService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sender.microsoft");

    public MicrosoftGraphMailSender(MicrosoftGraphChannelConfiguration channelParams) {
        this.channelParams = channelParams;
        SpringUtils.getInstance().autowire(this);
    }

    @Override
    public MailChannelConfiguration getConfiguration() {
        return this.channelParams;
    }

    @Override
    public Session newSession() {
        return Session.getInstance((Properties)new Properties());
    }

    @Override
    public void send(Session session, Message mail, InfoMessage.InfoMessages messages) throws Exception {
        try {
            logger.info((Object)"Attempting to send an email through Microsoft Graph...");
            List<String> scopes = Collections.singletonList("https://graph.microsoft.com/.default");
            ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.channelParams.clientId)).tenantId(this.channelParams.tenantId)).clientSecret(this.symmetricCryptoService.decryptIfEncrypted(this.channelParams.clientSecret)).build();
            TokenCredentialAuthProvider authProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)credential);
            GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)authProvider).buildClient();
            CustomRequest request = new CustomRequest("https://graph.microsoft.com/v1.0/users/" + this.channelParams.sender + "/sendMail", (IBaseClient)graphClient, Collections.singletonList(new HeaderOption("Content-Type", "text/plain")), String.class);
            MicrosoftGraphMailSender.filterMailRecipients(this.channelParams.authorizedDomain, mail, messages);
            ByteArrayOutputStream mailStream = new ByteArrayOutputStream();
            mail.writeTo((OutputStream)mailStream);
            String mailBase64 = Base64.getMimeEncoder().encodeToString(mailStream.toByteArray());
            request.post((Object)mailBase64);
            logger.info((Object)"Email sent!");
        }
        catch (Exception ex) {
            logger.error((Object)"Email not sent: ", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public Future<InfoMessage.InfoMessages> startSending(Session session, Message mail) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<InfoMessage.InfoMessages> task = executor.submit(() -> {
            InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
            this.send(session, mail, infoMessages);
            return infoMessages;
        });
        executor.shutdown();
        return task;
    }

    public static class MicrosoftGraphChannelConfiguration
    extends MailChannelConfiguration {
        public String clientId;
        public String tenantId;
        public String clientSecret;

        @Override
        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.clientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.clientSecret);
        }
    }
}

