/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.integrations.mail.MailCodes;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SMTPSender
extends AbstractMailSender {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        @Override
        public String getType() {
            return "smtp";
        }

        @Override
        public Class<? extends IntegrationChannelParams> paramsClass() {
            return SMTPIntegrationChannelConfiguration.class;
        }

        @Override
        public String getAssociatedIntegrationType() {
            return "mail-scenario";
        }
    };
    private final SMTPIntegrationChannelConfiguration channelParams;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static Logger logger = Logger.getLogger((String)"dip.scenarios.smtp");

    public SMTPSender(SMTPIntegrationChannelConfiguration channelParams) {
        this.channelParams = channelParams;
        if (StringUtils.isBlank((String)channelParams.host)) {
            throw new CodedRuntimeException(MailCodes.ERR_MAIL_HOST_NOT_FOUND, "Should not be blank: host in channel settings");
        }
        SpringUtils.getInstance().autowire(this);
    }

    @Override
    public MailChannelConfiguration getConfiguration() {
        return this.channelParams;
    }

    @Override
    public Session newSession() {
        Properties props = new Properties();
        props.put("mail.smtp.connectiontimeout", (Object)60000);
        props.put("mail.smtp.timeout", (Object)60000);
        props.put("mail.smtp.writetimeout", (Object)60000);
        if (this.channelParams.useSSL) {
            props.put("mail.smtps.auth", StringUtils.isBlank((String)this.channelParams.login) ? "false" : "true");
            props.put("mail.smtp.ssl.enable", "true");
        } else {
            props.put("mail.smtp.auth", StringUtils.isBlank((String)this.channelParams.login) ? "false" : "true");
            props.put("mail.smtp.starttls.enable", this.channelParams.useTLS ? "true" : "false");
        }
        for (SimpleKeyValue kv : this.channelParams.sessionProperties) {
            props.put(kv.key, kv.value);
        }
        Session session = Session.getInstance((Properties)props, null);
        return session;
    }

    @Override
    public void send(Session session, Message mail, InfoMessage.InfoMessages messages) throws Exception {
        int port = -1;
        port = this.channelParams.useSSL ? (this.channelParams.port != null ? this.channelParams.port : 465) : (this.channelParams.port != null ? this.channelParams.port : 25);
        String password = this.symetricCryptoService.decryptIfEncrypted(this.channelParams.password);
        Transport transport = null;
        try {
            SMTPSender.filterMailRecipients(this.channelParams.authorizedDomain, mail, messages);
            try (FutureAborter.AutoCloseableAbortHook connectionAbort = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"Interrupting SMTP send");
                    Thread.currentThread().interrupt();
                }
            });){
                transport = session.getTransport(this.channelParams.useSSL ? "smtps" : "smtp");
                if (StringUtils.isBlank((String)this.channelParams.login)) {
                    transport.connect(this.channelParams.host, port, null, null);
                } else {
                    transport.connect(this.channelParams.host, port, this.channelParams.login, password);
                }
                transport.sendMessage(mail, mail.getAllRecipients());
                logger.info((Object)"Email sent!");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Email not sent: ", (Throwable)ex);
            throw ex;
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.error((Object)"Cannot close SMTP message transport", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Future<InfoMessage.InfoMessages> startSending(final Session session, final Message mail) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<InfoMessage.InfoMessages> task = executor.submit(new Callable<InfoMessage.InfoMessages>(){

            @Override
            public InfoMessage.InfoMessages call() throws Exception {
                InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
                SMTPSender.this.send(session, mail, infoMessages);
                return infoMessages;
            }
        });
        executor.shutdown();
        return task;
    }

    @UIModel
    public static class SMTPIntegrationChannelConfiguration
    extends MailChannelConfiguration {
        public boolean useSSL;
        public boolean useTLS;
        public String login;
        public String password;
        public String host;
        public Integer port;
        public List<SimpleKeyValue> sessionProperties = Lists.newArrayList();

        @Override
        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.password);
        }
    }
}

