/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;

public abstract class SocketBlockLink
implements AutoCloseable {
    private final int port;
    private final ServerSocket serverSocket;
    private final JavaBlockLink blockLink;
    private static Logger logger = Logger.getLogger((String)"dku.block.link");

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public SocketBlockLink(PortRangeParams portRange) throws IOException {
        this(portRange, null);
    }

    public SocketBlockLink(PortRangeParams portRange, SSLContext sslContext) throws IOException {
        if (!portRange.enabled) {
            this.serverSocket = this.getSocket(0, sslContext);
            this.port = this.serverSocket.getLocalPort();
            logger.info((Object)("Started a socket on port " + this.port));
            this.blockLink = new JavaBlockLink();
            return;
        }
        assert (portRange.isValid()) : "Port range not defined properly";
        ServerSocket candidateServerSocket = null;
        for (int portCandidate : portRange.getRange()) {
            try {
                candidateServerSocket = this.getSocket(portCandidate, sslContext);
                logger.info((Object)("Started a socket on port " + portCandidate));
                break;
            }
            catch (IOException e) {
                logger.info((Object)String.format("Socket can't use port %d", portCandidate));
            }
        }
        if (candidateServerSocket == null) {
            throw new BindException(String.format("Task failed to find usable port in range [%d, %d]", portRange.start, portRange.end));
        }
        this.serverSocket = candidateServerSocket;
        this.port = this.serverSocket.getLocalPort();
        this.blockLink = new JavaBlockLink();
    }

    public int getPort() {
        return this.port;
    }

    private ServerSocket getSocket(int portCandidate, SSLContext sslContext) throws IOException {
        int backlog = 3;
        if (sslContext != null) {
            return sslContext.getServerSocketFactory().createServerSocket(portCandidate, backlog);
        }
        return new ServerSocket(portCandidate, backlog);
    }

    public JavaBlockLink getBlockLink() {
        return this.blockLink;
    }

    public boolean isConnected() {
        return this.blockLink.hasSocket();
    }

    public boolean isAlive() {
        return this.blockLink.isAlive();
    }

    public void waitForConnection(int timeout) throws IOException {
        Socket socket;
        this.serverSocket.setSoTimeout(timeout);
        try {
            socket = this.serverSocket.accept();
        }
        catch (SocketTimeoutException e) {
            throw new SecretKernelTimeoutException("Subprocess did not connect in " + timeout + "ms, it probably crashed at startup. Check the logs.", e);
        }
        catch (IOException e) {
            throw new SecretKernelTimeoutException("Subprocess failed to connect, it probably crashed at startup. Check the logs.", e);
        }
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        this.blockLink.setSocket(socket);
    }

    public void flush() throws IOException {
        this.blockLink.flush();
    }

    public void sendRequest(Object command) throws IOException {
        this.blockLink.sendRequest(command);
    }

    public void sendNullCommand() throws IOException {
        this.blockLink.sendNullCommand();
    }

    public void receiveNullCommand() throws IOException {
        this.blockLink.receiveNullCommand();
    }

    public <TResp> TResp receiveResponse(Class<? extends TResp> clazz) throws IOException {
        return this.blockLink.receiveResponse(clazz);
    }

    public String receiveStringResponse(int maxExpectedLength) throws IOException {
        return this.blockLink.receiveStringResponse(maxExpectedLength);
    }

    public String receiveStringResponse() throws IOException {
        return this.blockLink.receiveStringResponse();
    }

    public <TResp> TResp receiveJsonResponse(Class<? extends TResp> clazz) throws IOException {
        return this.blockLink.receiveJsonResponse(clazz);
    }

    public <TResp> TResp receiveJsonResponse(TypeToken<? extends TResp> clazz) throws IOException {
        return this.blockLink.receiveJsonResponse(clazz);
    }

    public void sendStream(InputStream stream, int maxChunkSize) throws IOException {
        this.blockLink.sendStream(stream, maxChunkSize);
    }

    public void receiveStream(OutputStream stream, int maxChunkSize) throws IOException {
        this.blockLink.receiveStream(stream, maxChunkSize);
    }

    @Override
    public void close() throws IOException {
        IOException closeError = null;
        try {
            this.blockLink.close();
            logger.info((Object)"Closed socket");
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close socket", (Throwable)e);
            closeError = e;
        }
        try {
            this.serverSocket.close();
            logger.info((Object)"Closed serverSocket");
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close serverSocket", (Throwable)e);
            closeError = e;
        }
        if (closeError != null) {
            throw closeError;
        }
    }

    protected <TResp> SocketBlockLinkInteraction<TResp> newInteraction() {
        return new SocketBlockLinkInteraction(this.blockLink);
    }

    public static class SecretKernelTimeoutException
    extends IOException {
        private static final long serialVersionUID = 1L;

        SecretKernelTimeoutException(String message, IOException e) {
            super(message, e);
        }
    }
}

