/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.SymetricKeyBasedPasswordEncryptionProvider;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FileSymmetricKeyBasedPasswordEncryptionProviderBase
extends SymetricKeyBasedPasswordEncryptionProvider {
    @Autowired
    private TransactionService transactionService;
    public static RelFile DEFAULT_CONFIG_KEY_FILE = new RelFile("configkey.json");
    private final RelFile usedConfigKeyFile;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.encryption");

    public FileSymmetricKeyBasedPasswordEncryptionProviderBase() {
        this.usedConfigKeyFile = DEFAULT_CONFIG_KEY_FILE;
    }

    public FileSymmetricKeyBasedPasswordEncryptionProviderBase(TransactionService transactionService, RelFile configKeyFile) {
        this.usedConfigKeyFile = configKeyFile;
        this.transactionService = transactionService;
    }

    static KeyFile generateKey() {
        int aesKeyLengthBits = DKUApp.getParams().getIntParam("dku.security.passwordsEncryption.aesKeyLength", Integer.valueOf(128));
        byte[] key = SecretKeyGenerator.getRandomBytes(aesKeyLengthBits / 8);
        KeyFile kf = new KeyFile();
        kf.key = Base64.encodeBase64String((byte[])key);
        return kf;
    }

    public static void generateKey(RelFile targetFile) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        TransactionContext.retrieveWrite().writeObject(targetFile, FileSymmetricKeyBasedPasswordEncryptionProviderBase.generateKey());
    }

    public static void generateKey(File targetFile) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        JSON.prettyToFile((Object)FileSymmetricKeyBasedPasswordEncryptionProviderBase.generateKey(), (File)targetFile);
    }

    public static void generateDefaultKey() throws Exception {
        FileSymmetricKeyBasedPasswordEncryptionProviderBase.generateKey(DEFAULT_CONFIG_KEY_FILE);
    }

    static class KeyFile {
        String key;

        KeyFile() {
        }
    }
}

