/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.aws;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.util.AwsHostNameUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.retry.RetryMode;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.apache.ApacheHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrock.BedrockClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrock.BedrockClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.SesV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.SesV2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sqs.SqsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.utils.ThreadFactoryBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AWSClientBrokerService {
    private static final String AWS_SDK_THREAD_POOL_SIZE = "dku.aws.sdk.threadpool.size";
    private static final String AWS_USER_AGENT_TELEMETRY_SAS = "APN/1.1 (ak2ykpczm7ixuzgw0s4xr6y62)";
    private static final String AWS_USER_AGENT_TELEMETRY_INC = "APN/1.1 (5jnlvbu6mdxu0hhvnx0r85sqw)";
    private static final int DEFAULT_AWS_SDK_THREAD_POOL_SIZE = 8;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(DKUApp.getProperty("dku.aws.sdk.threadpool.size", 8), new ThreadFactoryBuilder().threadNamePrefix("sdk-ScheduledExecutor-dkuClient").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.aws.AWSClientBrokerService");

    public SdkHttpClient.Builder<?> getHttpClientBuilder(@Nonnull ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().connectionTimeout(Duration.ofMillis(connectTimeout)).socketTimeout(Duration.ofMillis(socketTimeout));
        ProxyUtils.applyProxySettings(proxySettings, httpClientBuilder);
        return httpClientBuilder;
    }

    public SdkAsyncHttpClient.Builder<?> getAsyncHttpClientBuilder(@Nonnull ProxySettings proxySettings, int connectTimeout, int queryTimeoutMS) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder().connectionTimeout(Duration.ofMillis(connectTimeout)).readTimeout(Duration.ofMillis(queryTimeoutMS)).writeTimeout(Duration.ofMillis(queryTimeoutMS));
        ProxyUtils.applyProxySettings(proxySettings, builder);
        return builder;
    }

    public SecretsManagerClient createSecretsManagerClient() {
        return (SecretsManagerClient)this.applyCommonConfiguration(SecretsManagerClient.builder()).build();
    }

    public S3ClientBuilder S3ClientBuilder(ClientOverrideConfiguration.Builder clientOverrideConfiguration) {
        return this.applyCommonConfiguration(S3Client.builder(), clientOverrideConfiguration);
    }

    public SesV2ClientBuilder createSesV2ClientBuilder() {
        return this.applyCommonConfiguration(SesV2Client.builder());
    }

    public StsClientBuilder createStsClientBuilder() {
        return this.applyCommonConfiguration(StsClient.builder());
    }

    public Ec2ClientBuilder createEc2ClientBuilder() {
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        this.applyTelemetry(clientOverrideConfiguration);
        return this.applyCommonConfiguration(Ec2Client.builder(), clientOverrideConfiguration);
    }

    public Route53ClientBuilder createRoute53ClientBuilder() {
        return this.applyCommonConfiguration(Route53Client.builder());
    }

    public KmsClientBuilder createKmsClientBuilder() {
        return this.applyCommonConfiguration(KmsClient.builder());
    }

    public ElasticLoadBalancingV2ClientBuilder createElasticLoadBalancingV2ClientBuilder() {
        return this.applyCommonConfiguration(ElasticLoadBalancingV2Client.builder());
    }

    public AcmClientBuilder createAcmClientBuilder() {
        return this.applyCommonConfiguration(AcmClient.builder());
    }

    private ClientOverrideConfiguration.Builder getClientOverrideConfigurationBuilder(ClientOverrideConfiguration config) {
        if (config == null) {
            return ClientOverrideConfiguration.builder();
        }
        return config.toBuilder();
    }

    public SageMakerClientBuilder createSageMakerClientBuilder(SdkHttpClient.Builder<?> httpClientBuilder, @Nullable ClientOverrideConfiguration config, Region region) {
        return (SageMakerClientBuilder)((SageMakerClientBuilder)this.applyCommonConfiguration(SageMakerClient.builder(), this.getClientOverrideConfigurationBuilder(config)).httpClientBuilder(httpClientBuilder)).region(region);
    }

    public SageMakerRuntimeClientBuilder createSageMakerRuntimeClientBuilder(SdkHttpClient.Builder<?> httpClientBuilder, @Nullable ClientOverrideConfiguration config, Region region) {
        return (SageMakerRuntimeClientBuilder)((SageMakerRuntimeClientBuilder)this.applyCommonConfiguration(SageMakerRuntimeClient.builder(), this.getClientOverrideConfigurationBuilder(config)).httpClientBuilder(httpClientBuilder)).region(region);
    }

    public BedrockClientBuilder createBedrockClientBuilder(SdkHttpClient.Builder<?> httpClientBuilder, ClientOverrideConfiguration config, Region region) {
        return (BedrockClientBuilder)((BedrockClientBuilder)this.applyCommonConfiguration(BedrockClient.builder(), config.toBuilder()).httpClientBuilder(httpClientBuilder)).region(region);
    }

    public BedrockRuntimeClientBuilder createBedrockRuntimeClientBuilder(SdkHttpClient.Builder<?> httpClientBuilder, ClientOverrideConfiguration config, Region region) {
        return (BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)this.applyCommonConfiguration(BedrockRuntimeClient.builder(), config.toBuilder()).httpClientBuilder(httpClientBuilder)).region(region);
    }

    public BedrockRuntimeAsyncClientBuilder createBedrockRuntimeAsyncClientBuilder(SdkAsyncHttpClient.Builder<?> asyncHttpClientBuilder, ClientOverrideConfiguration config, Region region) {
        return (BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)this.applyCommonConfiguration(BedrockRuntimeAsyncClient.builder(), config.toBuilder()).httpClientBuilder(asyncHttpClientBuilder)).region(region);
    }

    public StsClient createStsClient(AwsCredentialsProvider credentialsProvider, String regionOrEndpoint) {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)this.applyCommonConfiguration(StsClient.builder()).credentialsProvider(credentialsProvider);
        AWSClientBrokerService.setRegionOrEndpoint(regionOrEndpoint, stsClientBuilder);
        return (StsClient)stsClientBuilder.build();
    }

    public CloudWatchClientBuilder createCloudWatchClientBuilder(SdkHttpClient.Builder<?> httpClientBuilder, Region region) {
        return (CloudWatchClientBuilder)((CloudWatchClientBuilder)this.applyCommonConfiguration(CloudWatchClient.builder(), ClientOverrideConfiguration.builder().retryStrategy(RetryMode.STANDARD)).region(region)).httpClientBuilder(httpClientBuilder);
    }

    public DynamoDbClientBuilder createDynamoDbClientBuilder() {
        return this.applyCommonConfiguration(DynamoDbClient.builder());
    }

    public SqsClientBuilder createSqsClientBuilder() {
        return this.applyCommonConfiguration(SqsClient.builder());
    }

    public static void setRegionOrEndpoint(String regionOrEndpoint, AwsClientBuilder<?, ?> clientBuilder) {
        if (!StringUtils.isBlank((String)regionOrEndpoint)) {
            logger.info((Object)("Using region/endpoint for AWS client: " + regionOrEndpoint));
            if (regionOrEndpoint.contains("://")) {
                clientBuilder.endpointOverride(URI.create(regionOrEndpoint));
                clientBuilder.region((Region)AwsHostNameUtils.parseSigningRegion((String)regionOrEndpoint, null).orElse(null));
            } else {
                clientBuilder.region(Region.of((String)regionOrEndpoint));
            }
        }
    }

    private <T extends SdkClientBuilder<T, ?>> T applyCommonConfiguration(T builder) {
        return this.applyCommonConfiguration(builder, ClientOverrideConfiguration.builder());
    }

    public void applyTelemetry(ClientOverrideConfiguration.Builder clientOverrideConfigurationBuilder) {
        if (DKUApp.isDataikuCloud()) {
            clientOverrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)AWS_USER_AGENT_TELEMETRY_SAS);
        } else {
            clientOverrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)AWS_USER_AGENT_TELEMETRY_INC);
        }
    }

    private <T extends SdkClientBuilder<T, ?>> T applyCommonConfiguration(T builder, ClientOverrideConfiguration.Builder builderOverrideConfiguration) {
        return (T)builder.overrideConfiguration((ClientOverrideConfiguration)builderOverrideConfiguration.scheduledExecutorService(this.scheduledExecutorService).build());
    }
}

