/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSIllegalArgumentException;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.security.auth.NotLoggedInException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.ExceptionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public abstract class DIPInternalControllerBase
extends DKUControllerBase {
    protected static Logger logger = Logger.getLogger((String)"dip.controllers");

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView resolveException(HttpServletRequest req, HttpServletResponse resp, Throwable e) {
        DIPInternalControllerBase.callFailed(e, req, resp);
        return null;
    }

    public static void sendError(Throwable e, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (resp.isCommitted()) {
            logger.error((Object)"Response already committed, cannot send error", e);
            resp.sendError(-1);
            return;
        }
        DIPInternalControllerBase.resetResponseButKeepHeaders(resp);
        if (e instanceof TypeMismatchException && e.getCause() instanceof ConversionFailedException) {
            e = e.getCause().getCause();
        }
        if (e instanceof NotAuthenticatedException) {
            DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 401, resp);
        } else if (e instanceof NotLoggedInException) {
            DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 401, resp);
        } else if (e instanceof SecurityException) {
            DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 403, resp);
        } else if (e instanceof UnauthorizedException) {
            DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 403, resp);
        } else if (e instanceof DKUSecurityException) {
            DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 403, resp);
        } else if (e instanceof IllegalArgumentException) {
            DIPInternalControllerBase.sendErrorFromThrowableWithStack(e, 400, resp);
        } else if (e instanceof NotFoundException) {
            DIPInternalControllerBase.sendErrorFromThrowableWithStack(e, 404, resp);
        } else if (e instanceof APIError.APIErrorException) {
            logger.info((Object)("REFLECTED ERROR: " + String.valueOf(((APIError.APIErrorException)e).error)));
            resp.setStatus(500);
            resp.setContentType("application/json");
            DIPInternalControllerBase.writeJsonToOutputStream(resp, ((APIError.APIErrorException)e).error);
        } else if (e instanceof ApplicativeException) {
            resp.setStatus(400);
            resp.setContentType("application/json");
            APIError ae = new APIError("ApplicativeException", e.getMessage());
            ae.title = ((ApplicativeException)e).getTitle();
            ae.code = ((ApplicativeException)e).code;
            ae.payload = ((ApplicativeException)e).payload;
            DIPInternalControllerBase.writeJsonToOutputStream(resp, ae);
        } else if (e instanceof ICodedException) {
            APIError apiErr = new APIError(e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            apiErr.unicizeStack();
            InfoMessage.MessageCode code = ((ICodedException)e).getCode();
            resp.setStatus(code == null ? 500 : code.getHttpStatus().value());
            resp.setContentType("application/json");
            DIPInternalControllerBase.writeJsonToOutputStream(resp, apiErr);
        } else if (e instanceof CustomPythonKernelException) {
            APIError apiErr = new APIError(e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
            apiErr.payload = ((CustomPythonKernelException)e).logTail;
            apiErr.unicizeStack();
            resp.setStatus(500);
            resp.setContentType("application/json");
            DIPInternalControllerBase.writeJsonToOutputStream(resp, apiErr);
        } else {
            logger.info((Object)("Err for " + req.getRequestURI()));
            if ("/dip/api/login".equals(req.getRequestURI())) {
                DIPInternalControllerBase.sendErrorFromThrowableNoStack(e, 500, resp);
            } else {
                DIPInternalControllerBase.sendErrorFromThrowableWithStack(e, 500, resp);
            }
        }
    }

    public static void callFailed(Throwable e, HttpServletRequest req, HttpServletResponse resp) {
        if (DIPInternalControllerBase.exceptionStackIsWorthPrintingInLogs(e)) {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed"), e);
        } else {
            logger.error((Object)("API call '" + req.getRequestURI() + "' failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        try {
            DIPInternalControllerBase.sendError(e, req, resp);
        }
        catch (Exception e2) {
            logger.error((Object)"Additional exception while sending error", (Throwable)e2);
        }
    }

    protected void checkArgument(boolean expression, String message, Object ... arguments) {
        if (!expression) {
            throw new DSSIllegalArgumentException(String.format(message, arguments));
        }
    }

    protected void checkNotNull(Object o, String message, Object ... arguments) {
        this.checkArgument(o != null, message, arguments);
    }

    protected void checkNotEmpty(String str, String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotEmpty((String)str), message, arguments);
    }

    protected void checkNotBlank(String str, String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotBlank((String)str), message, arguments);
    }
}

