/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.ifaces;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.SubReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import java.io.IOException;
import java.util.List;

public interface ReadOnlyFS {
    public List<RelFile> listFilesUnordered(RelFile var1) throws IOException;

    public FileContent readContentUnsafe(RelFile var1) throws IOException;

    public boolean isFile(RelFile var1) throws IOException;

    public boolean isDirectory(RelFile var1) throws IOException;

    public long getLastModified(RelFile var1) throws IOException;

    public long getLength(RelFile var1) throws IOException;

    public List<RelFile> listFiles(String var1) throws IOException;

    public <T> T readObject(RelFile var1, Class<T> var2) throws IOException;

    public <T> T readObject(String var1, Class<T> var2) throws IOException;

    public String readStringUTF8(String var1) throws IOException;

    public boolean isFile(String var1) throws IOException;

    public boolean isDirectory(String var1) throws IOException;

    public <T> T readObjectUnsafe(String var1, Class<T> var2) throws IOException;

    public String dumpTree() throws IOException;

    public List<RelFile> listRecursive(RelFile var1) throws IOException;

    public List<RelFile> listRecursive(RelFile var1, RelFileFilter var2) throws IOException;

    public List<RelFile> listRecursive(String var1, RelFileFilter var2) throws IOException;

    public List<RelFile> listRecursive(String var1) throws IOException;

    public boolean exists(RelFile var1) throws IOException;

    public boolean exists(String var1) throws IOException;

    public List<RelFile> listFiles(RelFile var1) throws IOException;

    public List<RelFile> listFiles(RelFile var1, RelFileFilter var2) throws IOException;

    public List<RelFile> listFiles(String var1, RelFileFilter var2) throws IOException;

    public long getLastModified(String var1) throws IOException;

    public long getLength(String var1) throws IOException;

    public <T> T readObjectDefault(String var1, Class<T> var2) throws IOException;

    public <T> T readObjectDefault(RelFile var1, Class<T> var2) throws IOException;

    public byte[] readBytes(RelFile var1) throws IOException;

    public byte[] readBytes(String var1) throws IOException;

    public <T> T readObjectUnsafe(RelFile var1, Class<T> var2) throws IOException;

    public String readStringUTF8(RelFile var1) throws IOException;

    public RelFileInputStream readStream(RelFile var1) throws IOException;

    public RelFileInputStream readStream(String var1) throws IOException;

    public <T> T readObjectDefaultUnsafe(String var1, Class<T> var2) throws IOException;

    public <T> T readObjectDefaultUnsafe(RelFile var1, Class<T> var2) throws IOException;

    public RelFileAttribute getAttributes(RelFile var1) throws IOException;

    public byte[] getHash(RelFile var1) throws IOException;

    public byte[] getHash(String var1) throws IOException;

    public CompressedFileData readCompressedBytesUnsafe(RelFile var1) throws IOException;

    default public ReadOnlyFS directoryView(RelFile dir) throws IOException {
        return new SubReadWriteFS(this, dir);
    }

    default public ReadOnlyFS directoryView(String path) throws IOException {
        return this.directoryView(RelFile.fromPath(path));
    }

    public static class CompressedFileData {
        public final byte[] data;
        public final FileContentCompressor compressor;
        public final long uncompressedLength;

        public CompressedFileData(byte[] data, FileContentCompressor compressor, long uncompressedLength) {
            this.data = data;
            this.compressor = compressor;
            this.uncompressedLength = uncompressedLength;
        }
    }
}

