/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.impl;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.TransactionCodes;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.exceptions.TransactionBadlyFailedError;
import com.dataiku.dip.transactions.exceptions.TransactionFailedException;
import com.dataiku.dip.transactions.fs.AtomicWriter;
import com.dataiku.dip.transactions.fs.FileContentFactory;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.fs.ProxiedReadWriteFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.JournalizedFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import com.dataiku.dip.transactions.fs.utils.FSLock;
import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.git.TransactionGitException;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.transactions.impl.StreamTracker;
import com.dataiku.dip.transactions.utils.ReadWriteUpgradableLock;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RWTransactionImpl
extends ProxiedReadWriteFS
implements RWTransaction,
UserEditable {
    private ReadWriteUpgradableLock.LockHandle lockHandle;
    private JournalizedFS newGen;
    private AtomicWriter atomicWriter;
    private FSLock writeLock;
    private CommitQueuesManager commitQueuesManager;
    private CachedReadFS cachedFS;
    private List<Runnable> postCommitTasks = new ArrayList<Runnable>();
    private FileContentFactory fileContentFactory;
    private final StreamTracker streamTracker = new StreamTracker(this);
    private File root;
    private AuthCtx user;
    private final TransactionDebugInfo debugInfo;
    private DebugTransactionRegistry registry;
    private ICommitBehavior commitBehavior;
    private final boolean committable;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.transactions");

    public RWTransactionImpl(DebugTransactionRegistry registry, ICommitBehavior commitBehavior, JournalizedFS newGen, FileContentFactory fileContentFactory, TransactionDebugInfo debugInfo, boolean committable) {
        this.commitBehavior = commitBehavior;
        this.registry = registry;
        this.newGen = newGen;
        this.fileContentFactory = fileContentFactory;
        this.debugInfo = debugInfo;
        this.committable = committable;
        this.registry.registerWrite(this);
    }

    @Override
    protected ReadWriteFS getDelegateFS() {
        return this.newGen;
    }

    @Override
    protected RelFileInputStream wrapFSInputStream(RelFileInputStream stream) {
        return this.streamTracker.track(stream);
    }

    @Override
    protected RelFileOutputStream wrapFSOutputStream(RelFileOutputStream stream) {
        return this.streamTracker.track(stream);
    }

    @Override
    protected synchronized <T> T wrapFSAccess(ProxiedReadOnlyFS.WrappedMethodCall<T> r) throws IOException {
        if (!this.isAlive()) {
            throw new RuntimeException("The transaction has been closed");
        }
        return r.call();
    }

    public void markStarted(ReadWriteUpgradableLock.LockHandle lh, AtomicWriter atomicWriter, CommitQueuesManager commitQueuesManager, FSLock writeLock, CachedReadFS cachedFS, File root) {
        this.lockHandle = lh;
        this.root = root;
        this.atomicWriter = atomicWriter;
        this.commitQueuesManager = commitQueuesManager;
        this.debugInfo.startedTime = System.currentTimeMillis();
        this.atomicWriter.checkState();
        this.writeLock = writeLock;
        this.cachedFS = cachedFS;
        this.debugInfo.state = TransactionProvider.TransactionState.RUNNING;
    }

    private synchronized void checkAliveness() {
        if (!this.isAlive()) {
            throw new RuntimeException("The transaction has been closed");
        }
    }

    @Override
    public synchronized boolean isAlive() {
        return this.lockHandle != null;
    }

    public boolean isCommittable() {
        return this.committable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void commit(String message, long millis, MinimalRWTransaction.TransactionGitCommitPolicy gitCommitPolicy) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
        block29: {
            Journal journal;
            boolean shouldExecutePostCommitTasks;
            block28: {
                if (!this.isCommittable()) {
                    this.close();
                    throw new TransactionFailedException("Cannot commit a non-committable write transaction");
                }
                this.commitBehavior.executeStartCommitTask();
                logger.debug((Object)"Begin commit");
                this.checkAliveness();
                this.debugInfo.commitStartedTime = System.currentTimeMillis();
                shouldExecutePostCommitTasks = false;
                try {
                    journal = this.newGen.buildJournal();
                }
                catch (IOException e) {
                    throw new TransactionFailedException("Unable to build diff journal", e);
                }
                if (!journal.isEmpty()) break block28;
                shouldExecutePostCommitTasks = true;
                this.debugInfo.emptyCommit();
                try {
                    this.writeLock.releaseLock();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot release write FS lock");
                }
                this.lockHandle.close();
                this.lockHandle = null;
                this.debugInfo.endTime = System.currentTimeMillis();
                logger.infoV("Transaction committed [exec=%dms commitWait=%dms commitExec=%dms]", new Object[]{this.debugInfo.commitStartedTime - this.debugInfo.startedTime, this.debugInfo.commitWaitDoneTime - this.debugInfo.commitWaitStartTime, this.debugInfo.endTime - this.debugInfo.commitWaitDoneTime});
                this.close();
                if (shouldExecutePostCommitTasks) {
                    for (Runnable callback : this.postCommitTasks) {
                        callback.run();
                    }
                }
                this.commitBehavior.executeEndCommitTask(this.user, message);
                return;
            }
            List<RelFile> changes = journal.toList();
            List<? extends CommitDef> gitCommits = this.commitBehavior.getCommitList(this.root, this.user, message, gitCommitPolicy, changes);
            try {
                if (this.commitQueuesManager != null) {
                    this.commitQueuesManager.flushPreviousCommits(gitCommits);
                }
            }
            catch (IOException e) {
                throw new TransactionFailedException("Failed to commit to Git a previously scheduled commit", e);
            }
            try {
                this.debugInfo.state = TransactionProvider.TransactionState.WAITING_UPGRADE;
                this.debugInfo.commitWaitStartTime = System.currentTimeMillis();
                ((ReadWriteUpgradableLock.UpgradableLock)this.lockHandle).upgrade();
                this.writeLock.acquireLockWait();
                this.debugInfo.state = TransactionProvider.TransactionState.COMMITTING;
                this.debugInfo.commitWaitDoneTime = System.currentTimeMillis();
                this.atomicWriter.executeAtomically(journal);
                this.cachedFS.updateCache(journal);
                shouldExecutePostCommitTasks = true;
            }
            catch (IOException e) {
                logger.error((Object)"Failed to commit transaction", (Throwable)e);
                TransactionFailedException tfe = new TransactionFailedException("Failed to commit transaction, it has been rollbacked", e);
                if ("No space left on device".equals(e.getMessage())) {
                    tfe.withCode(TransactionCodes.ERR_TRANSACTION_FAILED_ENOSPC);
                }
                throw tfe;
            }
            catch (IOError e) {
                logger.error((Object)"Fatal error when committing transaction", (Throwable)e);
                throw new TransactionBadlyFailedError("Commit badly failed, unable to recover", e);
            }
            try {
                if (this.commitQueuesManager != null) {
                    this.commitQueuesManager.scheduleOrExecCommit(gitCommits, millis);
                }
            }
            catch (IOException e) {
                throw new TransactionGitException("Failed to commit to Git a previously scheduled commit", e);
            }
            try {
                this.writeLock.releaseLock();
            }
            catch (IOException e) {
                logger.error((Object)"Cannot release write FS lock");
            }
            this.lockHandle.close();
            this.lockHandle = null;
            this.debugInfo.endTime = System.currentTimeMillis();
            logger.infoV("Transaction committed [exec=%dms commitWait=%dms commitExec=%dms]", new Object[]{this.debugInfo.commitStartedTime - this.debugInfo.startedTime, this.debugInfo.commitWaitDoneTime - this.debugInfo.commitWaitStartTime, this.debugInfo.endTime - this.debugInfo.commitWaitDoneTime});
            this.close();
            if (shouldExecutePostCommitTasks) {
                for (Runnable callback : this.postCommitTasks) {
                    callback.run();
                }
            }
            break block29;
            catch (Throwable throwable) {
                try {
                    this.writeLock.releaseLock();
                }
                catch (IOException e) {
                    logger.error((Object)"Cannot release write FS lock");
                }
                this.lockHandle.close();
                this.lockHandle = null;
                this.debugInfo.endTime = System.currentTimeMillis();
                logger.infoV("Transaction committed [exec=%dms commitWait=%dms commitExec=%dms]", new Object[]{this.debugInfo.commitStartedTime - this.debugInfo.startedTime, this.debugInfo.commitWaitDoneTime - this.debugInfo.commitWaitStartTime, this.debugInfo.endTime - this.debugInfo.commitWaitDoneTime});
                this.close();
                if (shouldExecutePostCommitTasks) {
                    for (Runnable callback : this.postCommitTasks) {
                        callback.run();
                    }
                }
                this.commitBehavior.executeEndCommitTask(this.user, message);
                throw throwable;
            }
        }
        this.commitBehavior.executeEndCommitTask(this.user, message);
    }

    @Override
    public void commit(String message) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
        this.commit(message, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
    }

    @Override
    public void commitV(String message, Object ... args) throws TransactionBadlyFailedError, TransactionFailedException, TransactionGitException {
        this.commit(String.format(message, args), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
    }

    @Override
    public synchronized void rollback() {
        this.checkAliveness();
        this.debugInfo.endTime = System.currentTimeMillis();
        this.lockHandle.close();
        this.lockHandle = null;
        this.close();
    }

    @Override
    public void onPostCommit(Runnable callback) {
        this.postCommitTasks.add(callback);
    }

    @Override
    public synchronized void close() {
        if (this.isAlive()) {
            this.rollback();
        }
        this.newGen = null;
        this.registry.unregister(this);
        this.streamTracker.close();
        this.fileContentFactory.close();
    }

    @Override
    public synchronized AuthCtx getUser() {
        this.checkAliveness();
        return this.user;
    }

    @Override
    public synchronized void setUser(AuthCtx user) {
        this.checkAliveness();
        this.user = user;
    }

    @Override
    public File resolve(RelFile file) {
        return file.resolve(this.root);
    }

    @Override
    public TransactionDebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

