/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.util.HashUtils;
import com.dataiku.dip.util.SecretKeyGenerator;

public class ApiKeyUtils {
    private static boolean useHashedApiKeys = true;
    private static final String SECURE_API_KEY_PREFIX = "dkuaps-";
    public static final String IN_MEMORY_KEY_SECRET_PREFIX = "dkuaps-im-";
    public static final String IN_MEMORY_KEY_ID_PREFIX = "dkuimk-";
    private static long IN_MEMORY_KEY_MAX_AGE = (long)(DKUApp.getParams().getIntParam("dku.apikeys.inMemoryKeys.maxAgeInDays", Integer.valueOf(7)) * 24 * 60 * 60) * 1000L;
    private static long IN_MEMORY_KEY_MIN_REMAINING_TIME = (long)(DKUApp.getParams().getIntParam("dku.apikeys.inMemoryKeys.minRemainingTimeInDays", Integer.valueOf(1)) * 24 * 60 * 60) * 1000L;

    public static String generateApiKeySecret() {
        return SECURE_API_KEY_PREFIX + SecretKeyGenerator.generate(32);
    }

    public static boolean useHashedApiKeys() {
        return useHashedApiKeys;
    }

    public static String hashIfNecessary(String key) {
        return useHashedApiKeys ? HashUtils.sha256WithSalt(key) : key;
    }

    public static boolean compareKeySecret(String incomingKeySecret, String validKeySecret) {
        if (useHashedApiKeys || validKeySecret.startsWith("sha256:")) {
            return HashUtils.verifySha256(incomingKeySecret, validKeySecret);
        }
        return validKeySecret.equals(incomingKeySecret);
    }

    public static void setUseHashedApiKeys(boolean value) {
        useHashedApiKeys = value;
    }

    public static String generateInMemoryApiKeyId() {
        return IN_MEMORY_KEY_ID_PREFIX + SecretKeyGenerator.generate(16);
    }

    public static String generateInMemoryApiKeySecret() {
        return IN_MEMORY_KEY_SECRET_PREFIX + SecretKeyGenerator.generate(32);
    }

    public static boolean isInMemoryKeyExpired(APIKeyBase key) {
        return IN_MEMORY_KEY_MAX_AGE != 0L && key.createdOn + IN_MEMORY_KEY_MAX_AGE < System.currentTimeMillis();
    }

    public static boolean isInMemoryKeyValid(APIKeyBase key) {
        return IN_MEMORY_KEY_MAX_AGE == 0L || key.createdOn + IN_MEMORY_KEY_MAX_AGE - IN_MEMORY_KEY_MIN_REMAINING_TIME > System.currentTimeMillis();
    }
}

