/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dss.legacy.aws.com.amazonaws.ClientConfiguration;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelib.com.google.api.client.http.javanet.NetHttpTransport;
import com.dataiku.dss.shadelib.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.dataiku.dss.shadelib.com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.io.grpc.HttpConnectProxiedSocketAddress;
import com.dataiku.dss.shadelib.okhttp3.Credentials;
import com.dataiku.dss.shadelib.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.HttpHost;
import com.dataiku.dss.shadelib.org.apache.http.auth.AuthScope;
import com.dataiku.dss.shadelib.org.apache.http.auth.UsernamePasswordCredentials;
import com.dataiku.dss.shadelib.org.apache.http.client.CredentialsProvider;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.BasicCredentialsProvider;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.apache.ApacheHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.apache.ProxyConfiguration;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.utils.AttributeMap;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ProxyUtils {
    public static TrustManager TRUST_ALL_CERTS = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static void applyProxySettings(ProxySettings proxySettings, DefaultHttpClient client) {
        if (proxySettings != null && proxySettings.hasProxy()) {
            HttpHost proxyHost = new HttpHost(proxySettings.host, proxySettings.port);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            if (proxySettings.hasAuthentication()) {
                client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost), (com.dataiku.dss.shadelib.org.apache.http.auth.Credentials)new UsernamePasswordCredentials(proxySettings.username, proxySettings.password));
            }
        }
    }

    public static HttpClientBuilder applyProxySettings(ProxySettings proxySettings, HttpClientBuilder builder) {
        if (proxySettings != null && proxySettings.hasProxy()) {
            HttpHost proxyHost = new HttpHost(proxySettings.host, proxySettings.port);
            builder.setProxy(proxyHost);
            if (proxySettings.hasAuthentication()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (com.dataiku.dss.shadelib.org.apache.http.auth.Credentials)new UsernamePasswordCredentials(proxySettings.username, proxySettings.password));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return builder;
    }

    public static void applyProxySettings(ProxySettings proxySettings, HTTPRequest httpRequest) {
        if (proxySettings != null && proxySettings.hasProxy()) {
            httpRequest.setProxy(proxySettings.getProxy());
            if (proxySettings.hasAuthentication()) {
                httpRequest.setHeader("Proxy-Authorization", new String[]{"Basic " + String.valueOf(Base64.encode((String)(proxySettings.username + ":" + proxySettings.password)))});
            }
        }
    }

    public static void applyProxySettings(@Nullable ProxySettings proxySettings, NetHttpTransport.Builder builder) {
        if (proxySettings != null && proxySettings.hasProxy()) {
            if (proxySettings.hasAuthentication()) {
                builder.setConnectionFactory(url -> {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection(proxySettings.getProxy());
                    httpURLConnection.setRequestProperty("Proxy-Authorization", "Basic " + String.valueOf(Base64.encode((String)(proxySettings.username + ":" + proxySettings.password))));
                    return httpURLConnection;
                });
            } else {
                builder.setProxy(proxySettings.getProxy());
            }
        }
    }

    public static NetHttpTransport getNetHttpTransport(@Nullable ProxySettings proxySettings) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        ProxyUtils.applyProxySettings(proxySettings, builder);
        return builder.build();
    }

    public static void registerProxyAuthenticator(Supplier<ProxySettings> proxySettingsSupplier) {
        Authenticator.setDefault(ProxyUtils.getProxyAuthenticator(proxySettingsSupplier));
    }

    public static Authenticator getProxyAuthenticator(final Supplier<ProxySettings> proxySettingsSupplier) {
        return new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                ProxySettings proxySettings;
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (proxySettings = (ProxySettings)proxySettingsSupplier.get()) != null && proxySettings.hasProxy() && proxySettings.hasAuthentication() && this.getRequestingHost().equalsIgnoreCase(proxySettings.host) && proxySettings.port == this.getRequestingPort()) {
                    return new PasswordAuthentication(proxySettings.username, proxySettings.password.toCharArray());
                }
                return null;
            }
        };
    }

    public static void applyProxyAuthentication(ProxySettings proxySettings, HttpURLConnection httpURLConnection) {
        if (proxySettings != null && proxySettings.hasProxy() && proxySettings.hasAuthentication()) {
            httpURLConnection.setRequestProperty("Proxy-Authorization", "Basic " + String.valueOf(Base64.encode((String)(proxySettings.username + ":" + proxySettings.password))));
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, ClientConfiguration awsConfig) {
        if (proxySettings.hasProxy()) {
            awsConfig.setProxyHost(proxySettings.host);
            awsConfig.setProxyPort(proxySettings.port);
            if (proxySettings.hasAuthentication()) {
                awsConfig.setProxyUsername(proxySettings.username);
                awsConfig.setProxyPassword(proxySettings.password);
            }
        }
    }

    public static void addHttpClientBuilderAndApplyProxySettings(ProxySettings proxySettings, SdkSyncClientBuilder<?, ?> clientBuilder) {
        ProxyUtils.addHttpClientBuilderAndApplyProxySettings(proxySettings, clientBuilder, false);
    }

    public static void addHttpClientBuilderAndApplyProxySettings(ProxySettings proxySettings, SdkSyncClientBuilder<?, ?> clientBuilder, boolean disableSSLVerification) {
        if (proxySettings.hasProxy()) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
            if (disableSSLVerification) {
                ProxyUtils.disableSslVerification(httpClientBuilder);
            }
            ProxyUtils.applyProxySettings(proxySettings, httpClientBuilder);
            clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, ApacheHttpClient.Builder httpClientBuilder) {
        if (proxySettings.hasProxy()) {
            ProxyConfiguration.Builder proxyConfigurationBuilder = ProxyConfiguration.builder();
            proxyConfigurationBuilder.endpoint(URI.create("http://" + proxySettings.host + ":" + proxySettings.port));
            if (proxySettings.hasAuthentication()) {
                proxyConfigurationBuilder.username(proxySettings.username);
                proxyConfigurationBuilder.password(proxySettings.password);
            }
            httpClientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigurationBuilder.build());
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, NettyNioAsyncHttpClient.Builder asyncHttpClientBuilder) {
        if (proxySettings.hasProxy()) {
            ProxyConfiguration.Builder proxyConfigurationBuilder = com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder();
            proxyConfigurationBuilder.host(proxySettings.host).port(proxySettings.port);
            if (proxySettings.hasAuthentication()) {
                proxyConfigurationBuilder.username(proxySettings.username);
                proxyConfigurationBuilder.password(proxySettings.password);
            }
            asyncHttpClientBuilder.proxyConfiguration((com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyConfigurationBuilder.build());
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, InstantiatingGrpcChannelProvider.Builder channelProviderBuilder) {
        if (proxySettings.hasProxy()) {
            channelProviderBuilder.setChannelConfigurator(managedChannelBuilder -> managedChannelBuilder.proxyDetector(socketAddress -> {
                HttpConnectProxiedSocketAddress.Builder addressBuilder = HttpConnectProxiedSocketAddress.newBuilder();
                addressBuilder.setProxyAddress((SocketAddress)new InetSocketAddress(proxySettings.host, proxySettings.port)).setTargetAddress((InetSocketAddress)socketAddress);
                if (proxySettings.hasAuthentication()) {
                    addressBuilder.setUsername(proxySettings.username).setPassword(proxySettings.password);
                }
                return addressBuilder.build();
            }));
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, InstantiatingHttpJsonChannelProvider.Builder channelProviderBuilder) {
        if (proxySettings.hasProxy()) {
            NetHttpTransport httpTransport = ProxyUtils.getNetHttpTransport(proxySettings);
            channelProviderBuilder.setHttpTransport((HttpTransport)httpTransport);
        }
    }

    public static void applyProxySettings(ProxySettings proxySettings, Map<String, String> accessInfo) {
        if (proxySettings.hasProxy()) {
            accessInfo.put("proxyHost", proxySettings.host);
            accessInfo.put("proxyPort", Integer.toString(proxySettings.port));
            if (proxySettings.hasAuthentication()) {
                accessInfo.put("proxyUser", proxySettings.username);
                accessInfo.put("proxyPassword", proxySettings.password);
            }
        }
    }

    public static String getJdbcUrlProxySettings(ProxySettings proxySettings) {
        StringBuilder jdbcUrlProxySettings = new StringBuilder();
        if (proxySettings.hasProxy()) {
            jdbcUrlProxySettings.append(";ProxyHost=").append(proxySettings.host).append(";ProxyPort=").append(proxySettings.port);
            if (proxySettings.hasAuthentication()) {
                jdbcUrlProxySettings.append(";ProxyUid=").append(proxySettings.username).append(";ProxyPwd=").append(proxySettings.password);
            }
        }
        return jdbcUrlProxySettings.toString();
    }

    public static Map<String, String> getSimbaLikeProxyProperties(ProxySettings proxySettings) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (proxySettings.hasProxy()) {
            props.put("UseProxy", "1");
            props.put("ProxyHost", proxySettings.host);
            props.put("ProxyPort", "" + proxySettings.port);
            if (proxySettings.hasAuthentication()) {
                props.put("ProxyAuth", "1");
                props.put("ProxyUID", proxySettings.username);
                props.put("ProxyPWD", proxySettings.password);
            }
        }
        return props;
    }

    public static void applyToOkHttpClient(ProxySettings proxySettings, boolean trustAllCerts, OkHttpClient.Builder clientBuilder) throws NoSuchAlgorithmException, KeyManagementException {
        InetSocketAddress proxyInetAddress = new InetSocketAddress(proxySettings.host, proxySettings.port);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
        clientBuilder.proxy(proxy);
        if (proxySettings.hasAuthentication()) {
            com.dataiku.dss.shadelib.okhttp3.Authenticator proxyAuthenticator = (route, response) -> {
                String credential = Credentials.basic((String)proxySettings.username, (String)proxySettings.password);
                if (response.isSuccessful()) {
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
                return null;
            };
            clientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        if (trustAllCerts) {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{TRUST_ALL_CERTS}, new SecureRandom());
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)TRUST_ALL_CERTS);
        }
    }

    private static void disableSslVerification(ApacheHttpClient.Builder httpClientBuilder) {
        try {
            Field standardOptionsField = httpClientBuilder.getClass().getDeclaredField("standardOptions");
            standardOptionsField.setAccessible(true);
            AttributeMap.Builder attributeMapBuilder = (AttributeMap.Builder)standardOptionsField.get(httpClientBuilder);
            attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)true);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

