/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClassScanner {
    final String modelDescriptor;
    private static final Resource FAKE_RESOURCE;
    private final List<RootMapping> rootMappings;
    private Map<String, List<ScannedClass>> subclassesIndex;
    private Map<String, ScannedClass> scannedClasses;

    public ClassScanner(Class<?> clazz, List<RootMapping> rootMappings) {
        this.modelDescriptor = "L" + clazz.getName().replace(".", "/") + ";";
        this.rootMappings = rootMappings;
    }

    public RootMapping getRootMappingForClass(Class<?> clazz) {
        ScannedClass scannedClass = this.scannedClasses.get(clazz.getName());
        if (scannedClass == null) {
            return null;
        }
        return scannedClass.root;
    }

    public boolean hasSubclasses(Class<?> clazz) {
        return !this.subclassesIndex.getOrDefault(clazz.getName(), Collections.emptyList()).isEmpty();
    }

    public List<Class<?>> listSubclasses(Class<?> clazz) {
        return this.subclassesIndex.getOrDefault(clazz.getName(), Collections.emptyList()).stream().map(ScannedClass::getOrLoadClass).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void annotateSubRec(ScannedClass scannedClass, Map<String, List<ScannedClass>> subclassesIndex) {
        List<ScannedClass> subclasses;
        if (scannedClass.hasModelAnnotation && (subclasses = subclassesIndex.get(scannedClass.className)) != null) {
            for (ScannedClass subClass : subclasses) {
                if (subClass.hasModelAnnotation) continue;
                subClass.hasModelAnnotation = true;
                this.annotateSubRec(subClass, subclassesIndex);
            }
        }
    }

    List<Class<?>> scanEntryPoints() throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(){

            protected Resource resolveRootDirResource(Resource resource) throws IOException {
                for (RootMapping rootMapping : ClassScanner.this.rootMappings) {
                    if (!rootMapping.matchClass(resource)) continue;
                    return resource;
                }
                return FAKE_RESOURCE;
            }
        };
        Resource[] resources = resourcePatternResolver.getResources("classpath*:**/*.class");
        this.scannedClasses = ((Stream)Arrays.stream(resources).parallel()).map(ExceptionUtils.checkedFunction(resource -> {
            if (resource.isReadable()) {
                ClassReader reader;
                try (InputStream is = resource.getInputStream();){
                    reader = new ClassReader(IOUtils.toByteArray((InputStream)is));
                }
                final ScannedClass scannedClass = new ScannedClass();
                scannedClass.resource = resource;
                reader.accept(new ClassVisitor(589824){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (desc.equals(ClassScanner.this.modelDescriptor)) {
                            scannedClass.hasModelAnnotation = true;
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        assert (scannedClass.className == null) : "Multiple classes in one file";
                        scannedClass.className = name.replace("/", ".");
                        scannedClass.superClassName = superName.replace("/", ".");
                        scannedClass.interfaceNames = new String[interfaces.length];
                        for (int i = 0; i < interfaces.length; ++i) {
                            scannedClass.interfaceNames[i] = interfaces[i].replace("/", ".");
                        }
                        super.visit(version, access, name, signature, superName, interfaces);
                    }
                }, 7);
                scannedClass.classFileName = scannedClass.className.replace(".", "/") + ".class";
                scannedClass.root = this.rootMappings.stream().filter(ExceptionUtils.checkedPredicate(rootMapping -> rootMapping.matchClass((Resource)resource))).findFirst().orElse(null);
                return scannedClass;
            }
            return null;
        })).filter(Objects::nonNull).collect(Collectors.toMap(scannedClass -> scannedClass.className, scannedClass -> scannedClass));
        this.subclassesIndex = new HashMap<String, List<ScannedClass>>();
        for (ScannedClass scannedClass2 : this.scannedClasses.values()) {
            if (!Object.class.getName().equals(scannedClass2.superClassName)) {
                List subClasses = this.subclassesIndex.computeIfAbsent(scannedClass2.superClassName, k -> new ArrayList());
                subClasses.add(scannedClass2);
            }
            for (String interfaceName : scannedClass2.interfaceNames) {
                List subClasses = this.subclassesIndex.computeIfAbsent(interfaceName, k -> new ArrayList());
                subClasses.add(scannedClass2);
            }
        }
        for (List list : this.subclassesIndex.values()) {
            list.sort(Comparator.comparing(scannedClass -> scannedClass.className));
        }
        for (ScannedClass scannedClass3 : this.scannedClasses.values()) {
            this.annotateSubRec(scannedClass3, this.subclassesIndex);
        }
        List<Class<?>> sortedEntryPoints = this.scannedClasses.values().parallelStream().filter(scannedClass -> scannedClass.hasModelAnnotation).map(ScannedClass::getOrLoadClass).filter(Objects::nonNull).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
        System.out.println("[+] Scan classes: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + this.scannedClasses.size() + " classes, " + sortedEntryPoints.size() + " entry points)");
        return sortedEntryPoints;
    }

    static {
        try {
            FAKE_RESOURCE = new FileUrlResource(new File("fake_directory_that_does_not_exist").toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ScannedClass {
        String[] interfaceNames;
        boolean hasModelAnnotation;
        String className;
        String superClassName;
        Resource resource;
        String classFileName;
        Class<?> clazz;
        RootMapping root;

        private ScannedClass() {
        }

        Class<?> getOrLoadClass() {
            if (this.clazz == null) {
                try {
                    this.clazz = Class.forName(this.className, false, ScannedClass.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    System.out.println("[!] Class not found: " + this.className + " (from " + String.valueOf(this.resource) + ")");
                }
            }
            return this.clazz;
        }
    }

    static class RootMapping {
        public final String directoryOrJarName;
        @Nullable
        public final RelFile targetDirectory;

        RootMapping(File inputDirectoryOrJar, String targetDirectory) {
            this.directoryOrJarName = inputDirectoryOrJar.toString();
            this.targetDirectory = targetDirectory != null ? RelFile.fromPath(targetDirectory) : null;
        }

        public boolean matchClass(Resource resource) throws IOException {
            return resource.getURL().toString().contains(this.directoryOrJarName);
        }
    }
}

