/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.j3ts.TSMappedType;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

class TSFileEmitter {
    public final RelFile tsDefinitionFileNameNoExt;
    private final Set<TSMappedType> imports = new HashSet<TSMappedType>();
    private final Set<TSMappedType> exports = new HashSet<TSMappedType>();
    NamespaceEmitter rootEmitter;
    NamespaceEmitter currentEmitter = this.rootEmitter = new NamespaceEmitter();

    public TSFileEmitter(RelFile tsDefinitionFileNameNoExt) {
        this.tsDefinitionFileNameNoExt = tsDefinitionFileNameNoExt;
    }

    private void reindent(String s, int level, StringBuilder sb) {
        for (String line : Splitter.on((char)'\n').split((CharSequence)s)) {
            for (int i = 0; i < level; ++i) {
                sb.append("    ");
            }
            sb.append(line).append("\n");
        }
    }

    private boolean isNamespaceEmpty(NamespaceEmitter ns) {
        return ns.definitionsBuffer.length() == 0 && ns.children.values().stream().allMatch(this::isNamespaceEmpty);
    }

    private void writeNamespaceRecursive(NamespaceEmitter nsToWrite, StringBuilder sb, int level) {
        String content = nsToWrite.definitionsBuffer.toString().trim();
        this.reindent(content, level, sb);
        for (Map.Entry<String, NamespaceEmitter> entry : nsToWrite.children.entrySet()) {
            if (this.isNamespaceEmpty(entry.getValue())) continue;
            sb.append("\n");
            this.reindent("export namespace " + entry.getKey() + " {", level, sb);
            this.writeNamespaceRecursive(entry.getValue(), sb, level + 1);
            this.reindent("}", level, sb);
        }
    }

    private List<String> synthesizeImportOrExportStatements(TSMappedType mt, String importOrExport) {
        ArrayList<String> out = new ArrayList<String>();
        if (mt.tsType == TSMappedType.TSType.INTERFACE || mt.tsType == TSMappedType.TSType.ENUM) {
            if (this.isSelfImport(mt)) {
                return out;
            }
            Object from = mt.foreignMapping == null ? "./" + String.valueOf(new File("/" + String.valueOf(this.tsDefinitionFileNameNoExt)).getParentFile().toPath().relativize(new File("/" + String.valueOf(mt.tsDefinitionFileNoExt)).toPath())) : RelFile.fromPath(String.valueOf(mt.foreignMapping.importPathPrefix) + "/" + String.valueOf(mt.tsDefinitionFileNoExt)).getFullPath();
            if (mt.tsType == TSMappedType.TSType.ENUM) {
                out.add(importOrExport + " { " + (mt.tsNamespaces.isEmpty() ? mt.tsName : mt.tsNamespaces.get(0)) + " as " + this.importAlias(mt, false) + " } from '" + (String)from + "';");
            }
            if (mt.tsType == TSMappedType.TSType.INTERFACE) {
                for (boolean forInterface : new boolean[]{false, true}) {
                    out.add(importOrExport + " { " + (mt.tsNamespaces.isEmpty() ? this.getTSName(mt, forInterface) : mt.tsNamespaces.get(0)) + " as " + this.importAlias(mt, forInterface) + " } from '" + (String)from + "';");
                }
            }
        }
        return out;
    }

    private String importAlias(TSMappedType mt, boolean forceReferenceTsInterface) {
        Object importedName = "";
        if (mt.foreignMapping != null) {
            importedName = (String)importedName + "_fm_";
        }
        importedName = (String)importedName + (mt.tsNamespaces.isEmpty() ? this.getTSName(mt, forceReferenceTsInterface) : mt.tsNamespaces.get(0));
        return importedName;
    }

    private Set<String> dedupImportsExports(Set<TSMappedType> importsOrExports, String importOrExport) {
        return importsOrExports.stream().filter(mt -> mt.tsDefinitionFileNoExt != null && !this.isSelfImport((TSMappedType)mt)).flatMap(mt -> this.synthesizeImportOrExportStatements((TSMappedType)mt, importOrExport).stream()).collect(Collectors.toCollection(HashSet::new));
    }

    private boolean isSelfImport(TSMappedType mt) {
        return this.tsDefinitionFileNameNoExt.equals(mt.tsDefinitionFileNoExt) && mt.foreignMapping == null;
    }

    public String generateCode() {
        Set<String> dedupedImportStatements = this.dedupImportsExports(this.imports, "import type");
        Set<String> dedupedExportStatements = this.dedupImportsExports(this.exports, "export");
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(dedupedImportStatements);
        out.addAll(dedupedExportStatements);
        Collections.sort(out);
        StringBuilder outputBuffer = new StringBuilder();
        for (String line : out) {
            outputBuffer.append(line).append("\n");
        }
        outputBuffer.append("\n");
        this.writeNamespaceRecursive(this.rootEmitter, outputBuffer, 0);
        return outputBuffer.toString().trim();
    }

    private void enterNamespace(String tsNamespace) {
        NamespaceEmitter nsEmitter = this.currentEmitter;
        this.currentEmitter = nsEmitter.children.get(tsNamespace);
        if (this.currentEmitter == null) {
            this.currentEmitter = new NamespaceEmitter();
            nsEmitter.children.put(tsNamespace, this.currentEmitter);
            this.currentEmitter.parent = nsEmitter;
        }
    }

    private void leaveNamespace() {
        this.currentEmitter = this.currentEmitter.parent;
    }

    public void addExport(TSMappedType mt) {
        this.exports.add(mt);
    }

    public void addImport(TSMappedType mt) {
        this.imports.add(mt);
    }

    private void writeTypeReferenceType(TSMappedType mt, boolean forceReferenceTsInterface) {
        this.write(this.importAlias(mt, forceReferenceTsInterface));
        if (!mt.tsNamespaces.isEmpty()) {
            List<String> subList = mt.tsNamespaces.subList(1, mt.tsNamespaces.size());
            if (!subList.isEmpty()) {
                this.write(".");
                this.write(String.join((CharSequence)".", subList));
            }
            this.write(".");
            this.write(this.getTSName(mt, forceReferenceTsInterface));
        }
    }

    private void writeTypeReference(TSMappedType mt, boolean forceReferenceTsInterface) {
        if (mt.tsType == TSMappedType.TSType.INTERFACE) {
            this.writeTypeReferenceType(mt, forceReferenceTsInterface);
            this.addImport(mt);
        } else if (mt.tsType == TSMappedType.TSType.ENUM) {
            this.writeTypeReferenceType(mt, false);
            this.addImport(mt);
        } else if (mt.tsType == TSMappedType.TSType.STRING) {
            this.write("string");
        } else if (mt.tsType == TSMappedType.TSType.NUMBER) {
            this.write("number");
        } else if (mt.tsType == TSMappedType.TSType.LIST) {
            this.writeTypeReference(mt.typeParameters.get(0), false);
            this.write("[]");
        } else if (mt.tsType == TSMappedType.TSType.MAP) {
            this.write("{ [key in ");
            this.writeTypeReference(mt.typeParameters.get(0), false);
            this.write("]: ");
            this.writeTypeReference(mt.typeParameters.get(1), false);
            this.write(" }");
        } else if (mt.tsType == TSMappedType.TSType.BOOLEAN) {
            this.write("boolean");
        } else if (mt.tsType == TSMappedType.TSType.ANY) {
            this.write("any");
        } else if (mt.tsType == TSMappedType.TSType.PARAMETRIZED_TYPE) {
            this.writeTypeReference(mt.rawJavaType, true);
            this.write("<");
            boolean first = true;
            for (TSMappedType typeParameter : mt.typeParameters) {
                if (!first) {
                    this.write(", ");
                }
                this.writeTypeReference(typeParameter, false);
                first = false;
            }
            this.write(">");
        } else if (mt.tsType == TSMappedType.TSType.TYPE_VARIABLE) {
            this.write(mt.tsName);
        } else if (mt.tsType == TSMappedType.TSType.UNKNOWN) {
            this.write("unknown");
        } else if (mt.tsType == TSMappedType.TSType.CUSTOM) {
            this.write(mt.tsCustomType);
            for (TSMappedType toImport : mt.manualImports) {
                this.addImport(toImport);
            }
        } else {
            throw new RuntimeException("Unknown type " + String.valueOf((Object)mt.tsType));
        }
        if (mt.problem != null && mt.tsType != TSMappedType.TSType.INTERFACE && mt.tsType != TSMappedType.TSType.ENUM) {
            this.write("/* ");
            this.write(mt.problem);
            this.write(" */");
        }
    }

    public void writeTypeDefinition(TSMappedType mt) {
        if (mt.tsType != TSMappedType.TSType.ENUM && mt.tsType != TSMappedType.TSType.INTERFACE) {
            return;
        }
        for (String tsNamespace : mt.tsNamespaces) {
            this.enterNamespace(tsNamespace);
        }
        if (mt.tsType == TSMappedType.TSType.INTERFACE) {
            this.write("/** \n");
            this.write(" * Translated from ");
            this.write(mt.javaType.toString());
            this.write("\n");
            this.write(" * Via: ");
            this.write(mt.explainTranslation());
            this.write("\n */\n");
            this.write("export interface ");
            this.write("_");
            this.write(mt.tsName);
            if (!mt.typeParameters.isEmpty()) {
                this.write("<");
                this.write(mt.typeParameters.stream().map(p -> p.tsName + " = any").collect(Collectors.joining(", ")));
                this.write(">");
            }
            boolean extended = false;
            if (mt.rawSuperclass != null) {
                this.write(" extends ");
                extended = true;
                if (mt.rawSuperclass.tsType == TSMappedType.TSType.INTERFACE) {
                    this.writeTypeReference(mt.superclass, true);
                } else {
                    this.write("Object /* Unable to extend " + String.valueOf(mt.rawSuperclass.javaType) + " */");
                }
            }
            if (!mt.implementedInterfaces.isEmpty()) {
                for (int i = 0; i < mt.implementedInterfaces.size(); ++i) {
                    if (extended) {
                        this.write(", ");
                    } else {
                        this.write(" extends ");
                        extended = true;
                    }
                    this.writeTypeReference(mt.implementedInterfaces.get(i), true);
                }
            }
            this.write(" {\n");
            if (mt.problem != null) {
                this.write("    ");
                this.write("// " + mt.problem + "\n");
            }
            if (mt.polyJsonMeta != null && mt.polyJsonType != null && (mt.typeFields == null || mt.typeFields.stream().noneMatch(mf -> mf.name.equals(mt.polyJsonMeta.getTypeProperty())))) {
                this.write("    ");
                this.write(mt.polyJsonMeta.getTypeProperty());
                this.write(": ");
                this.write(JSON.gson().toJson((Object)mt.polyJsonType));
                this.write(";\n");
            }
            if (mt.typeFields != null) {
                for (TSMappedType.MappedField mappedField : mt.typeFields) {
                    this.write("    ");
                    this.write(mappedField.name);
                    if (mappedField.optional) {
                        this.write("?");
                    }
                    this.write(": ");
                    this.writeTypeReference(mappedField.mt, false);
                    if (mappedField.optional) {
                        this.write(" | null");
                    }
                    this.write(";\n");
                }
            }
            this.write("}\n\n");
            if (mt.generateUnion && !mt.subclasses.isEmpty()) {
                List concreteSubclasses = mt.listHierarchyRecursivelyIncludingSelf().stream().filter(t -> t.concrete).collect(Collectors.toList());
                this.write("/** ");
                this.write("List of all concrete subclasses of ");
                this.write(mt.javaType.getTypeName());
                this.write(" */\n");
                this.write("export type ");
                this.write(mt.tsName);
                this.write(" =");
                if (concreteSubclasses.size() == 1) {
                    this.write(" ");
                    this.writeTypeReference((TSMappedType)concreteSubclasses.get(0), concreteSubclasses.get(0) == mt);
                } else {
                    for (TSMappedType subclass : concreteSubclasses) {
                        this.write("\n    | ");
                        this.writeTypeReference(subclass, subclass == mt);
                    }
                }
                this.write(";\n\n");
            } else {
                if (!mt.generateUnion && mt.hasJavaSubclasses) {
                    this.write("/**\n");
                    this.write("    ");
                    this.write("Translate from ");
                    this.write(mt.javaType.toString());
                    this.write("\n");
                    this.write("    ");
                    this.write("@deprecated Translation is incomplete: annotate it with UIModel to generate a union of all concrete subclasses\n");
                    this.write("*/\n");
                }
                this.write("export type ");
                this.write(mt.tsName);
                this.write(" = _");
                this.write(mt.tsName);
                this.write(";\n\n");
            }
            if (mt.polyJsonSubclasses != null && !mt.polyJsonSubclasses.isEmpty() && mt.polyJsonType == null) {
                this.enterNamespace(mt.tsName);
                this.write("/** Types of ");
                this.write(mt.javaType.toString());
                this.write(" in PolyJSON mappings */\n");
                this.write("export const ");
                this.write(mt.polyJsonMeta.getTypeProperty());
                this.write(" = [");
                for (TSMappedType tSMappedType : mt.polyJsonSubclasses) {
                    this.write(JSON.gson().toJson((Object)tSMappedType.polyJsonType));
                    this.write(", ");
                }
                this.write("] as const;\n\n");
                this.leaveNamespace();
            }
            if (mt.hasPolyJsonAnnotation) {
                this.enterNamespace(mt.tsName);
                TreeSet<TSMappedType> collectedInterfaces = new TreeSet<TSMappedType>();
                for (TSMappedType subtype : mt.listHierarchyRecursivelyIncludingSelf()) {
                    collectedInterfaces.addAll(subtype.implementedInterfaces);
                    if (subtype.polyJsonType == null) {
                        this.write("export function is");
                        this.write(subtype.tsName);
                        this.write("(obj: ");
                        this.writeTypeReference(mt, false);
                        this.write("): obj is ");
                        this.writeTypeReference(subtype, false);
                        this.write(" { return [");
                        for (TSMappedType polySubtype : subtype.polyJsonSubclasses) {
                            this.write(JSON.gson().toJson((Object)polySubtype.polyJsonType));
                            this.write(", ");
                        }
                        this.write("].includes(obj[");
                        this.write(JSON.gson().toJson((Object)mt.polyJsonMeta.getTypeProperty()));
                        this.write("]); }\n");
                        continue;
                    }
                    this.write("export function is");
                    this.write(subtype.tsName);
                    this.write("(obj: ");
                    this.writeTypeReference(mt, false);
                    this.write("): obj is ");
                    this.writeTypeReference(subtype, false);
                    this.write(" { return obj[");
                    this.write(JSON.gson().toJson((Object)mt.polyJsonMeta.getTypeProperty()));
                    this.write("] == ");
                    this.write(JSON.gson().toJson((Object)subtype.polyJsonType));
                    this.write("; }\n");
                }
                for (TSMappedType collectedInterface : collectedInterfaces) {
                    ArrayList<TSMappedType> subtypes = new ArrayList<TSMappedType>();
                    for (TSMappedType candidateSubtype : collectedInterface.listHierarchyRecursivelyIncludingSelf()) {
                        if (candidateSubtype.polyJsonType == null || candidateSubtype.polyJsonMeta != mt.polyJsonMeta) continue;
                        subtypes.add(candidateSubtype);
                    }
                    if (subtypes.isEmpty()) continue;
                    this.write("export function is");
                    this.write(collectedInterface.tsName);
                    this.write("(obj: ");
                    this.writeTypeReference(mt, false);
                    this.write("): obj is ");
                    this.writeTypeReference(collectedInterface, false);
                    this.write(" & ");
                    this.writeTypeReference(mt, false);
                    this.write(" { return [");
                    for (TSMappedType candidateSubtype : subtypes) {
                        this.write(JSON.gson().toJson((Object)candidateSubtype.polyJsonType));
                        this.write(", ");
                    }
                    this.write("].includes(obj[");
                    this.write(JSON.gson().toJson((Object)mt.polyJsonMeta.getTypeProperty()));
                    this.write("]); }\n");
                }
                this.write("\n");
                this.leaveNamespace();
            }
            if (mt.polyJsonType != null) {
                this.enterNamespace(mt.tsName);
                this.write("/** Type of ");
                this.write(mt.javaType.toString());
                this.write(" in PolyJSON mappings */\n");
                this.write("export const ");
                this.write(mt.polyJsonMeta.getTypeProperty());
                this.write(" = ");
                this.write(JSON.gson().toJson((Object)mt.polyJsonType));
                this.write(";\n\n");
                this.leaveNamespace();
            }
        }
        if (mt.tsType == TSMappedType.TSType.ENUM) {
            this.write("/** \n");
            this.write(" * Translated from enum ");
            this.write(mt.javaType.getTypeName());
            this.write("\n");
            this.write(" * Via: ");
            this.write(mt.explainTranslation());
            this.write("\n */\n");
            this.write("export enum ");
            this.write(mt.tsName);
            this.write(" {\n");
            if (mt.problem != null) {
                this.write("    ");
                this.write("// " + mt.problem + "\n");
            }
            for (TSMappedType.MappedEnumValue enumValue : mt.enumValues) {
                this.write("    ");
                this.write(enumValue.name);
                this.write(" = ");
                this.write(JSON.gson().toJson((Object)enumValue.value));
                this.write(",\n");
            }
            this.write("}\n");
        }
        if (mt.uiDataFields != null) {
            this.enterNamespace(mt.tsName);
            for (TSMappedType.MappedField mf3 : mt.uiDataFields) {
                this.write("export const ");
                this.write(mf3.name);
                this.write(": ");
                this.writeTypeReference(mf3.mt, false);
                if (mf3.optional) {
                    this.write(" | null");
                }
                this.write(" = ");
                this.write(mf3.tsData);
                this.write(";\n\n");
            }
            this.leaveNamespace();
        }
        for (int i = 0; i < mt.tsNamespaces.size(); ++i) {
            this.leaveNamespace();
        }
    }

    private String getTSName(TSMappedType mt, boolean forTSInterface) {
        return (forTSInterface ? "_" : "") + mt.tsName;
    }

    private void write(String str) {
        this.currentEmitter.definitionsBuffer.append(str);
    }

    static class NamespaceEmitter {
        NamespaceEmitter parent;
        TreeMap<String, NamespaceEmitter> children = new TreeMap();
        StringBuilder definitionsBuffer = new StringBuilder();

        NamespaceEmitter() {
        }
    }
}

