/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysFinder;
import com.dataiku.dip.shaker.processors.time.ical.IntervalTree;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HolidaysDatabase
implements HolidaysFinder {
    private final HashMap<String, IntervalTree<HolidayOccurrence, Integer>> calendars = new HashMap();
    private final HashMap<String, HashMap<String, DateTimeZone>> timezones = new HashMap();
    private static Logger logger = Logger.getLogger(HolidaysDatabase.class);

    private HolidaysDatabase(HashMap<String, List<HolidayOccurrence>> occurrences) {
        for (String calendarId : occurrences.keySet()) {
            IntervalTree tree = IntervalTree.build((Collection)occurrences.get(calendarId));
            HashMap<String, DateTimeZone> timezoneMap = new HashMap<String, DateTimeZone>();
            for (HolidayOccurrence occurrence : occurrences.get(calendarId)) {
                if (StringUtils.isBlank((String)occurrence.preferredTimezone) || timezoneMap.containsKey(occurrence.preferredTimezone)) continue;
                timezoneMap.put(occurrence.preferredTimezone, DateTimeZone.forID((String)occurrence.preferredTimezone));
            }
            this.timezones.put(calendarId, timezoneMap);
            this.calendars.put(calendarId, tree);
        }
    }

    private HolidaysDatabase() {
    }

    public static HolidaysDatabase empty() {
        return new HolidaysDatabase();
    }

    public static HolidaysDatabase loadFromFile(File file) throws IOException {
        List<HolidayOccurrence> occurrences = HolidaysDatabase.getHolidayOccurrences(file);
        return HolidaysDatabase.build(occurrences);
    }

    private static List<HolidayOccurrence> getHolidayOccurrences(File file) throws IOException {
        ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>();
        Interner stringInterner = Interners.newStrongInterner();
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isBlank((String)line) || line.startsWith("#")) continue;
                String[] splitted = line.split("\\|");
                if (splitted.length != 7) {
                    throw new IOException("Invalid record (found " + splitted.length + " columns):" + line);
                }
                String calendarId = (String)stringInterner.intern((Object)splitted[0]);
                String preferredTimezone = (String)stringInterner.intern((Object)splitted[1]);
                int dayFrom = Integer.parseInt(splitted[2]);
                int dayTo = Integer.parseInt(splitted[3]);
                HolidayOccurrence.Type type = HolidayOccurrence.Type.valueOf(splitted[4]);
                String zone = (String)stringInterner.intern((Object)splitted[5]);
                String eventName = (String)stringInterner.intern((Object)splitted[6]);
                HolidayOccurrence occurrence = new HolidayOccurrence(eventName, calendarId, dayFrom, dayTo, preferredTimezone, type, zone);
                occurrences.add(occurrence);
            }
        }
        catch (FileNotFoundException e) {
            logger.info((Object)ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return occurrences;
    }

    private static String clean(String str) {
        return str.replace("\n", " ").replace("\r", " ").replace("|", " ").trim();
    }

    public static HolidaysDatabase build(List<HolidayOccurrence> occurrences) {
        HashMap<String, List<HolidayOccurrence>> calendars = new HashMap<String, List<HolidayOccurrence>>();
        for (HolidayOccurrence occurrence : occurrences) {
            List<HolidayOccurrence> currentList = calendars.get(occurrence.calendarId);
            if (currentList == null) {
                currentList = new ArrayList<HolidayOccurrence>();
                calendars.put(occurrence.calendarId, currentList);
            }
            currentList.add(occurrence);
        }
        return new HolidaysDatabase(calendars);
    }

    public static HolidaysDatabase updatePreviousHolidaysDatabase(File file, List<HolidayOccurrence> occurrences) {
        HashSet<HolidayOccurrence> previousOccurrenceSet;
        HashMap<String, List<HolidayOccurrence>> calendars = new HashMap<String, List<HolidayOccurrence>>();
        HashSet<HolidayOccurrence> holidayOccurrenceSet = new HashSet<HolidayOccurrence>(occurrences);
        try {
            previousOccurrenceSet = new HashSet<HolidayOccurrence>(HolidaysDatabase.getHolidayOccurrences(file));
        }
        catch (IOException e) {
            logger.info((Object)("Unable to read previous database file : " + String.valueOf(file)));
            previousOccurrenceSet = new HashSet();
        }
        holidayOccurrenceSet.addAll(previousOccurrenceSet);
        for (HolidayOccurrence occurrence : holidayOccurrenceSet) {
            List<HolidayOccurrence> currentList = calendars.get(occurrence.calendarId);
            if (currentList == null) {
                currentList = new ArrayList<HolidayOccurrence>();
                calendars.put(occurrence.calendarId, currentList);
            }
            currentList.add(occurrence);
        }
        return new HolidaysDatabase(calendars);
    }

    @Override
    public List<HolidayOccurrence> searchForDay(int year, int month, int day, String selectedCalendar) {
        final ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>();
        IntervalTree<HolidayOccurrence, Integer> tree = this.calendars.get(selectedCalendar);
        if (tree != null) {
            tree.search(HolidayOccurrence.packDate(year, month, day), new IntervalTree.Visitor<HolidayOccurrence>(){

                @Override
                public void visit(HolidayOccurrence range) throws RuntimeException {
                    occurrences.add(range);
                }
            });
        }
        return occurrences;
    }

    @Override
    public List<HolidayOccurrence> searchForDay(DateTime date, String selectedCalendar) {
        final ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>();
        IntervalTree<HolidayOccurrence, Integer> tree = this.calendars.get(selectedCalendar);
        if (tree != null) {
            HashMap<String, DateTimeZone> timezoneMap = this.timezones.get(selectedCalendar);
            for (final Map.Entry<String, DateTimeZone> entry : timezoneMap.entrySet()) {
                DateTime timezoned = date.withZone(entry.getValue());
                int day = timezoned.getDayOfMonth();
                int month = timezoned.getMonthOfYear();
                int year = timezoned.getYear();
                tree.search(HolidayOccurrence.packDate(year, month, day), new IntervalTree.Visitor<HolidayOccurrence>(){

                    @Override
                    public void visit(HolidayOccurrence range) {
                        if (StringUtils.equals((String)range.preferredTimezone, (String)((String)entry.getKey()))) {
                            occurrences.add(range);
                        }
                    }
                });
            }
        }
        return occurrences;
    }

    @Override
    public List<String> listAvailableCalendars() {
        return new ArrayList<String>(this.calendars.keySet());
    }

    private void writeOccurrence(HolidayOccurrence occurrence, OutputStreamWriter writer) throws IOException {
        writer.write(HolidaysDatabase.clean(occurrence.calendarId));
        writer.write("|");
        writer.write(HolidaysDatabase.clean(occurrence.preferredTimezone));
        writer.write("|");
        writer.write("" + occurrence.dayFrom);
        writer.write("|");
        writer.write("" + occurrence.dayTo);
        writer.write("|");
        writer.write(HolidaysDatabase.clean(occurrence.type.toString()));
        writer.write("|");
        writer.write(HolidaysDatabase.clean(occurrence.zone));
        writer.write("|");
        writer.write(HolidaysDatabase.clean(occurrence.eventName));
        writer.write("\n");
    }

    public void saveToFile(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, false);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             final OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            osw.write("# Dataiku Holidays Database\n");
            osw.write("# Built on: " + DateTime.now().withZone(DateTimeZone.UTC).toString() + "\n");
            ArrayList<String> sortedKeySet = new ArrayList<String>(this.calendars.keySet());
            Collections.sort(sortedKeySet);
            for (String calendarId : sortedKeySet) {
                IntervalTree<HolidayOccurrence, Integer> calendar = this.calendars.get(calendarId);
                calendar.visit(new IntervalTree.ThrowingVisitor<HolidayOccurrence, IOException>(){

                    @Override
                    public void visit(HolidayOccurrence occurrence) throws IOException {
                        HolidaysDatabase.this.writeOccurrence(occurrence, osw);
                    }
                });
            }
        }
    }
}

