/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.expr.TokenizedText;
import com.dataiku.dip.shaker.processors.transform.TextSimplifierAlgorithm;

public class TextSimplifierUDF
extends SnowflakeUDF {
    private static boolean initialized;
    private static TextSimplifierAlgorithm textSimplifierAlgorithm;

    private void initialize(boolean normalize, boolean stem, boolean clearStopWords, boolean sortAlphabetically, String language) throws Exception {
        TextSimplifierAlgorithm.Parameter params = new TextSimplifierAlgorithm.Parameter();
        params.normalize = normalize;
        params.stem = stem;
        params.clearStopWords = clearStopWords;
        params.sortAlphabetically = sortAlphabetically;
        params.language = language;
        textSimplifierAlgorithm = new TextSimplifierAlgorithm(params);
        initialized = true;
    }

    public String process(String input, boolean normalize, boolean stem, boolean clearStopWords, boolean sortAlphabetically, String language) throws Exception {
        if (!initialized) {
            this.initialize(normalize, stem, clearStopWords, sortAlphabetically, language);
        }
        TokenizedText tokenized = new TokenizedText(input);
        textSimplifierAlgorithm.simplify(tokenized);
        return tokenized.toString(" ");
    }
}

