/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractLongMeaning;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;

public class DatetimeNoTz
extends AbstractLongMeaning {
    public static final DateTimeFormatter FORMATTER = DatetimeNoTz.withOrWithoutFractionalFormatter();
    public static final DateTimeFormatter CANONICAL_FORMATTER = DatetimeNoTz.canonicalFormatter();

    @Override
    public String getMeaningId() {
        return "DatetimeNoTz";
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    private static boolean isInvalidDatetimeNoTz(String s) {
        if (!DatetimeNoTz.areDigits(s, 0, 3) || s.charAt(4) != '-' && s.charAt(4) != '/' || !DatetimeNoTz.areDigits(s, 5, 6) || s.charAt(7) != '-' && s.charAt(7) != '/' || !DatetimeNoTz.areDigits(s, 8, 9) || s.charAt(10) != ' ' || !DatetimeNoTz.areDigits(s, 11, 12) || s.charAt(13) != ':' || !DatetimeNoTz.areDigits(s, 14, 15) || s.charAt(16) != ':' || !DatetimeNoTz.areDigits(s, 17, 18)) {
            return true;
        }
        if (s.length() == 19) {
            return false;
        }
        return s.charAt(19) != '.' || s.length() == 20 || !DatetimeNoTz.areDigits(s, 20, s.length() - 1);
    }

    private static DateTimeFormatter withOrWithoutFractionalFormatter() {
        DateTimeParser withoutFractional = new DateTimeFormatterBuilder().append(DKUDateUtils.ymdDashOrSlash()).appendLiteral(' ').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).toParser();
        DateTimeParser withFractional = new DateTimeFormatterBuilder().append(DKUDateUtils.ymdDashOrSlash()).appendLiteral(' ').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(".").appendFractionOfSecond(1, 9).toParser();
        DateTimeParser withOrWithoutFractional = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{withFractional, withoutFractional}).toParser();
        return new DateTimeFormatterBuilder().append(withOrWithoutFractional).toFormatter().withZone(DateTimeZone.UTC);
    }

    public static DateTimeFormatter canonicalFormatter() {
        return new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearMonthDay()).appendLiteral(" ").append(ISODateTimeFormat.hourMinuteSecondMillis()).toFormatter().withZone(DateTimeZone.UTC);
    }

    public long msSinceEpoch(String v) {
        if (v == null || v.isEmpty()) {
            return Long.MAX_VALUE;
        }
        int length = v.length();
        if (length > 50) {
            return Long.MAX_VALUE;
        }
        if (length >= 19 && !DatetimeNoTz.isInvalidDatetimeNoTz(v)) {
            try {
                return FORMATTER.parseMillis(v);
            }
            catch (Exception e) {
                return Long.MAX_VALUE;
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    public double detects(String val) {
        return this.msSinceEpoch(val) == Long.MAX_VALUE ? 0.0 : 0.9;
    }

    @Override
    public long longValue(String v) {
        return this.msSinceEpoch(v);
    }

    @Override
    public double doubleValue(String v) {
        long lv = this.longValue(v);
        if (lv == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return lv;
    }

    private static boolean areDigits(String s, int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

