/*
 * Decompiled with CFR 0.152.
 */
package fr.free.nrw.jakaroma;

import com.atilika.kuromoji.ipadic.Token;
import com.atilika.kuromoji.ipadic.Tokenizer;
import fr.free.nrw.jakaroma.KanaToRomaji;
import java.util.List;
import java.util.Scanner;

public class Jakaroma {
    private static final boolean DEBUG = false;
    private boolean isPronunciation = false;

    public static void main(String ... args) {
        String input;
        if (args.length == 0 || args[0].isEmpty()) {
            System.err.println("Jakaroma warn: no argument passed, reading stdin...");
            System.err.flush();
            try (Scanner scanner = new Scanner(System.in).useDelimiter("\\A");){
                input = scanner.hasNext() ? scanner.next() : "";
            }
        } else {
            input = args[0];
        }
        Jakaroma instance = new Jakaroma();
        instance.isPronunciation = true;
        instance.convert(input, true, true);
    }

    public String convert(String input, boolean trailingSpace, boolean capitalizeWords) {
        Tokenizer tokenizer = new Tokenizer();
        List tokens = tokenizer.tokenize(this.halfWidthToFullWidth(input));
        int tokensSize = tokens.size();
        StringBuilder buffer = new StringBuilder();
        KanaToRomaji kanaToRomaji = new KanaToRomaji();
        block8: for (int i = 0; i < tokensSize; ++i) {
            Token token = (Token)tokens.get(i);
            String type = token.getAllFeaturesArray()[1];
            if (token.getAllFeaturesArray()[0].equals("\u8a18\u53f7")) {
                buffer.append(kanaToRomaji.convert(token.getSurface()));
                continue;
            }
            switch (type) {
                case "\u6570": 
                case "\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8": 
                case "\u30b5\u5909\u63a5\u7d9a": {
                    buffer.append(kanaToRomaji.convert(token.getSurface()));
                    continue block8;
                }
                default: {
                    String romaji;
                    if (this.getKatakana(token).equals("*")) {
                        romaji = this.kuromojiFailedConvert(token, kanaToRomaji);
                    } else {
                        String katakana = this.getKatakana(token);
                        String currentRomaji = kanaToRomaji.convert(katakana);
                        if (katakana.endsWith("\u30c3") && i == tokensSize - 1) {
                            int lastIndex = katakana.length() - 1;
                            katakana = katakana.substring(0, lastIndex);
                            if (i != 0) {
                                buffer.deleteCharAt(buffer.length() - 1);
                            }
                            romaji = kanaToRomaji.convert(katakana) + "!";
                        } else if (katakana.endsWith("\u30c3")) {
                            romaji = this.smallTsuRomaji(token, (Token)tokens.get(i + 1), kanaToRomaji);
                            ++i;
                        } else {
                            romaji = currentRomaji;
                        }
                    }
                    if (!romaji.isEmpty()) {
                        if (capitalizeWords) {
                            buffer.append(romaji.substring(0, 1).toUpperCase());
                            buffer.append(romaji.substring(1));
                        } else {
                            if (token.getSurface().equals(token.getReading())) {
                                romaji = romaji.toUpperCase();
                            }
                            buffer.append(romaji);
                        }
                    }
                    if (!trailingSpace || i == tokensSize - 1) continue block8;
                    buffer.append(" ");
                }
            }
        }
        System.out.println(buffer);
        return buffer.toString();
    }

    private String getKatakana(Token token) {
        String katakana = this.isPronunciation ? token.getPronunciation() : token.getReading();
        return katakana;
    }

    private String smallTsuRomaji(Token token, Token nextToken, KanaToRomaji kanaToRomaji) {
        String nextRomaji = kanaToRomaji.convert(this.getKatakana(nextToken));
        String currentRomaji = kanaToRomaji.convert(this.getKatakana(token).substring(0, token.getSurface().length() - 1));
        String romaji = currentRomaji + nextRomaji.charAt(0) + nextRomaji;
        return romaji;
    }

    private String kuromojiFailedConvert(Token token, KanaToRomaji kanaToRomaji) {
        StringBuilder buffer = new StringBuilder();
        String surface = token.getSurface();
        if (surface.contains("\u30c3") && !surface.endsWith("\u30c3")) {
            String[] splitTokenSurface = surface.split("\u30c3");
            String romaji1 = kanaToRomaji.convert(splitTokenSurface[0]);
            String romaji2 = kanaToRomaji.convert(splitTokenSurface[1]);
            buffer.append(romaji1).append(romaji2.charAt(0)).append(romaji2);
        } else {
            for (char c : token.getSurface().toCharArray()) {
                if (KanaToRomaji.getDictionary().containsKey(String.valueOf(c))) {
                    buffer.append(kanaToRomaji.convert(String.valueOf(c)));
                    continue;
                }
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    private String halfWidthToFullWidth(String fullWidthStr) {
        if (null == fullWidthStr || fullWidthStr.length() <= 0) {
            return "";
        }
        char[] arr = fullWidthStr.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char charValue = arr[i];
            if (charValue >= '\uff01' && charValue <= '\uff5e') {
                arr[i] = (char)(charValue - 65248);
                continue;
            }
            if (charValue != '\u3000') continue;
            arr[i] = 32;
        }
        return new String(arr);
    }

    private static /* synthetic */ void lambda$convert$0(Token token) {
        System.out.println(token.getSurface() + "\t" + token.getAllFeatures());
    }
}

