/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.utils.GsonTypeAdapterUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.beans.Transient;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class SchemaColumn
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final String ORIGINAL_TYPE_DAY_DATE = "date_day";
    public static final String ORIGINAL_TYPE_TIMESTAMP_MILLI = "date_milli";
    public static final String ORIGINAL_TYPE_TIMESTAMP_MICRO = "date_micro";
    public static final String ORIGINAL_TYPE_DECIMAL = "decimal";
    protected String name;
    protected String type;
    private transient Type otype;
    public String comment;
    public String originalType;
    public String originalSQLType;
    public JsonObject customFields;
    public boolean isColumnEdited = false;
    private String meaning;
    public String downcastedToStringFromMeaning;
    public boolean timestampNoTzAsDate = false;
    public static final int MAX_LENGTH_DEFAULT = -1;
    public int maxLength = -1;
    public List<SchemaColumn> objectFields;
    public SchemaColumn arrayContent;
    public SchemaColumn mapKeys;
    public SchemaColumn mapValues;
    public static final TypeAdapter<SchemaColumn> ADAPTER = new TypeAdapter<SchemaColumn>(){

        public SchemaColumn read(JsonReader in) throws IOException {
            SchemaColumn ft = new SchemaColumn();
            in.beginObject();
            block34: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "name": {
                        ft.name = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "type": {
                        ft.type = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "comment": {
                        ft.comment = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "customFields": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.customFields = (JsonObject)JSON.gson().fromJson(in, JsonObject.class);
                        continue block34;
                    }
                    case "originalType": {
                        ft.originalType = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "originalSQLType": {
                        ft.originalSQLType = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "meaning": {
                        ft.meaning = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "downcastedToStringFromMeaning": {
                        ft.downcastedToStringFromMeaning = GsonTypeAdapterUtils.nullSafeNextString((JsonReader)in);
                        continue block34;
                    }
                    case "timestampNoTzAsDate": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.timestampNoTzAsDate = in.nextBoolean();
                        continue block34;
                    }
                    case "maxLength": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.maxLength = in.nextInt();
                        continue block34;
                    }
                    case "isColumnEdited": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.isColumnEdited = in.nextBoolean();
                        continue block34;
                    }
                    case "objectFields": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.objectFields = new ArrayList<SchemaColumn>();
                        in.beginArray();
                        while (in.hasNext()) {
                            ft.objectFields.add(this.read(in));
                        }
                        in.endArray();
                        continue block34;
                    }
                    case "arrayContent": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.arrayContent = this.read(in);
                        continue block34;
                    }
                    case "mapKeys": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.mapKeys = this.read(in);
                        continue block34;
                    }
                    case "mapValues": {
                        if (!GsonTypeAdapterUtils.nextTokenIsNotNull((JsonReader)in)) continue block34;
                        ft.mapValues = this.read(in);
                        continue block34;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return ft;
        }

        public void write(JsonWriter out, SchemaColumn cl) throws IOException {
            if (cl == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            if (JSON.isInPrettyPrinting()) {
                out.setIndent("");
            }
            out.name("name").value(cl.name);
            out.name("type").value(cl.type);
            if (cl.comment != null) {
                out.name("comment").value(cl.comment);
            }
            if (cl.customFields != null) {
                out.name("customFields");
                JSON.gson().toJson((JsonElement)cl.customFields, out);
            }
            if (cl.originalType != null) {
                out.name("originalType").value(cl.originalType);
            }
            if (cl.originalSQLType != null) {
                out.name("originalSQLType").value(cl.originalSQLType);
            }
            if (cl.meaning != null) {
                out.name("meaning").value(cl.meaning);
            }
            if (cl.downcastedToStringFromMeaning != null) {
                out.name("downcastedToStringFromMeaning").value(cl.downcastedToStringFromMeaning);
            }
            if (cl.timestampNoTzAsDate) {
                out.name("timestampNoTzAsDate").value(cl.timestampNoTzAsDate);
            }
            if (cl.isColumnEdited) {
                out.name("isColumnEdited").value(cl.isColumnEdited);
            }
            if (cl.maxLength >= 0) {
                out.name("maxLength").value((long)cl.maxLength);
            }
            if (cl.objectFields != null) {
                out.name("objectFields");
                out.beginArray();
                if (JSON.isInPrettyPrinting()) {
                    out.setIndent("  ");
                }
                for (SchemaColumn cl2 : cl.objectFields) {
                    this.write(out, cl2);
                }
                out.endArray();
            }
            if (cl.arrayContent != null) {
                out.name("arrayContent");
                this.write(out, cl.arrayContent);
            }
            if (cl.mapKeys != null) {
                out.name("mapKeys");
                this.write(out, cl.mapKeys);
            }
            if (cl.mapValues != null) {
                out.name("mapValues");
                this.write(out, cl.mapValues);
            }
            out.endObject();
            if (JSON.isInPrettyPrinting()) {
                out.setIndent("  ");
            }
        }
    };

    public SchemaColumn() {
    }

    public SchemaColumn(String name, Type type) {
        this.name = name;
        this.setType(type);
    }

    public SchemaColumn(String name, Type type, int maxLength) {
        this.name = name;
        this.setType(type);
        this.maxLength = maxLength;
    }

    public SchemaColumn(SchemaColumn other) {
        this.name = other.getName();
        this.setType(other.getType());
        this.comment = other.comment;
        this.meaning = other.meaning;
        this.maxLength = other.maxLength;
        this.timestampNoTzAsDate = other.timestampNoTzAsDate;
        this.originalType = other.originalType;
        this.originalSQLType = other.originalSQLType;
        this.isColumnEdited = other.isColumnEdited;
        if (other.customFields != null) {
            this.customFields = (JsonObject)JSON.deepCopy((Object)other.customFields);
        }
        if (other.objectFields != null) {
            this.objectFields = new ArrayList<SchemaColumn>();
            for (SchemaColumn otherField : other.objectFields) {
                this.objectFields.add(new SchemaColumn(otherField));
            }
        }
        if (other.arrayContent != null) {
            this.arrayContent = new SchemaColumn(other.arrayContent);
        }
        if (other.mapKeys != null) {
            this.mapKeys = new SchemaColumn(other.mapKeys);
        }
        if (other.mapValues != null) {
            this.mapValues = new SchemaColumn(other.mapValues);
        }
    }

    public void updateColumnContentIfNotNull(SchemaColumn columnInRecipe) {
        if (columnInRecipe.getMeaning() != null) {
            this.setMeaning(columnInRecipe.getMeaning());
        }
        if (columnInRecipe.comment != null) {
            this.comment = columnInRecipe.comment;
        }
        if (columnInRecipe.customFields != null) {
            this.customFields = (JsonObject)JSON.deepCopy((Object)columnInRecipe.customFields);
        }
        if (columnInRecipe.objectFields != null) {
            this.objectFields = columnInRecipe.objectFields;
        }
        if (columnInRecipe.arrayContent != null) {
            this.arrayContent = columnInRecipe.arrayContent;
        }
        if (columnInRecipe.mapKeys != null) {
            this.mapKeys = columnInRecipe.mapKeys;
        }
        if (columnInRecipe.mapValues != null) {
            this.mapValues = columnInRecipe.mapValues;
        }
        this.isColumnEdited = Objects.equals(columnInRecipe.comment, "") ? false : columnInRecipe.isColumnEdited;
    }

    public static SchemaColumn copyWithNewName(String name, SchemaColumn typeSrc) {
        SchemaColumn copied = new SchemaColumn(typeSrc);
        copied.name = name;
        return copied;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public SchemaColumn withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public SchemaColumn withOriginalType(String originalType) {
        this.originalType = originalType;
        return this;
    }

    public boolean hasOriginalType(String type) {
        return this.originalType != null && this.originalType.startsWith(type);
    }

    public SchemaColumn withOriginalSQLType(String originalSQLType) {
        this.originalSQLType = originalSQLType;
        return this;
    }

    public SchemaColumn withForcedMeaning(String meaning) {
        this.meaning = meaning;
        return this;
    }

    public SchemaColumn withTimestampNoTzAsDate(boolean timestampNoTzAsDate) {
        this.timestampNoTzAsDate = timestampNoTzAsDate;
        return this;
    }

    @Transient
    public Type getType() {
        if (this.otype == null) {
            this.otype = Type.forName(this.type.toLowerCase());
        }
        return this.otype;
    }

    public String getTypeString() {
        return this.type;
    }

    public SchemaColumn withType(Type type) {
        this.type = type.toString();
        this.otype = null;
        return this;
    }

    public void setType(Type type) {
        if (type == null) {
            return;
        }
        this.type = type.getName();
        this.otype = null;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public void setMeaning(String meaning) {
        assert (meaning == null || meaning.length() > 0);
        this.meaning = meaning;
    }

    public SchemaColumn withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public SchemaColumn withCustomFields(JsonObject customFields) {
        this.customFields = customFields;
        return this;
    }

    public static SchemaColumn simpleMap(String name, Type keyType, Type valueType) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(name);
        sc.setType(Type.MAP);
        sc.mapKeys = new SchemaColumn("", keyType);
        sc.mapValues = new SchemaColumn("", valueType);
        return sc;
    }

    public static SchemaColumn simpleMap(String name, Type keyType, int keyMaxLength, Type valueType, int valueMaxLength) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(name);
        sc.setType(Type.MAP);
        sc.mapKeys = new SchemaColumn("", keyType, keyMaxLength);
        sc.mapValues = new SchemaColumn("", valueType, valueMaxLength);
        return sc;
    }

    public static SchemaColumn simpleArray(String name, Type contentType) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(name);
        sc.setType(Type.ARRAY);
        sc.arrayContent = new SchemaColumn("", contentType);
        return sc;
    }

    public static SchemaColumn simpleArray(String name, Type contentType, int maxLength) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(name);
        sc.setType(Type.ARRAY);
        sc.arrayContent = new SchemaColumn("", contentType, maxLength);
        return sc;
    }

    public boolean isUpcastedTimestampTz(boolean inManagedDataset) {
        return this.getType() == Type.DATE && this.timestampNoTzAsDate && !inManagedDataset;
    }

    public SchemaColumn getFixedUp() {
        SchemaColumn sc = new SchemaColumn();
        sc.name = this.name;
        sc.timestampNoTzAsDate = this.timestampNoTzAsDate;
        sc.comment = this.comment;
        if (this.customFields != null) {
            sc.customFields = (JsonObject)JSON.deepCopy((Object)this.customFields);
        }
        sc.meaning = this.meaning;
        sc.maxLength = this.maxLength;
        sc.originalSQLType = this.originalSQLType;
        sc.isColumnEdited = this.isColumnEdited;
        boolean notFound = true;
        for (Type t : Type.values()) {
            if (!StringUtils.equals((String)t.getName(), (String)this.type)) continue;
            sc.setType(t);
            notFound = false;
        }
        if (notFound) {
            sc.setType(Type.STRING);
        }
        switch (sc.getType()) {
            case MAP: {
                sc.mapKeys = this.mapKeys == null ? new SchemaColumn(null, Type.STRING) : this.mapKeys.getFixedUp();
                if (this.mapValues == null) {
                    sc.mapValues = new SchemaColumn(null, Type.STRING);
                    break;
                }
                sc.mapValues = this.mapValues.getFixedUp();
                break;
            }
            case OBJECT: {
                sc.objectFields = new ArrayList<SchemaColumn>();
                if (this.objectFields != null) {
                    for (SchemaColumn field : this.objectFields) {
                        if (field == null) continue;
                        SchemaColumn fixed = field.getFixedUp();
                        sc.objectFields.add(fixed);
                    }
                }
                StringTransmogrifier transmogrifier = new StringTransmogrifier();
                for (SchemaColumn field : sc.objectFields) {
                    if (StringUtils.isBlank((String)field.name)) continue;
                    field.name = transmogrifier.transmogrify(field.name);
                }
                for (int i = 0; i < sc.objectFields.size(); ++i) {
                    SchemaColumn field = sc.objectFields.get(i);
                    if (!StringUtils.isBlank((String)field.name)) continue;
                    field.name = transmogrifier.transmogrify("field_" + i);
                }
                break;
            }
            case ARRAY: {
                if (this.arrayContent == null) {
                    sc.arrayContent = new SchemaColumn(null, Type.STRING);
                    break;
                }
                sc.arrayContent = this.arrayContent.getFixedUp();
                break;
            }
        }
        return sc;
    }

    public String toString() {
        return "Column {name='" + this.name + "', type='" + this.type + "', originalType='" + this.originalType + "'}";
    }
}

