/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.stream;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public interface EnrichedInputStream {
    public Compression getCompression();

    public boolean isArchive();

    public ArchiveInputStream archiveContent() throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public String getFilename();

    public String getPathWithinProvider();

    @Nonnull
    public LongSupplier getLastModifiedSupplier();

    public boolean repeatable();

    public long size() throws IOException;

    public Map<String, String> metas();

    public String desc();

    public Partition getPartition();

    public void setPartition(Partition var1);

    public InputStream rawStream() throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public InputStream rawHeadStream(long var1) throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public InputStream decompressedStream() throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public InputStream decompressedHeadStream(long var1) throws IOException, InterruptedException, CodedException, DKUSecurityException;

    public static enum Compression {
        NONE,
        GZIP,
        BZIP2,
        DEFLATE,
        LZO,
        SNAPPY,
        ZSTD;

        public static final String ZSTD_SUFFIX_ALT = ".zstd";
        public static final String ZSTD_SUFFIX = ".zst";
        public static final String GZ_SUFFIX = ".gz";
        public static final String SNAPPY_SUFFIX = ".snappy";
        public static final String DEFLATE_SUFFIX = ".deflate";
        public static final String LZO_SUFFIX = ".lzo";
        public static final String BZ2_SUFFIX = ".bz2";

        public static Compression getCompression(String fileName) {
            if (fileName == null) {
                return NONE;
            }
            String lFilename = fileName.toLowerCase(Locale.ENGLISH);
            if (lFilename.endsWith(GZ_SUFFIX)) {
                return GZIP;
            }
            if (lFilename.endsWith(BZ2_SUFFIX)) {
                return BZIP2;
            }
            if (lFilename.endsWith(DEFLATE_SUFFIX)) {
                return DEFLATE;
            }
            if (lFilename.endsWith(SNAPPY_SUFFIX)) {
                return SNAPPY;
            }
            if (lFilename.endsWith(LZO_SUFFIX)) {
                return LZO;
            }
            if (lFilename.endsWith(ZSTD_SUFFIX) || lFilename.endsWith(ZSTD_SUFFIX_ALT)) {
                return ZSTD;
            }
            return NONE;
        }
    }
}

