/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionType;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.j2ts.annotations.UIField;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

@UIModel(extraFields={@UIField(name="type", value="'value'")})
public class ExactValueDimension
extends Dimension {
    public static final String TYPE = "value";

    @Override
    public String getType() {
        return TYPE;
    }

    public static JsonObject serialize(ExactValueDimension dimension) {
        JsonObject json = new JsonObject();
        json.addProperty("name", dimension.name);
        return json;
    }

    public static ExactValueDimension deserialize(JsonObject json) {
        String name;
        String string = name = json.has("name") ? json.get("name").getAsString() : "";
        if (name.isEmpty()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_PARTITIONING_CONFIG, "Partitioning dimension name is required.");
        }
        return new ExactValueDimension(name);
    }

    public ExactValueDimension(String name) {
        super(name);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ExactValueDimension)) {
            return false;
        }
        ExactValueDimension tother = (ExactValueDimension)other;
        return this.name.equals(tother.name);
    }

    @Override
    public DimensionValue getValueFromId(String id) {
        return new ExactValueDimensionValue(id);
    }

    @Override
    public List<DimensionValue> getValuesFromPattern(String pattern) {
        String[] severalValues = pattern.split("/");
        ArrayList<DimensionValue> values = new ArrayList<DimensionValue>();
        for (String v : severalValues) {
            values.add(new ExactValueDimensionValue(v));
        }
        return values;
    }

    @Override
    public DimensionType toDimensionType() {
        return DimensionType.DISCRETE;
    }

    @Override
    public int hashCode() {
        throw new Error("hashCode not designed");
    }
}

