/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.TimeZone;

public class TimeDimensionValue
extends DimensionValue
implements Comparable<TimeDimensionValue> {
    private TimeDimension dimension;
    private int year;
    private int month;
    private int day;
    private int hour;

    public TimeDimensionValue(TimeDimension dimension) {
        this.dimension = dimension;
    }

    public TimeDimensionValue(TimeDimension dimension, int year) {
        Preconditions.checkArgument((dimension.mappedPeriod == TimeDimension.Period.YEAR ? 1 : 0) != 0, (Object)"Mapped period is not YEAR");
        this.dimension = dimension;
        this.year = year;
    }

    public TimeDimensionValue(TimeDimension dimension, int year, int month) {
        Preconditions.checkArgument((dimension.mappedPeriod == TimeDimension.Period.MONTH ? 1 : 0) != 0, (Object)"Mapped period is not MONTH");
        this.dimension = dimension;
        this.year = year;
        this.month = month;
    }

    public TimeDimensionValue(TimeDimension dimension, int year, int month, int day) {
        Preconditions.checkArgument((dimension.mappedPeriod == TimeDimension.Period.DAY ? 1 : 0) != 0, (Object)"Mapped period is not DAY");
        this.dimension = dimension;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public TimeDimensionValue(TimeDimension dimension, int year, int month, int day, int hour) {
        Preconditions.checkArgument((dimension.mappedPeriod == TimeDimension.Period.HOUR ? 1 : 0) != 0, (Object)"Mapped period is not HOUR");
        this.dimension = dimension;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
    }

    private TimeDimensionValue() {
    }

    public TimeDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(TimeDimension dimension) {
        this.dimension = dimension;
    }

    public TimeDimensionValue withDimension(TimeDimension dimension) {
        this.dimension = dimension;
        return this;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public TimeDimensionValue withYear(int year) {
        this.year = year;
        return this;
    }

    public TimeDimensionValue withMonth(int month) {
        this.month = month;
        return this;
    }

    public TimeDimensionValue withDay(int day) {
        this.day = day;
        return this;
    }

    public TimeDimensionValue withHour(int hour) {
        this.hour = hour;
        return this;
    }

    public void setCal(Calendar cal) {
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                this.setHour(cal.get(11));
            }
            case DAY: {
                this.setDay(cal.get(5));
            }
            case MONTH: {
                this.setMonth(cal.get(2) + 1);
            }
            case YEAR: {
                this.setYear(cal.get(1));
                break;
            }
            default: {
                throw new Error("Never reached");
            }
        }
    }

    public TimeDimensionValue withCal(Calendar cal) {
        this.setCal(cal);
        return this;
    }

    @Override
    public DimensionValue copy() {
        return new TimeDimensionValue().withDimension(this.dimension).withYear(this.year).withMonth(this.month).withDay(this.day).withHour(this.hour);
    }

    @Override
    public String id() {
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                return String.format("%04d-%02d-%02d-%02d", this.year, this.month, this.day, this.hour);
            }
            case DAY: {
                return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
            }
            case MONTH: {
                return String.format("%04d-%02d", this.year, this.month);
            }
            case YEAR: {
                return String.format("%04d", this.year);
            }
        }
        throw new Error("Must not be reached");
    }

    public String resolvePattern(String pattern) {
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                pattern = pattern.replace("%H", String.format("%02d", this.hour)).replace("%0H", String.format("%02d", this.hour)).replace("%_H", String.format("%d", this.hour));
            }
            case DAY: {
                pattern = pattern.replace("%D", String.format("%02d", this.day)).replace("%0D", String.format("%02d", this.day)).replace("%_D", String.format("%d", this.day));
            }
            case MONTH: {
                pattern = pattern.replace("%M", String.format("%02d", this.month)).replace("%0M", String.format("%02d", this.month)).replace("%_M", String.format("%d", this.month));
            }
            case YEAR: {
                pattern = pattern.replace("%Y", String.format("%04d", this.year));
            }
        }
        return pattern;
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        this.fillCalendar(cal);
        return cal;
    }

    private void fillCalendar(Calendar cal) {
        cal.setTimeInMillis(0L);
        cal.set(11, 0);
        cal.set(5, 1);
        cal.set(2, 0);
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                cal.set(11, this.hour);
            }
            case DAY: {
                cal.set(5, this.day);
            }
            case MONTH: {
                cal.set(2, this.month - 1);
            }
            case YEAR: {
                cal.set(1, this.year);
                break;
            }
            default: {
                assert (false) : "Must not be reached.";
                break;
            }
        }
    }

    public Calendar getUTCCalendar() {
        Calendar cal = this.getCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return cal;
    }

    public LocalDate getLocalDate() {
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                throw new IllegalArgumentException("Hour partitining is not possible on local dates");
            }
            case DAY: {
                return LocalDate.of(this.year, this.month, this.day);
            }
            case MONTH: {
                return LocalDate.of(this.year, this.month, 1);
            }
            case YEAR: {
                return LocalDate.of(this.year, 1, 1);
            }
        }
        throw new IllegalArgumentException("Invalid period " + String.valueOf((Object)this.dimension.mappedPeriod));
    }

    public TimeDimensionValue nextPeriod() {
        Calendar cal = this.getCalendar();
        switch (this.dimension.mappedPeriod) {
            case HOUR: {
                cal.add(11, 1);
                break;
            }
            case DAY: {
                cal.add(5, 1);
                break;
            }
            case MONTH: {
                cal.add(2, 1);
                break;
            }
            case YEAR: {
                cal.add(1, 1);
            }
        }
        return new TimeDimensionValue(this.dimension).withCal(cal);
    }

    public String getPeriodValue(TimeDimension.Period period) {
        switch (period) {
            case HOUR: {
                return this.dimension.hasHour() ? "" + this.hour : null;
            }
            case DAY: {
                return this.dimension.hasDay() ? "" + this.day : null;
            }
            case MONTH: {
                return this.dimension.hasMonth() ? "" + this.month : null;
            }
            case YEAR: {
                return this.dimension.hasYear() ? "" + this.year : null;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimeDimensionValue)) {
            return false;
        }
        return ((TimeDimensionValue)o).id().equals(this.id());
    }

    @Override
    public int hashCode() {
        return this.id().hashCode();
    }

    @Override
    public int compareTo(TimeDimensionValue timeDimensionValue) {
        return this.getCalendar().compareTo(timeDimensionValue.getCalendar());
    }
}

