/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh;

import com.dataiku.dip.server.CountWriterFilter;
import com.dataiku.dip.server.DkuStandardServletMultipartResolver;
import com.dataiku.dip.server.EarlyCallTimingStartFilter;
import com.dataiku.dip.server.SlowAndFailInterceptor;
import com.dataiku.dip.server.controllers.RequestParamJsonConverter;
import com.dataiku.dip.server.controllers.RequestResponseBodyJsonConverter;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.server.ApplicationStarter;
import com.dataiku.gh.server.controllers.DKUDispatcherServlet;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class GHBackendInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.register(new Class[]{RootContextConfiguration.class});
        GHSpring.registerServerServices(rootContext);
        AnnotationConfigWebApplicationContext dispatcherContext = new AnnotationConfigWebApplicationContext();
        dispatcherContext.setParent((ApplicationContext)rootContext);
        dispatcherContext.register(new Class[]{DispatcherServletConfiguration.class});
        GHSpring.registerServerControllers(dispatcherContext);
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        servletContext.addListener((EventListener)((Object)new ApplicationStarter()));
        FilterRegistration.Dynamic filterConfig = servletContext.addFilter("EarlyCallTimingStartFilter", EarlyCallTimingStartFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CountWriterFilter", CountWriterFilter.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        filterConfig = servletContext.addFilter("CorsFilter", DelegatingFilterProxy.class);
        filterConfig.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/publicapi/*"});
        ServletRegistration.Dynamic servletConfig = servletContext.addServlet("dispatcher", (Servlet)new DKUDispatcherServlet((WebApplicationContext)dispatcherContext));
        servletConfig.setLoadOnStartup(1);
        servletConfig.addMapping(new String[]{"/"});
        servletConfig.setMultipartConfig(ServletUtils.getMultipartConfigElement((File)new File(ApplicationConfigurator.getBaseFolderF(), "tmp/upload-multipart"), (int)1000000));
    }

    @Configuration
    @EnableAspectJAutoProxy
    public static class RootContextConfiguration {
    }

    @NotInRootContext
    @Configuration
    @EnableAspectJAutoProxy
    public static class DispatcherServletConfiguration
    extends WebMvcConfigurationSupport {
        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.add((HttpMessageConverter<?>)new RequestResponseBodyJsonConverter());
            this.addDefaultHttpMessageConverters(converters);
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)new SlowAndFailInterceptor());
        }

        public FormattingConversionService mvcConversionService() {
            DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(false);
            conversionService.addConverter((GenericConverter)new RequestParamJsonConverter());
            return conversionService;
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
        }

        @Bean
        public MultipartResolver multipartResolver() {
            return new DkuStandardServletMultipartResolver();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NotInRootContext {
    }
}

