/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.DKU;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class CLICommand {
    public int usage(int retcode, String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        new HelpFormatter().printHelp(this.usageString() + "\n" + this.description(), this.opts());
        return retcode;
    }

    public abstract String usageString();

    public abstract String description();

    public abstract Options opts();

    public abstract int execute(String[] var1) throws Exception;

    void onPostExecute() {
    }

    protected int fatalErrorNoStack(String fmt, Object ... data) {
        System.err.println("dku: error: " + String.format(fmt, data));
        return 1;
    }

    protected CommandLine parseAndMiniSetup(String[] args, String expectedCommandName) throws ParseException, IOException {
        return this.parseAndMiniSetup(args, expectedCommandName, true);
    }

    protected CommandLine parseAndMiniSetup(String[] args, String expectedCommandName, boolean initConfig) throws ParseException, IOException {
        CommandLine cmdLine = new DefaultParser().parse(this.opts(), args);
        if (cmdLine.hasOption('h')) {
            this.usage(0, null);
            throw new DKU.EndOfCommandException();
        }
        assert (cmdLine.getArgs().length >= 1);
        assert (cmdLine.getArgs()[0].equals(expectedCommandName));
        GHSpring.setupVerbose(cmdLine);
        if (initConfig) {
            GHSpring.doMiniSetup();
        }
        return cmdLine;
    }
}

