/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfigurationWithSource;
import com.dataiku.gh.core.models.governance.InstanceAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArtifactAutoGovernanceConfigurationController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAutoGovernanceConfigurationService autoGovernanceConfigurationService;

    @AuditInline
    @RequestMapping(value={"/api/artifact-autogovernance-config/get-effective"}, method={RequestMethod.GET})
    @ResponseBody
    public ArtifactAutoGovernanceConfigurationWithSource getEffectiveAutogovernConfiguration(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        String getAuditTrailServiceType = "dss-auto-govern-configuration-get-effective";
        try {
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.auditTrailService.generic(getAuditTrailServiceType).with("artifactId", artifactId).emit();
            return this.autoGovernanceConfigurationService.getEffectiveConfigurationForArtifact(authCtx, artifactId);
        }
        catch (Exception e) {
            this.auditTrailService.failure(getAuditTrailServiceType, (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-autogovernance-config/get-instance"}, method={RequestMethod.GET})
    @ResponseBody
    public InstanceAutoGovernanceConfiguration getInstanceAutogovernConfiguration(HttpServletRequest req) throws Exception {
        String getAuditTrailServiceType = "dss-instance-auto-govern-configuration-get";
        try {
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.auditTrailService.generic(getAuditTrailServiceType).emit();
            return this.autoGovernanceConfigurationService.getInstanceDefaultAutoGovernanceConfiguration(authCtx);
        }
        catch (Exception e) {
            this.auditTrailService.failure(getAuditTrailServiceType, (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-autogovernance-config/get-for-governed-project"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ArtifactAutoGovernanceConfigurationWithSource> getAutogovernConfigurationListForGovernProject(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        String getGovernProjectAuditTrailServiceType = "dss-auto-govern-configuration-get-govern-project";
        try {
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.auditTrailService.generic(getGovernProjectAuditTrailServiceType).with("artifactId", artifactId).emit();
            return this.autoGovernanceConfigurationService.getEffectiveConfigurationsForGovernProject(authCtx, artifactId);
        }
        catch (Exception e) {
            this.auditTrailService.failure(getGovernProjectAuditTrailServiceType, (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-autogovernance-config/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ARTIFACT_AUTOGOVERNANCE_CONFIG_UPDATE)
    @ResponseBody
    public ArtifactAutoGovernanceConfigurationWithSource upsertAutogovernConfiguration(HttpServletRequest req, @RequestParam ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration) throws Exception {
        String putAuditTrailServiceType = "dss-auto-govern-configuration-save";
        try {
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArtifactAutoGovernanceConfigurationWithSource updatedDSSArtifactAutoGovernConfiguration = this.autoGovernanceConfigurationService.upsertConfigurationForArtifact(authCtx, artifactAutoGovernanceConfiguration);
            this.auditTrailService.generic(putAuditTrailServiceType).with("artifactId", artifactAutoGovernanceConfiguration.artifactId).emit();
            return updatedDSSArtifactAutoGovernConfiguration;
        }
        catch (Exception e) {
            this.auditTrailService.failure(putAuditTrailServiceType, (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-autogovernance-config/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ARTIFACT_AUTOGOVERNANCE_CONFIG_DELETE)
    @ResponseBody
    public void deleteAutogovernConfiguration(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        String deleteAuditTrailServiceType = "dss-auto-govern-configuration-delete";
        try {
            AuthCtx authCtx;
            try (Transaction ignored = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.autoGovernanceConfigurationService.deleteConfigurationForArtifact(authCtx, artifactId);
            this.auditTrailService.generic(deleteAuditTrailServiceType).with("artifactId", artifactId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure(deleteAuditTrailServiceType, (Throwable)e).emit();
            throw e;
        }
    }
}

