/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.artifacts.ArtifactDescription;
import com.dataiku.gh.core.models.dss.DataikuDeploymentSourceObjects;
import com.dataiku.gh.core.models.dss.DataikuSourceObjects;
import com.dataiku.gh.core.models.governance.ManualGovernanceSettings;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.dss.govern.IDSSIntegrationService;
import com.dataiku.gh.core.services.governance.manual.IManualGovernanceService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DSSIntegrationController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IManualGovernanceService manualGovernanceService;
    @Autowired
    private IDSSIntegrationService dssIntegrationService;

    @AuditInline
    @RequestMapping(value={"/api/dss/govern"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GOVERN_ARTIFACT)
    @ResponseBody
    public ArtifactDescription govern(HttpServletRequest req, @RequestParam String artifactId, @RequestParam ManualGovernanceSettings manualGovernanceSettings) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.manualGovernanceService.governArtifactFromUserInput(authCtx, artifactId, manualGovernanceSettings);
            this.auditTrailService.generic("dss-govern").with("artifactId", artifactId).emit();
            return ArtifactDescription.build(artifactId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-govern", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/dss/set-visibility"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GOVERN_VISIBILITY_UPDATE)
    @ResponseBody
    public ArtifactDescription setVisibility(HttpServletRequest req, @RequestParam String artifactId, @RequestParam Boolean hidden) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.dssIntegrationService.setArtifactVisibility(authCtx, artifactId, hidden);
            this.auditTrailService.generic("dss-set-visibility").with("artifactId", artifactId).with("hidden", hidden.booleanValue()).emit();
            return ArtifactDescription.build(artifactId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("dss-set-visibility", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "dss-set-multiple-visibilities", "artifactIds", "${artifactIds}", "hidden", "${hidden}"})
    @RequestMapping(value={"/api/dss/set-multiple-visibilities"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GOVERN_MULTIPLE_VISIBILITIES_UPDATE)
    @ResponseBody
    public List<ArtifactDescription> setMultipleVisibilities(HttpServletRequest req, @RequestParam List<String> artifactIds, @RequestParam Boolean hidden) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.setArtifactVisibilities(authCtx, artifactIds, hidden).stream().map(ArtifactDescription::build).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "list-related-projects", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/list-related-projects"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIArtifact> listRelatedProjects(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.listRelatedProjects(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "get-dataiku-sources", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/get-dataiku-sources"}, method={RequestMethod.GET})
    @ResponseBody
    public DataikuSourceObjects getDataikuSources(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.getDataikuSources(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "get-dataiku-deployment-sources", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/get-dataiku-deployment-sources"}, method={RequestMethod.GET})
    @ResponseBody
    public DataikuDeploymentSourceObjects getDataikuDeploymentSources(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.getDataikuDeploymentSources(authCtx, artifactId);
    }
}

