/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.dss;

import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetricDatapoints;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class DSSArtifactContainer<T extends DSSArtifactContainer<T>> {
    public final Artifact artifact;
    public AutoGovernanceConfiguration autoGovernanceConfiguration;
    public boolean isCreation;

    protected DSSArtifactContainer(Artifact artifact) {
        this.artifact = artifact;
    }

    protected DSSArtifactContainer(Artifact artifact, boolean isCreation) {
        this.artifact = artifact;
        this.isCreation = isCreation;
    }

    public String getIdentifier() {
        return Optional.ofNullable(this.artifact).map(a -> a.fields.get(this.getIdentifierKey())).orElse(null);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public abstract T cloneWith(Artifact var1);

    protected abstract String getIdentifierKey();

    public static DSSProjectArtifactContainer buildProject(Artifact artifact) {
        return DSSArtifactContainer.buildProject(artifact, false);
    }

    public static DSSProjectArtifactContainer buildProject(Artifact artifact, boolean isCreation) {
        return new DSSProjectArtifactContainer(artifact, isCreation);
    }

    public static DSSBundleArtifactContainer buildBundle(Artifact artifact) {
        return new DSSBundleArtifactContainer(artifact);
    }

    public static DSSDatasetArtifactContainer buildDataset(Artifact artifact) {
        return new DSSDatasetArtifactContainer(artifact);
    }

    public static DSSSavedModelArtifactContainer buildSavedModel(Artifact artifact) {
        return new DSSSavedModelArtifactContainer(artifact);
    }

    public static DSSRetrievableKnowledgeArtifactContainer buildRetrievableKnowledge(Artifact artifact) {
        return new DSSRetrievableKnowledgeArtifactContainer(artifact);
    }

    public static DSSSavedModelVersionArtifactContainer buildSavedModelVersion(Artifact artifact) {
        return new DSSSavedModelVersionArtifactContainer(artifact, null);
    }

    public static DSSSavedModelVersionArtifactContainer buildSavedModelVersion(Artifact artifact, @Nullable List<DSSSavedModelVersionEvaluationMetricDatapoints> metricPointsList) {
        return new DSSSavedModelVersionArtifactContainer(artifact, metricPointsList);
    }

    public static DSSProjectDeployerInfraArtifactContainer buildProjectDeployerInfra(Artifact artifact) {
        return new DSSProjectDeployerInfraArtifactContainer(artifact);
    }

    public static DSSAPIDeployerInfraArtifactContainer buildAPIDeployerInfra(Artifact artifact) {
        return new DSSAPIDeployerInfraArtifactContainer(artifact);
    }

    public static DSSAPIDeployerDeploymentArtifactContainer buildAPIDeployerDeployment(Artifact artifact) {
        return new DSSAPIDeployerDeploymentArtifactContainer(artifact);
    }

    public static DSSProjectDeployerDeploymentArtifactContainer buildProjectDeployerDeployment(Artifact artifact) {
        return new DSSProjectDeployerDeploymentArtifactContainer(artifact);
    }

    public static class DSSProjectArtifactContainer
    extends DSSArtifactContainer<DSSProjectArtifactContainer> {
        protected DSSProjectArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        protected DSSProjectArtifactContainer(Artifact artifact, boolean isCreation) {
            super(artifact, isCreation);
        }

        @Override
        public DSSProjectArtifactContainer cloneWith(Artifact artifact) {
            return new DSSProjectArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "project_key";
        }
    }

    public static class DSSBundleArtifactContainer
    extends DSSArtifactContainer<DSSBundleArtifactContainer> {
        protected DSSBundleArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSBundleArtifactContainer cloneWith(Artifact artifact) {
            return new DSSBundleArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "bundle_id";
        }
    }

    public static class DSSDatasetArtifactContainer
    extends DSSArtifactContainer<DSSDatasetArtifactContainer> {
        protected DSSDatasetArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSDatasetArtifactContainer cloneWith(Artifact artifact) {
            return new DSSDatasetArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "dataset_name";
        }
    }

    public static class DSSSavedModelArtifactContainer
    extends DSSArtifactContainer<DSSSavedModelArtifactContainer> {
        protected DSSSavedModelArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSSavedModelArtifactContainer cloneWith(Artifact artifact) {
            return new DSSSavedModelArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "saved_model_id";
        }
    }

    public static class DSSRetrievableKnowledgeArtifactContainer
    extends DSSArtifactContainer<DSSRetrievableKnowledgeArtifactContainer> {
        protected DSSRetrievableKnowledgeArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSRetrievableKnowledgeArtifactContainer cloneWith(Artifact artifact) {
            return new DSSRetrievableKnowledgeArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "retrievable_knowledge_id";
        }
    }

    public static class DSSSavedModelVersionArtifactContainer
    extends DSSArtifactContainer<DSSSavedModelVersionArtifactContainer> {
        public final List<DSSSavedModelVersionEvaluationMetricDatapoints> metricPointsList;

        protected DSSSavedModelVersionArtifactContainer(Artifact artifact, @Nullable List<DSSSavedModelVersionEvaluationMetricDatapoints> metricPointsList) {
            super(artifact);
            this.metricPointsList = Optional.ofNullable(metricPointsList).orElse(new ArrayList());
        }

        @Override
        public DSSSavedModelVersionArtifactContainer cloneWith(Artifact artifact) {
            return new DSSSavedModelVersionArtifactContainer(artifact, this.metricPointsList);
        }

        @Override
        protected String getIdentifierKey() {
            return "full_model_version_id";
        }

        public boolean isTimeseriesEnabled() {
            return Objects.equals(this.artifact.blueprintVersionId, SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.prediction"));
        }
    }

    public static class DSSProjectDeployerInfraArtifactContainer
    extends DSSArtifactContainer<DSSProjectDeployerInfraArtifactContainer> {
        protected DSSProjectDeployerInfraArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSProjectDeployerInfraArtifactContainer cloneWith(Artifact artifact) {
            return new DSSProjectDeployerInfraArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "infrastructure_id";
        }
    }

    public static class DSSAPIDeployerInfraArtifactContainer
    extends DSSArtifactContainer<DSSAPIDeployerInfraArtifactContainer> {
        protected DSSAPIDeployerInfraArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSAPIDeployerInfraArtifactContainer cloneWith(Artifact artifact) {
            return new DSSAPIDeployerInfraArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "infrastructure_id";
        }
    }

    public static class DSSAPIDeployerDeploymentArtifactContainer
    extends DSSArtifactContainer<DSSAPIDeployerDeploymentArtifactContainer> {
        protected DSSAPIDeployerDeploymentArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSAPIDeployerDeploymentArtifactContainer cloneWith(Artifact artifact) {
            return new DSSAPIDeployerDeploymentArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "deployment_id";
        }
    }

    public static class DSSProjectDeployerDeploymentArtifactContainer
    extends DSSArtifactContainer<DSSProjectDeployerDeploymentArtifactContainer> {
        protected DSSProjectDeployerDeploymentArtifactContainer(Artifact artifact) {
            super(artifact);
        }

        @Override
        public DSSProjectDeployerDeploymentArtifactContainer cloneWith(Artifact artifact) {
            return new DSSProjectDeployerDeploymentArtifactContainer(artifact);
        }

        @Override
        protected String getIdentifierKey() {
            return "deployment_id";
        }
    }
}

