/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.governance.ModelAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ProjectAutoGovernanceConfiguration;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import javax.annotation.Nullable;

@UIModel
public class ManualGovernanceSettings {
    @Nullable
    public ProjectSettings projectSettings;
    @Nullable
    public ProjectAutoGovernanceConfiguration projectAutoGovernanceConfiguration;
    @Nullable
    public BundleSettings bundleSettings;
    @Nullable
    public ModelSettings modelSettings;
    @Nullable
    public ModelVersionSettings modelVersionSettings;
    @Nullable
    public ModelAutoGovernanceConfiguration modelAutoGovernanceConfiguration;
    @UINullable
    public boolean deleteAutoGovernanceConfiguration = false;

    public static ManualGovernanceSettings build() {
        return ManualGovernanceSettings.build(null, null, null, null);
    }

    public static ManualGovernanceSettings build(@Nullable ProjectSettings projectSettings, @Nullable BundleSettings bundleSettings, @Nullable ModelSettings modelSettings, @Nullable ModelVersionSettings modelVersionSettings) {
        ManualGovernanceSettings manualGovernanceSettings = new ManualGovernanceSettings();
        manualGovernanceSettings.projectSettings = projectSettings;
        manualGovernanceSettings.bundleSettings = bundleSettings;
        manualGovernanceSettings.modelSettings = modelSettings;
        manualGovernanceSettings.modelVersionSettings = modelVersionSettings;
        return manualGovernanceSettings;
    }

    @PolyJSON(value={@Mapping(value=CreateProjectSettings.class, type="create"), @Mapping(value=ExistingProjectSettings.class, type="existing")})
    public static abstract class ProjectSettings {
        public boolean governChildrenBundles;
        public boolean governChildrenSavedModels;
    }

    public static class BundleSettings {
        public String versionId;

        public static BundleSettings build(String versionId) {
            BundleSettings bundleSettings = new BundleSettings();
            bundleSettings.versionId = versionId;
            return bundleSettings;
        }
    }

    public static class ModelSettings {
        public String versionId;
        public boolean governChildrenSavedModelVersions;

        public static ModelSettings build(String versionId, boolean governChildrenVersions) {
            ModelSettings modelSettings = new ModelSettings();
            modelSettings.versionId = versionId;
            modelSettings.governChildrenSavedModelVersions = governChildrenVersions;
            return modelSettings;
        }
    }

    public static class ModelVersionSettings {
        public String versionId;

        public static ModelVersionSettings build(String versionId) {
            ModelVersionSettings modelVersionSettings = new ModelVersionSettings();
            modelVersionSettings.versionId = versionId;
            return modelVersionSettings;
        }
    }

    public static class ExistingProjectSettings
    extends ProjectSettings {
        public static final String TYPE = "existing";
        public String artifactId;

        public static ExistingProjectSettings build(String artifactId, boolean governChildrenBundles, boolean governChildrenSavedModels) {
            ExistingProjectSettings existingProjectSettings = new ExistingProjectSettings();
            existingProjectSettings.artifactId = artifactId;
            existingProjectSettings.governChildrenBundles = governChildrenBundles;
            existingProjectSettings.governChildrenSavedModels = governChildrenSavedModels;
            return existingProjectSettings;
        }
    }

    public static class CreateProjectSettings
    extends ProjectSettings {
        public static final String TYPE = "create";
        public String versionId;
        @Nullable
        public String businessInitiativeArtifactId;

        public static CreateProjectSettings build(String versionId, boolean governChildrenBundles, boolean governChildrenSavedModels, @Nullable String businessInitiativeArtifactId) {
            CreateProjectSettings createProjectSettings = new CreateProjectSettings();
            createProjectSettings.versionId = versionId;
            createProjectSettings.governChildrenBundles = governChildrenBundles;
            createProjectSettings.governChildrenSavedModels = governChildrenSavedModels;
            createProjectSettings.businessInitiativeArtifactId = businessInitiativeArtifactId;
            return createProjectSettings;
        }
    }
}

