/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.gh.core.models.search.SubqueryArtifactSearchSourceConfig;
import com.dataiku.gh.core.visitors.IArtifactSearchSourceVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@UIModel
public class ArtifactSearchSourceConfig {

    public static class SubqueriesArtifactSearchSource
    extends ArtifactSearchSource {
        public static final String TYPE = "subqueries";
        public List<SubqueryArtifactSearchSourceConfig> subqueriesArtifactSearchSourceConfigs = new ArrayList<SubqueryArtifactSearchSourceConfig>();

        @Override
        public boolean isSearchSourceEmpty() {
            return CollectionUtils.isEmpty(this.subqueriesArtifactSearchSourceConfigs);
        }

        @Override
        public void accept(IArtifactSearchSourceVisitor visitor) {
            visitor.visit(this);
        }

        public static SubqueriesArtifactSearchSource build(SubqueryArtifactSearchSourceConfig ... artifactSearchSourceSubqueryConfigs) {
            SubqueriesArtifactSearchSource source = new SubqueriesArtifactSearchSource();
            source.subqueriesArtifactSearchSourceConfigs = Arrays.asList(artifactSearchSourceSubqueryConfigs);
            return source;
        }
    }

    public static class AllArtifactSearchSource
    extends ArtifactSearchSource {
        public static final String TYPE = "all";

        @Override
        public boolean isSearchSourceEmpty() {
            return false;
        }

        @Override
        public void accept(IArtifactSearchSourceVisitor visitor) {
            visitor.visit(this);
        }

        public static AllArtifactSearchSource build() {
            return new AllArtifactSearchSource();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    @PolyJSON(value={@Mapping(value=AllArtifactSearchSource.class, type="all"), @Mapping(value=SubqueriesArtifactSearchSource.class, type="subqueries")})
    public static abstract class ArtifactSearchSource {
        public abstract boolean isSearchSourceEmpty();

        public abstract void accept(IArtifactSearchSourceVisitor var1);
    }
}

