/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts.context;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class EnrichedArtifactContext {
    private static final ThreadLocal<ParentContextContainer> currentContext = new ThreadLocal();

    public static EnrichedArtifactContextContainer attachNewContextOrKeepExistingOne() {
        if (EnrichedArtifactContext.hasContext()) {
            return new ChildContextContainer(currentContext.get());
        }
        ParentContextContainer context = new ParentContextContainer();
        currentContext.set(context);
        return context;
    }

    private static boolean hasContext() {
        return currentContext.get() != null;
    }

    private static void clearContext() {
        currentContext.remove();
    }

    private static class ChildContextContainer
    implements EnrichedArtifactContextContainer {
        private final ParentContextContainer parentContextContainer;

        private ChildContextContainer(ParentContextContainer parentContextContainer) {
            this.parentContextContainer = parentContextContainer;
        }

        @Override
        public void addEnrichedArtifact(EnrichedArtifact enrichedArtifact) {
            this.parentContextContainer.addEnrichedArtifact(enrichedArtifact);
        }

        @Override
        @Nullable
        public EnrichedArtifact getEnrichedArtifact(String artifactId) {
            return this.parentContextContainer.getEnrichedArtifact(artifactId);
        }

        @Override
        public void close() {
        }
    }

    private static class ParentContextContainer
    implements EnrichedArtifactContextContainer {
        public final Map<String, EnrichedArtifact> enrichedArtifactsCacheMap = new HashMap<String, EnrichedArtifact>();

        private ParentContextContainer() {
        }

        @Override
        public void close() {
            EnrichedArtifactContext.clearContext();
        }

        @Override
        public void addEnrichedArtifact(EnrichedArtifact enrichedArtifact) {
            this.enrichedArtifactsCacheMap.put(enrichedArtifact.artifact.id, enrichedArtifact);
        }

        @Override
        @Nullable
        public EnrichedArtifact getEnrichedArtifact(String artifactId) {
            return this.enrichedArtifactsCacheMap.get(artifactId);
        }
    }

    public static interface EnrichedArtifactContextContainer
    extends AutoCloseable {
        public void addEnrichedArtifact(EnrichedArtifact var1);

        @Nullable
        public EnrichedArtifact getEnrichedArtifact(String var1);

        @Override
        public void close();
    }
}

