/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.search_artifacts;

import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDatasetIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSRetrievableKnowledgeIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.dss_gh.api.visitors.IDSSItemIdentifierVisitor;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationArtifactsSearchQueryBuilder;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationUtils;
import com.dataiku.gh.core.services.dss.search_artifacts.IDSSIntegrationSearchArtifactsService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSIntegrationSearchArtifactsService
implements IDSSIntegrationSearchArtifactsService {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;

    @Override
    public DSSProjectArtifactsContainer findDSSArtifacts(List<ArtifactFilter> filters) throws IOException {
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            DSSProjectArtifactsContainer dSSProjectArtifactsContainer = DSSIntegrationUtils.mapSearchResultToDSSContainer(searchResults.collect(Collectors.toList()));
            return dSSProjectArtifactsContainer;
        }
    }

    @Override
    public Artifact findDSSProjectArtifact(DSSProjectIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_PROJECT), Collections.emptyList());
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSProject()).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public DSSProjectArtifactsContainer findDSSProjectArtifacts(DSSProjectIdentifier dssProjectIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(dssProjectIdentifier, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList(SystemProvidedConstants.DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values()), Collections.emptyList());
        return this.findDSSArtifacts(filters);
    }

    @Override
    public DSSProjectArtifactsContainer findDSSProjectArtifactsWithAutoGovernSettings(DSSProjectIdentifier dssProjectIdentifier) throws IOException {
        DSSProjectArtifactsContainer dssProjectArtifactsContainer = this.findDSSProjectArtifacts(dssProjectIdentifier);
        if (dssProjectArtifactsContainer.getDSSProject() == null) {
            return dssProjectArtifactsContainer;
        }
        return this.autoGovernanceConfigurationDataService.fillArtifactContainerWithEffectiveAutoGovernConfigurations(dssProjectArtifactsContainer);
    }

    @Override
    public DSSDeployerArtifactsContainer findDSSDeployerArtifacts(String nodeId) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(nodeId, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList(SystemProvidedConstants.DEPLOYER_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values()), Collections.emptyList());
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            DSSDeployerArtifactsContainer dSSDeployerArtifactsContainer = DSSIntegrationUtils.mapDeployerSearchResultToContainer(searchResults.collect(Collectors.toList()));
            return dSSDeployerArtifactsContainer;
        }
    }

    @Override
    public Artifact findDSSBundleArtifact(DSSBundleIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_BUNDLE), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("bundle_id", dssItemIdentifier.bundleId, false, false)));
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSBundles().get(dssItemIdentifier.bundleId)).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public Artifact findDSSDatasetArtifact(DSSDatasetIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_DATASET), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("dataset_name", dssItemIdentifier.datasetName, false, false)));
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSDatasets().get(dssItemIdentifier.datasetName)).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public Artifact findDSSSavedModelArtifact(DSSSavedModelIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_SAVED_MODEL), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("saved_model_id", dssItemIdentifier.savedModelId, false, false)));
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSSavedModels().get(dssItemIdentifier.savedModelId)).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public Artifact findDSSRetrievableKnowledgeArtifact(DSSRetrievableKnowledgeIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("retrievable_knowledge_id", dssItemIdentifier.retrievableKnowledgeId, false, false)));
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSRetrievableKnowledges().get(dssItemIdentifier.retrievableKnowledgeId)).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public Artifact findDSSSavedModelVersionArtifact(DSSSavedModelVersionIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)dssItemIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("saved_model_id", dssItemIdentifier.savedModelId, false, false), DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("full_model_version_id", dssItemIdentifier.fullModelVersionId, false, false)}));
        DSSProjectArtifactsContainer existingArtifacts = this.findDSSArtifacts(filters);
        return Optional.ofNullable(existingArtifacts.getDSSSavedModelVersions().get(dssItemIdentifier.fullModelVersionId)).map(DSSArtifactContainer::getArtifact).orElse(null);
    }

    @Override
    public DSSProjectArtifactsContainer findDSSItemWithSubItems(DSSItemIdentifier dssItemIdentifier) throws IOException {
        List<ArtifactFilter> filters = this.buildDSSItemFiltersForItemAndSubItems(dssItemIdentifier);
        return this.findDSSArtifacts(filters);
    }

    private List<ArtifactFilter> buildDSSItemFiltersForItemAndSubItems(DSSItemIdentifier dssItemIdentifier) {
        DSSIntegrationArtifactsSearchQueryBuilder.ProjectItemAndSubItemsQueryBuilder projectItemAndSubItemsQueryBuilder = new DSSIntegrationArtifactsSearchQueryBuilder.ProjectItemAndSubItemsQueryBuilder();
        dssItemIdentifier.accept((IDSSItemIdentifierVisitor)projectItemAndSubItemsQueryBuilder);
        return projectItemAndSubItemsQueryBuilder.artifactFilters;
    }

    @Override
    public List<Artifact> findDeployerItemArtifacts(DSSItemIdentifier dssDeployerIdentifier) throws IOException {
        List<ArtifactFilter> filters = this.buildDeployerItemQuery(dssDeployerIdentifier);
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            List<Artifact> list = searchResults.map(enrichedArtifact -> enrichedArtifact.artifact).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<String> findRelatedProjectsApplicationInstanceArtifactIds(List<String> projectApplicationTemplateArtifactIds) throws IOException {
        if (projectApplicationTemplateArtifactIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArtifactFilter.OrArtifactFilter multipleProjects = new ArtifactFilter.OrArtifactFilter();
        multipleProjects.artifactFilters.addAll(projectApplicationTemplateArtifactIds.stream().map(id -> DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_application_template", id, false, true)).toList());
        ArrayList filters = Lists.newArrayList((Object[])new ArtifactFilter[]{DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(SystemProvidedConstants.DATAIKU_PROJECT), multipleProjects, ArtifactFilter.ArchivedStatusArtifactFilter.build(false)});
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            List<String> list = searchResults.map(enrichedArtifact -> enrichedArtifact.artifact.id).collect(Collectors.toList());
            return list;
        }
    }

    private List<ArtifactFilter> buildDeployerItemQuery(DSSItemIdentifier dssDeployerIdentifier) {
        DSSIntegrationArtifactsSearchQueryBuilder.DeployerItemQueryBuilder deployerItemQueryBuilder = new DSSIntegrationArtifactsSearchQueryBuilder.DeployerItemQueryBuilder();
        dssDeployerIdentifier.accept((IDSSItemIdentifierVisitor)deployerItemQueryBuilder);
        return deployerItemQueryBuilder.artifactFilters;
    }
}

