/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.search_artifacts;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DataikuSourceObjects;
import com.dataiku.gh.core.models.dss.GovernProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DSSIntegrationUtils {
    public static DSSProjectArtifactsContainer mapSearchResultToDSSContainer(List<EnrichedArtifact> enrichedArtifacts) {
        DSSProjectArtifactsContainer existingArtifacts = new DSSProjectArtifactsContainer();
        enrichedArtifacts.forEach(ea -> {
            if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_PROJECT.blueprintId)) {
                existingArtifacts.setProject(ea.artifact, false);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_BUNDLE.blueprintId)) {
                existingArtifacts.addBundle(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_DATASET.blueprintId)) {
                existingArtifacts.addDataset(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId)) {
                existingArtifacts.addSavedModel(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.blueprintId)) {
                existingArtifacts.addRetrievableKnowledge(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.blueprintId)) {
                existingArtifacts.addSavedModelVersion(ea.artifact);
            }
        });
        return existingArtifacts;
    }

    public static void addGovernArtifactToGovernContainer(EnrichedArtifact ea, GovernProjectArtifactsContainer governArtifacts) {
        if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(ea.blueprintVersion.id)) {
            governArtifacts.governProject = ea.artifact;
        } else if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(ea.blueprintVersion.id)) {
            governArtifacts.governBundles.add(ea.artifact);
        } else if (SystemProvidedConstants.GOVERN_DATASET.matchBlueprint(ea.blueprintVersion.id)) {
            governArtifacts.governDatasets.add(ea.artifact);
        } else if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(ea.blueprintVersion.id)) {
            governArtifacts.governModels.add(ea.artifact);
        } else if (SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(ea.blueprintVersion.id)) {
            governArtifacts.governModelVersions.add(ea.artifact);
        }
    }

    public static void updateDSSArtifactInDSSContainer(Artifact artifact, DSSProjectArtifactsContainer dssArtifacts) {
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceProject(dssArtifacts.getDSSProject().cloneWith(artifact));
        } else if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceBundle(DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSBundles().values(), artifact).cloneWith(artifact));
        } else if (SystemProvidedConstants.DATAIKU_DATASET.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceDataset(DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSDatasets().values(), artifact).cloneWith(artifact));
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceSavedModel(DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSSavedModels().values(), artifact).cloneWith(artifact));
        } else if (SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceRetrievableKnowledge(DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSRetrievableKnowledges().values(), artifact).cloneWith(artifact));
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            dssArtifacts.replaceSavedModelVersion(DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSSavedModelVersions().values(), artifact).cloneWith(artifact));
        }
    }

    public static DSSArtifactContainer<?> getDSSContainerFromDSSArtifact(Artifact artifact, DSSProjectArtifactsContainer dssArtifacts) {
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(Collections.singletonList(dssArtifacts.getDSSProject()), artifact);
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSBundles().values(), artifact);
        }
        if (SystemProvidedConstants.DATAIKU_DATASET.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSDatasets().values(), artifact);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSSavedModels().values(), artifact);
        }
        if (SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSRetrievableKnowledges().values(), artifact);
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(artifact.blueprintVersionId)) {
            return DSSIntegrationUtils.getExistingContainer(dssArtifacts.getDSSSavedModelVersions().values(), artifact);
        }
        throw new ValidationException("Invalid BlueprintVersionId found for a Dataiku item with blueprint version ID `" + String.valueOf(artifact.blueprintVersionId) + "` and artifact ID `" + artifact.id + "`");
    }

    public static <T extends DSSArtifactContainer<T>> T getExistingContainer(Collection<T> targetList, Artifact artifact) {
        return (T)targetList.stream().filter(container -> StringUtils.equals((String)container.artifact.id, (String)artifact.id)).findAny().orElseThrow(() -> new ValidationException("Can't find artifact " + artifact.id + " in existing artifacts"));
    }

    public static String getDefaultGoverningBlueprintIdForDSSArtifact(EnrichedArtifact ea) {
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(ea.blueprintVersion.id)) {
            return SystemProvidedConstants.GOVERN_PROJECT.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(ea.blueprintVersion.id)) {
            return SystemProvidedConstants.GOVERN_BUNDLE.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_DATASET.matchBlueprint(ea.blueprintVersion.id)) {
            return SystemProvidedConstants.GOVERN_DATASET.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(ea.blueprintVersion.id)) {
            return SystemProvidedConstants.GOVERN_MODEL.blueprintId;
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(ea.blueprintVersion.id)) {
            return SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId;
        }
        throw new ValidationException("Not default governing BlueprintVersionId found for " + String.valueOf(ea.blueprintVersion.id));
    }

    public static boolean isGoverned(Artifact artifact) {
        return StringUtils.isNotBlank((String)((String)artifact.fields.get("governed_by")));
    }

    public static DataikuSourceObjects.DataikuSourceProject mapDSSProjectContainerToDataikuObjectSources(DSSProjectArtifactsContainer container) {
        DataikuSourceObjects.DataikuSourceProject sourceProject = new DataikuSourceObjects.DataikuSourceProject();
        if (container.getDSSProject() != null) {
            sourceProject.projectSourceArtifactId = container.getDSSProject().artifact.id;
        }
        sourceProject.dataikuBundlesArtifactsIds.addAll(container.getDSSBundles().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        sourceProject.dataikuDatasetsArtifactsIds.addAll(container.getDSSDatasets().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        Set savedModelIds = container.getDSSSavedModels().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(savedModelIds)) {
            Map<String, List<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer>> modelVersionsByParent = container.getDSSSavedModelVersions().values().stream().filter(dssArtifactContainer -> StringUtils.isNotBlank((String)((String)dssArtifactContainer.artifact.fields.get("dataiku_saved_model")))).collect(Collectors.groupingBy(dssArtifactContainer -> (String)dssArtifactContainer.artifact.fields.get("dataiku_saved_model")));
            for (String savedModelId : savedModelIds) {
                DataikuSourceObjects.DataikuSourceModel sourceModel = new DataikuSourceObjects.DataikuSourceModel();
                sourceModel.modelSourceArtifactId = savedModelId;
                sourceModel.dataikuSourceModelVersionArtifactIds.addAll(modelVersionsByParent.getOrDefault(savedModelId, Collections.emptyList()).stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
                sourceProject.dataikuSourceModels.add(sourceModel);
            }
        }
        sourceProject.dataikuSourceRetrievableKnowledges.addAll(container.getDSSRetrievableKnowledges().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        return sourceProject;
    }

    public static DSSDeployerArtifactsContainer mapDeployerSearchResultToContainer(List<EnrichedArtifact> enrichedArtifacts) {
        DSSDeployerArtifactsContainer existingArtifacts = new DSSDeployerArtifactsContainer();
        enrichedArtifacts.forEach(ea -> {
            if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.API_DEPLOYER_INFRA.blueprintId)) {
                existingArtifacts.addAPIInfra(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.blueprintId)) {
                existingArtifacts.addProjectInfra(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.blueprintId)) {
                existingArtifacts.addAPIDeployment(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.blueprintId)) {
                existingArtifacts.addProjectDeployment(ea.artifact);
            }
        });
        return existingArtifacts;
    }
}

