/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.GovernProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.governance.ManualGovernanceSettings;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactFixStrategy;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationUtils;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.FunctionUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractGovernanceService {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.governance-service");
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactFixStrategy artifactFixStrategy;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private ISubscriptionsService subscriptionsService;

    protected void internalGovernArtifact(DSSProjectArtifactsContainer dssArtifacts, GovernProjectArtifactsContainer governArtifacts, Artifact dataikuItemToGovernArtifact, @Nonnull ManualGovernanceSettings manualGovernanceSettings, @Nullable AuthCtx authCtx, boolean isAdvancedLicense) throws IOException {
        String governArtifactId;
        BlueprintVersionId governBlueprintVersionId;
        EnrichedArtifact governEnrichedArtifact;
        if (!isAdvancedLicense && !this.artifactIsGovernableWithAdvancedLicense(dataikuItemToGovernArtifact)) {
            logger.infoV("Skip governing artifact of ID: %s due to license restriction", new Object[]{dataikuItemToGovernArtifact.id});
            return;
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovernArtifact.blueprintVersionId) && manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.ExistingProjectSettings) {
            governEnrichedArtifact = this.artifactsDataService.getArtifact(((ManualGovernanceSettings.ExistingProjectSettings)manualGovernanceSettings.projectSettings).artifactId);
            governBlueprintVersionId = governEnrichedArtifact.blueprintVersion.id;
        } else {
            governBlueprintVersionId = this.getGoverningBlueprintVersionForNewArtifact(dataikuItemToGovernArtifact, manualGovernanceSettings);
            Artifact artifact = new Artifact();
            artifact.blueprintVersionId = governBlueprintVersionId;
            artifact.name = dataikuItemToGovernArtifact.name;
            if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(governBlueprintVersionId)) {
                String businessInitiativeArtifactId;
                if (manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.CreateProjectSettings && StringUtils.isNotBlank((CharSequence)(businessInitiativeArtifactId = ((ManualGovernanceSettings.CreateProjectSettings)manualGovernanceSettings.projectSettings).businessInitiativeArtifactId))) {
                    BlueprintVersionId projectBPVId = BlueprintVersionId.build(SystemProvidedConstants.GOVERN_PROJECT.blueprintId, ((ManualGovernanceSettings.CreateProjectSettings)manualGovernanceSettings.projectSettings).versionId);
                    EnrichedBlueprintVersion projectBPV = this.blueprintsDataService.getBlueprintVersion(projectBPVId);
                    FieldDefinition fieldDef = projectBPV.blueprintVersion.fieldDefinitions.get("business_initiative");
                    if (fieldDef == null || fieldDef.fieldType != FieldType.REFERENCE || fieldDef.sourceType != SourceType.STORE || !(fieldDef instanceof StoredReferenceFieldDefinition) || !((StoredReferenceFieldDefinition)fieldDef).allowedBlueprints.contains(SystemProvidedConstants.BUSINESS_INITIATIVE.blueprintId)) {
                        logger.warnV("Ignoring selected parent business initiative because selected blueprint version for Govern Project has an invalid field: %s, %s", new Object[]{projectBPVId, "business_initiative"});
                    } else {
                        artifact.fields.put("business_initiative", fieldDef.listConfig != null ? Lists.newArrayList((Object[])new String[]{businessInitiativeArtifactId}) : businessInitiativeArtifactId);
                    }
                }
            } else {
                if (manualGovernanceSettings.projectSettings != null && !DSSIntegrationUtils.isGoverned(dssArtifacts.getDSSProject().artifact)) {
                    this.internalGovernArtifact(dssArtifacts, governArtifacts, dssArtifacts.getDSSProject().artifact, manualGovernanceSettings, authCtx, isAdvancedLicense);
                }
                if (governArtifacts.governProject != null) {
                    if (SystemProvidedConstants.GOVERN_DATASET.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governArtifacts.governProject.id);
                    } else if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governArtifacts.governProject.id);
                    } else if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governArtifacts.governProject.id);
                    }
                }
                if (SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(governBlueprintVersionId)) {
                    String dataikuSavedModelArtifactId = (String)dataikuItemToGovernArtifact.fields.get("dataiku_saved_model");
                    Optional<Artifact> dssSavedModel = this.findArtifactInList(dataikuSavedModelArtifactId, dssArtifacts.getDSSSavedModels().values().stream().map(DSSArtifactContainer::getArtifact).collect(Collectors.toList()));
                    if (manualGovernanceSettings.modelSettings != null && dssSavedModel.isPresent() && !DSSIntegrationUtils.isGoverned(dssSavedModel.get())) {
                        this.internalGovernArtifact(dssArtifacts, governArtifacts, dssSavedModel.get(), manualGovernanceSettings, authCtx, isAdvancedLicense);
                    }
                    Optional<String> governModelId = dssSavedModel.map(savedModel -> (String)savedModel.fields.get("governed_by")).flatMap(modelId -> this.findArtifactInList((String)modelId, governArtifacts.governModels)).map(governModel -> governModel.id);
                    governModelId.ifPresent(modelId -> artifact.fields.put("govern_model", modelId));
                }
            }
            DSSArtifactContainer<?> dkuArtifact = DSSIntegrationUtils.getDSSContainerFromDSSArtifact(dataikuItemToGovernArtifact, dssArtifacts);
            if (DSSIntegrationUtils.isGoverned(dkuArtifact.artifact)) {
                return;
            }
            governEnrichedArtifact = this.systemArtifactService.createSystemArtifact(governBlueprintVersionId, artifact);
            if (this.artifactFixStrategy.fixArtifact(governEnrichedArtifact)) {
                governEnrichedArtifact = this.systemArtifactService.updateSystemArtifact(governEnrichedArtifact.artifact);
            }
        }
        DSSIntegrationUtils.addGovernArtifactToGovernContainer(governEnrichedArtifact, governArtifacts);
        if (authCtx != null) {
            this.subscriptionsService.automaticSubscribe(authCtx, governEnrichedArtifact.artifact.id);
        }
        logger.infoV("Governing artifact of ID: %s", new Object[]{dataikuItemToGovernArtifact.id});
        dataikuItemToGovernArtifact.fields.put("governed_by", governEnrichedArtifact.artifact.id);
        dataikuItemToGovernArtifact = this.systemArtifactService.updateSystemArtifact((Artifact)dataikuItemToGovernArtifact).artifact;
        DSSIntegrationUtils.updateDSSArtifactInDSSContainer(dataikuItemToGovernArtifact, dssArtifacts);
        if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(governBlueprintVersionId)) {
            governArtifactId = governEnrichedArtifact.artifact.id;
            this.batchUpdateArtifact(governArtifacts.governDatasets, ea -> ea.artifact.fields.put("govern_project", governArtifactId));
            this.batchUpdateArtifact(governArtifacts.governModels, ea -> ea.artifact.fields.put("govern_project", governArtifactId));
            this.batchUpdateArtifact(governArtifacts.governBundles, ea -> ea.artifact.fields.put("govern_project", governArtifactId));
            if (manualGovernanceSettings.projectSettings != null && manualGovernanceSettings.projectSettings.governChildrenBundles && manualGovernanceSettings.bundleSettings != null) {
                ManualGovernanceSettings manualGovernanceSettingsForBundles = ManualGovernanceSettings.build(null, ManualGovernanceSettings.BundleSettings.build(manualGovernanceSettings.bundleSettings.versionId), null, null);
                this.governChildArtifacts(dssArtifacts, governArtifacts, dataikuItemToGovernArtifact, ChildrenGovernanceParameters.PROJECT_BUNDLES_CHILDREN_GOV_PARAMS, manualGovernanceSettingsForBundles, authCtx, isAdvancedLicense);
            }
            if (manualGovernanceSettings.projectSettings != null && manualGovernanceSettings.projectSettings.governChildrenSavedModels && manualGovernanceSettings.modelSettings != null) {
                ManualGovernanceSettings manualGovernanceSettingsForModels = ManualGovernanceSettings.build(null, null, ManualGovernanceSettings.ModelSettings.build(manualGovernanceSettings.modelSettings.versionId, manualGovernanceSettings.modelSettings.governChildrenSavedModelVersions), manualGovernanceSettings.modelVersionSettings != null ? ManualGovernanceSettings.ModelVersionSettings.build(manualGovernanceSettings.modelVersionSettings.versionId) : null);
                this.governChildArtifacts(dssArtifacts, governArtifacts, dataikuItemToGovernArtifact, ChildrenGovernanceParameters.PROJECT_MODELS_CHILDREN_GOV_PARAMS, manualGovernanceSettingsForModels, authCtx, isAdvancedLicense);
            }
        }
        if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(governBlueprintVersionId)) {
            governArtifactId = governEnrichedArtifact.artifact.id;
            String dataikuModelArtifactId = dataikuItemToGovernArtifact.id;
            List dssSavedModelVersionChildren = dssArtifacts.getDSSSavedModelVersions().values().stream().filter(dkusmv -> Objects.equals(dkusmv.getArtifact().fields.get("dataiku_saved_model"), dataikuModelArtifactId) && DSSIntegrationUtils.isGoverned(dkusmv.getArtifact())).map(DSSArtifactContainer::getArtifact).collect(Collectors.toList());
            for (Artifact dssSavedModelVersionChild : dssSavedModelVersionChildren) {
                String governModelVersionArtifactId = (String)dssSavedModelVersionChild.fields.get("governed_by");
                this.systemArtifactService.updateSystemArtifact(governModelVersionArtifactId, ea -> ea.artifact.fields.put("govern_model", governArtifactId));
            }
            if (manualGovernanceSettings.modelSettings != null && manualGovernanceSettings.modelSettings.governChildrenSavedModelVersions && manualGovernanceSettings.modelVersionSettings != null) {
                ManualGovernanceSettings manualGovernanceSettingsForSavedModelVersions = ManualGovernanceSettings.build(null, null, null, ManualGovernanceSettings.ModelVersionSettings.build(manualGovernanceSettings.modelVersionSettings.versionId));
                this.governChildArtifacts(dssArtifacts, governArtifacts, dataikuItemToGovernArtifact, ChildrenGovernanceParameters.SAVED_MODEL_SAVED_MODEL_VERSIONS_CHILDREN_GOV_PARAMS, manualGovernanceSettingsForSavedModelVersions, authCtx, isAdvancedLicense);
            }
        }
    }

    private BlueprintVersionId getGoverningBlueprintVersionForNewArtifact(Artifact dataikuItemToGovernArtifact, ManualGovernanceSettings manualGovernanceSettings) {
        BlueprintVersionId governingBlueprintVersionId;
        BlueprintVersionId dataikuItemBlueprintVersionId = dataikuItemToGovernArtifact.blueprintVersionId;
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemBlueprintVersionId)) {
            governingBlueprintVersionId = manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.CreateProjectSettings ? BlueprintVersionId.build(SystemProvidedConstants.GOVERN_PROJECT.blueprintId, ((ManualGovernanceSettings.CreateProjectSettings)manualGovernanceSettings.projectSettings).versionId) : SystemProvidedConstants.GOVERN_PROJECT.getSingleDefaultBlueprintVersionId();
        } else if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(dataikuItemBlueprintVersionId)) {
            governingBlueprintVersionId = manualGovernanceSettings.bundleSettings != null ? BlueprintVersionId.build(SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, manualGovernanceSettings.bundleSettings.versionId) : SystemProvidedConstants.GOVERN_BUNDLE.getSingleDefaultBlueprintVersionId();
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuItemBlueprintVersionId)) {
            governingBlueprintVersionId = manualGovernanceSettings.modelSettings != null ? BlueprintVersionId.build(SystemProvidedConstants.GOVERN_MODEL.blueprintId, manualGovernanceSettings.modelSettings.versionId) : SystemProvidedConstants.GOVERN_MODEL.getSingleDefaultBlueprintVersionId();
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(dataikuItemBlueprintVersionId)) {
            governingBlueprintVersionId = manualGovernanceSettings.modelVersionSettings != null ? BlueprintVersionId.build(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, manualGovernanceSettings.modelVersionSettings.versionId) : SystemProvidedConstants.GOVERN_MODEL_VERSION.getSingleDefaultBlueprintVersionId();
        } else {
            throw new ValidationException("Cannot Govern an item with id `" + dataikuItemToGovernArtifact.id + "` of type other than: project, bundle, saved model, or saved model version");
        }
        return governingBlueprintVersionId;
    }

    private <T extends DSSArtifactContainer<T>> void governChildArtifacts(DSSProjectArtifactsContainer dssArtifacts, GovernProjectArtifactsContainer governArtifacts, Artifact dataikuItemToGovernArtifact, ChildrenGovernanceParameters<T> childrenGovernanceParameters, ManualGovernanceSettings manualGovernanceSettings, @Nullable AuthCtx authCtx, boolean isAdvancedLicense) throws IOException {
        List dssArtifactIds = (List)dataikuItemToGovernArtifact.fields.getOrDefault(childrenGovernanceParameters.childArtifactsKey, Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)dssArtifactIds)) {
            return;
        }
        List dssArtifactsList = childrenGovernanceParameters.dssArtifactGetter.apply(dssArtifacts).values().stream().map(DSSArtifactContainer::getArtifact).collect(Collectors.toList());
        Map<Boolean, List<Artifact>> dssArtifactsMap = dssArtifactIds.stream().map(dssArtifactId -> {
            Optional<Artifact> foundArtifact = this.findArtifactInList((String)dssArtifactId, dssArtifactsList);
            if (foundArtifact.isEmpty()) {
                logger.warn((Object)("Failed when governing children of item '" + dataikuItemToGovernArtifact.id + "': referenced item '" + dssArtifactId + "' in field '" + childrenGovernanceParameters.childArtifactsKey + "' was not found as a child."));
                return null;
            }
            return foundArtifact.get();
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(DSSIntegrationUtils::isGoverned));
        List governedDSSArtifacts = dssArtifactsMap.getOrDefault(true, Collections.emptyList());
        List notGovernedDSSArtifacts = dssArtifactsMap.getOrDefault(false, Collections.emptyList());
        if (manualGovernanceSettings.modelSettings != null && manualGovernanceSettings.modelSettings.governChildrenSavedModelVersions && manualGovernanceSettings.modelVersionSettings != null) {
            ManualGovernanceSettings manualGovernanceSettingsForSavedModelVersions = ManualGovernanceSettings.build(null, null, null, ManualGovernanceSettings.ModelVersionSettings.build(manualGovernanceSettings.modelVersionSettings.versionId));
            for (Artifact governedDSSArtifact : governedDSSArtifacts) {
                if (!SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(governedDSSArtifact.blueprintVersionId)) continue;
                this.governChildArtifacts(dssArtifacts, governArtifacts, governedDSSArtifact, ChildrenGovernanceParameters.SAVED_MODEL_SAVED_MODEL_VERSIONS_CHILDREN_GOV_PARAMS, manualGovernanceSettingsForSavedModelVersions, authCtx, isAdvancedLicense);
            }
        }
        for (Artifact notGovernedDSSArtifact : notGovernedDSSArtifacts) {
            this.internalGovernArtifact(dssArtifacts, governArtifacts, notGovernedDSSArtifact, manualGovernanceSettings, authCtx, isAdvancedLicense);
        }
    }

    protected GovernProjectArtifactsContainer dssProjectToGovernProjectContainer(DSSProjectArtifactsContainer dssArtifacts) throws IOException {
        try {
            GovernProjectArtifactsContainer governContainer = new GovernProjectArtifactsContainer();
            governContainer.governProject = this.getGovernArtifact_UncheckedIOException(dssArtifacts.getDSSProject()).orElse(null);
            governContainer.governBundles = dssArtifacts.getDSSBundles().values().stream().map(this::getGovernArtifact_UncheckedIOException).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            governContainer.governDatasets = dssArtifacts.getDSSDatasets().values().stream().map(this::getGovernArtifact_UncheckedIOException).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            governContainer.governModels = dssArtifacts.getDSSSavedModels().values().stream().map(this::getGovernArtifact_UncheckedIOException).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            governContainer.governModelVersions = dssArtifacts.getDSSSavedModelVersions().values().stream().map(this::getGovernArtifact_UncheckedIOException).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return governContainer;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private Optional<Artifact> getGovernArtifact_UncheckedIOException(DSSArtifactContainer<?> governedArtifact) {
        return Optional.ofNullable(governedArtifact.artifact.fields.get("governed_by")).filter(String.class::isInstance).map(id -> {
            try {
                return this.artifactsDataService.getArtifact((String)((String)id)).artifact;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    protected Optional<Artifact> findArtifactInList(String artifactId, List<Artifact> list) {
        return list.stream().filter(artifact -> artifact.id.equals(artifactId)).findAny();
    }

    private void batchUpdateArtifact(List<Artifact> artifactsToUpdate, FunctionUtils.ConsumerCanThrowsException<EnrichedArtifact, IOException> patch) throws IOException {
        for (Artifact artifactToUpdate : artifactsToUpdate) {
            this.systemArtifactService.updateSystemArtifact(artifactToUpdate.id, patch);
        }
    }

    protected boolean artifactIsGovernableWithAdvancedLicense(Artifact artifact) {
        BlueprintVersionId blueprintVersionId = artifact.blueprintVersionId;
        Object modelType = artifact.fields.get("model_type");
        return (!SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(blueprintVersionId) || !(modelType instanceof String) || !StringUtils.equals((CharSequence)((String)modelType), (CharSequence)"LLM_GENERIC_RAW")) && (!SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(blueprintVersionId) || !SystemProvidedConstants.RESTRICTED_TO_ADVANCED_LICENSE_SAVED_MODEL_VERSIONS.contains(blueprintVersionId.versionId));
    }

    private static class ChildrenGovernanceParameters<T extends DSSArtifactContainer<T>> {
        public final String childArtifactsKey;
        public final Function<DSSProjectArtifactsContainer, Map<String, T>> dssArtifactGetter;
        public static final ChildrenGovernanceParameters<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer> SAVED_MODEL_SAVED_MODEL_VERSIONS_CHILDREN_GOV_PARAMS = new ChildrenGovernanceParameters("dataiku_saved_model_versions", DSSProjectArtifactsContainer::getDSSSavedModelVersions);
        public static final ChildrenGovernanceParameters<DSSArtifactContainer.DSSBundleArtifactContainer> PROJECT_BUNDLES_CHILDREN_GOV_PARAMS = new ChildrenGovernanceParameters("dataiku_bundles", DSSProjectArtifactsContainer::getDSSBundles);
        public static final ChildrenGovernanceParameters<DSSArtifactContainer.DSSSavedModelArtifactContainer> PROJECT_MODELS_CHILDREN_GOV_PARAMS = new ChildrenGovernanceParameters("dataiku_saved_models", DSSProjectArtifactsContainer::getDSSSavedModels);

        private ChildrenGovernanceParameters(String childArtifactsKey, Function<DSSProjectArtifactsContainer, Map<String, T>> dssArtifactGetter) {
            this.childArtifactsKey = childArtifactsKey;
            this.dssArtifactGetter = dssArtifactGetter;
        }
    }
}

