/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.auto;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.governance.auto.IAutomaticGovernanceQueueService;
import com.dataiku.gh.core.services.governance.auto.IAutomaticGovernanceService;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomaticGovernanceQueueService
implements IAutomaticGovernanceQueueService {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.auto-governance-queue");
    @Autowired
    public IAutomaticGovernanceService automaticGovernanceService;
    private final AutomaticGovernanceQueueHandler queueHandler = new AutomaticGovernanceQueueHandler();
    private Thread governThread;

    public AutomaticGovernanceQueueService() {
        this.initGovernThread();
    }

    private synchronized void initGovernThread() {
        if (this.governThread != null) {
            this.governThread.interrupt();
            this.governThread = null;
        }
        this.governThread = new Thread(this.queueHandler);
        this.governThread.setUncaughtExceptionHandler((thread, throwable) -> {
            logger.error((Object)"Automatic governance service handler thread caught unhandled throwable", throwable);
            this.initGovernThread();
        });
        this.governThread.start();
    }

    @Override
    public void addToQueueWithContext(DSSProjectArtifactsContainer dssProjectArtifactsContainer, ActionType actionType, @Nullable AuthCtx owner) {
        this.queueHandler.queue.add(new DSSProjectArtifactsContainerWithOwnership(dssProjectArtifactsContainer, actionType, owner));
    }

    public class AutomaticGovernanceQueueHandler
    implements Runnable {
        public final BlockingQueue<DSSProjectArtifactsContainerWithOwnership> queue = new LinkedBlockingQueue<DSSProjectArtifactsContainerWithOwnership>();

        public void handleQueueEvent(DSSProjectArtifactsContainerWithOwnership projectArtifactsContainerWithOwnership) throws IOException {
            try (GovernActionContext.ContextContainer ignored = GovernActionContext.attachNewContext(projectArtifactsContainerWithOwnership.actionType, projectArtifactsContainerWithOwnership.owner);){
                AutomaticGovernanceQueueService.this.automaticGovernanceService.handleAfterSyncAutoGovernance(projectArtifactsContainerWithOwnership.projectArtifactsContainer);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("govern-queue");
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    DSSProjectArtifactsContainerWithOwnership container = this.queue.take();
                    DKULogger.startCurrentCall();
                    logger.debugV("Automatic governance starts on project container=%s", new Object[]{container.projectArtifactsContainer.getDSSProject().getIdentifier()});
                    try {
                        this.handleQueueEvent(container);
                        logger.debugV("Automatic governance succeeded on project container=%s", new Object[]{container.projectArtifactsContainer.getDSSProject().getIdentifier()});
                    }
                    catch (Exception e) {
                        logger.error((Object)("Automatic governance failed on project container=" + container.projectArtifactsContainer.getDSSProject().getIdentifier()), (Throwable)e);
                    }
                    DKULogger.endCurrentCall();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Automatic governance thread interrupted", (Throwable)e);
            }
        }
    }

    public static class DSSProjectArtifactsContainerWithOwnership {
        public DSSProjectArtifactsContainer projectArtifactsContainer;
        public ActionType actionType;
        @Nullable
        public AuthCtx owner;

        DSSProjectArtifactsContainerWithOwnership(DSSProjectArtifactsContainer projectArtifactsContainer, ActionType actionType, @Nullable AuthCtx owner) {
            this.projectArtifactsContainer = projectArtifactsContainer;
            this.actionType = actionType;
            this.owner = owner;
        }
    }
}

