/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.auto;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.GovernProjectArtifactsContainer;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceStatus;
import com.dataiku.gh.core.models.governance.ManualGovernanceSettings;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationUtils;
import com.dataiku.gh.core.services.dss.search_artifacts.IDSSIntegrationSearchArtifactsService;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.governance.AbstractGovernanceService;
import com.dataiku.gh.core.services.governance.auto.IAutomaticGovernanceService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutomaticGovernanceService
extends AbstractGovernanceService
implements IAutomaticGovernanceService {
    @Autowired
    private IDSSIntegrationSearchArtifactsService dssIntegrationSearchArtifactsService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @Override
    @GHWriteTransaction
    public void handleAfterSyncAutoGovernance(DSSProjectArtifactsContainer syncedDSSProjectArtifacts) throws IOException {
        if (syncedDSSProjectArtifacts.getDSSProject() == null) {
            return;
        }
        DSSProjectArtifactsContainer dataikuArtifacts = this.dssIntegrationSearchArtifactsService.findDSSProjectArtifactsWithAutoGovernSettings(DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(syncedDSSProjectArtifacts.getDSSProject().artifact));
        GovernProjectArtifactsContainer governArtifacts = this.dssProjectToGovernProjectContainer(dataikuArtifacts);
        boolean isAdvancedLicense = this.licenseEnforcementService.isGovernBlueprintDesignerAllowed();
        this.internalHandleProjectAutoGovernance(dataikuArtifacts, governArtifacts, syncedDSSProjectArtifacts.getDSSProject(), isAdvancedLicense);
        this.internalHandleAfterSyncAutoGovernance(dataikuArtifacts, governArtifacts, syncedDSSProjectArtifacts.getDSSBundles(), dataikuArtifacts.getDSSBundles(), bundleContainer -> dataikuArtifacts.getDSSProject().artifact, container -> "bundle_id", versionId -> ManualGovernanceSettings.build(null, ManualGovernanceSettings.BundleSettings.build(versionId), null, null), isAdvancedLicense);
        this.internalHandleAfterSyncAutoGovernance(dataikuArtifacts, governArtifacts, syncedDSSProjectArtifacts.getDSSSavedModels(), dataikuArtifacts.getDSSSavedModels(), modelContainer -> dataikuArtifacts.getDSSProject().artifact, container -> "saved_model_id", versionId -> ManualGovernanceSettings.build(null, null, ManualGovernanceSettings.ModelSettings.build(versionId, false), null), isAdvancedLicense);
        this.internalHandleAfterSyncAutoGovernance(dataikuArtifacts, governArtifacts, syncedDSSProjectArtifacts.getDSSSavedModelVersions(), dataikuArtifacts.getDSSSavedModelVersions(), modelVersionContainer -> this.findArtifactInList((String)modelVersionContainer.artifact.fields.get("dataiku_saved_model"), dataikuArtifacts.getDSSSavedModels().values().stream().map(DSSArtifactContainer::getArtifact).collect(Collectors.toList())).orElseThrow(() -> new ValidationException("Can't find the parent model for model version " + modelVersionContainer.artifact.id)), container -> "full_model_version_id", versionId -> ManualGovernanceSettings.build(null, null, null, ManualGovernanceSettings.ModelVersionSettings.build(versionId)), isAdvancedLicense);
    }

    private void internalHandleProjectAutoGovernance(DSSProjectArtifactsContainer fullDssArtifacts, GovernProjectArtifactsContainer governArtifacts, DSSArtifactContainer syncedProject, boolean isAdvancedLicense) throws IOException {
        if (syncedProject == null || DSSIntegrationUtils.isGoverned(syncedProject.artifact) || Objects.equals(syncedProject.artifact.fields.get("hidden_in_governable_items_table"), true)) {
            return;
        }
        AutoGovernanceConfiguration syncedProjectDefaultGovernanceSettings = this.autoGovernanceConfigurationDataService.getInstanceDefaultProjectAutoGovernConfiguration().instanceAutoGovernanceConfiguration.projectsConfig;
        if (syncedProjectDefaultGovernanceSettings.status == AutoGovernanceStatus.DISABLED || syncedProjectDefaultGovernanceSettings.blueprintVersionId == null) {
            return;
        }
        ManualGovernanceSettings manualGovernanceSettings = ManualGovernanceSettings.build(ManualGovernanceSettings.CreateProjectSettings.build(syncedProjectDefaultGovernanceSettings.blueprintVersionId.versionId, false, false, null), null, null, null);
        this.internalGovernArtifact(fullDssArtifacts, governArtifacts, syncedProject.artifact, manualGovernanceSettings, null, isAdvancedLicense);
    }

    private <T extends DSSArtifactContainer<T>> void internalHandleAfterSyncAutoGovernance(DSSProjectArtifactsContainer fullDssArtifacts, GovernProjectArtifactsContainer governArtifacts, Map<String, T> syncedArtifactsFilteredByBP, Map<String, T> fullDssArtifactsFilteredByBP, Function<T, Artifact> dssArtifactParentGetter, Function<T, String> dataikuItemIdentifierFieldIdGetter, Function<String, ManualGovernanceSettings> manualGovernanceSettingsBuilder, boolean isAdvancedLicense) throws IOException {
        if (!DSSIntegrationUtils.isGoverned(fullDssArtifacts.getDSSProject().artifact)) {
            return;
        }
        if (syncedArtifactsFilteredByBP == null || syncedArtifactsFilteredByBP.values().isEmpty()) {
            return;
        }
        List dssArtifactLiableToBeGoverned = syncedArtifactsFilteredByBP.values().stream().filter(dssArtifact -> !dssArtifact.artifact.status.archived && !DSSIntegrationUtils.isGoverned(dssArtifact.artifact) && DSSIntegrationUtils.isGoverned((Artifact)dssArtifactParentGetter.apply(dssArtifact)) && !Objects.equals(dssArtifact.artifact.fields.get("hidden_in_governable_items_table"), true)).collect(Collectors.toList());
        for (DSSArtifactContainer dssArtifact2 : dssArtifactLiableToBeGoverned) {
            AutoGovernanceConfiguration autoGovernanceConfiguration = Optional.ofNullable(dssArtifact2.artifact.fields.get(dataikuItemIdentifierFieldIdGetter.apply(dssArtifact2))).filter(String.class::isInstance).map(s -> (String)s).map(fullDssArtifactsFilteredByBP::get).map(dssArtifactContainer -> dssArtifactContainer.autoGovernanceConfiguration).orElse(AutoGovernanceConfiguration.buildDisabled());
            if (autoGovernanceConfiguration.status != AutoGovernanceStatus.ENABLED || autoGovernanceConfiguration.blueprintVersionId == null) continue;
            ManualGovernanceSettings manualGovernanceSettings = manualGovernanceSettingsBuilder.apply(autoGovernanceConfiguration.blueprintVersionId.versionId);
            this.internalGovernArtifact(fullDssArtifacts, governArtifacts, dssArtifact2.artifact, manualGovernanceSettings, null, isAdvancedLicense);
        }
    }
}

