/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.config;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfigurationWithSource;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfigurationSource;
import com.dataiku.gh.core.models.governance.InstanceAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ModelAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ProjectAutoGovernanceConfiguration;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.auto_govern.IArtifactGovernanceSettingsDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoGovernanceConfigurationDataService
implements IAutoGovernanceConfigurationDataService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.data-services.auto-governance-configuration");
    @Autowired
    IArtifactGovernanceSettingsDAO autoGovernConfigurationDAO;
    @Autowired
    IArtifactsDataService artifactsDataService;
    @Autowired
    IGovernConfigurationDataService governConfigurationDataService;

    @Override
    @Nullable
    @GHMandatoryTransaction
    public ArtifactAutoGovernanceConfiguration getDSSArtifactAutoGovernConfigurationOrNull(String artifactId) throws IOException {
        return (ArtifactAutoGovernanceConfiguration)this.autoGovernConfigurationDAO.getOrNull(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactAutoGovernanceConfigurationWithSource getEffectiveArtifactAutoGovernConfiguration(String artifactId) throws IOException {
        String parentProjectId;
        ArtifactAutoGovernanceConfiguration projectAutoGovernConfiguration;
        ArtifactAutoGovernanceConfiguration startingLevelConfiguration = (ArtifactAutoGovernanceConfiguration)this.autoGovernConfigurationDAO.getOrNull(artifactId);
        if (startingLevelConfiguration != null) {
            return ArtifactAutoGovernanceConfigurationWithSource.build(startingLevelConfiguration, AutoGovernanceConfigurationSource.SELF);
        }
        EnrichedArtifact currentDataikuArtifact = this.artifactsDataService.getArtifact(artifactId);
        if (Objects.equals(currentDataikuArtifact.blueprint.id, SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId) && currentDataikuArtifact.artifact.fields.containsKey("dataiku_project") && (projectAutoGovernConfiguration = (ArtifactAutoGovernanceConfiguration)this.autoGovernConfigurationDAO.getOrNull(parentProjectId = (String)currentDataikuArtifact.artifact.fields.get("dataiku_project"))) != null) {
            return ArtifactAutoGovernanceConfigurationWithSource.build(projectAutoGovernConfiguration, AutoGovernanceConfigurationSource.PROJECT);
        }
        DefaultAutoGovernanceConfiguration autoGovernInstanceLevelConfiguration = (DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.getConfigurationItemOrNull("default-autogovern");
        if (autoGovernInstanceLevelConfiguration != null && autoGovernInstanceLevelConfiguration.instanceAutoGovernanceConfiguration != null) {
            return ArtifactAutoGovernanceConfigurationWithSource.build(this.extractToProjectConfig(autoGovernInstanceLevelConfiguration.instanceAutoGovernanceConfiguration), AutoGovernanceConfigurationSource.INSTANCE);
        }
        return ArtifactAutoGovernanceConfigurationWithSource.build(ProjectAutoGovernanceConfiguration.build(null, AutoGovernanceConfiguration.buildDisabled(), AutoGovernanceConfiguration.buildDisabled(), AutoGovernanceConfiguration.buildDisabled()), AutoGovernanceConfigurationSource.INSTANCE);
    }

    private ProjectAutoGovernanceConfiguration extractToProjectConfig(InstanceAutoGovernanceConfiguration instanceAutoGovernanceConfiguration) {
        return ProjectAutoGovernanceConfiguration.build(null, instanceAutoGovernanceConfiguration.bundlesConfig, instanceAutoGovernanceConfiguration.modelsConfig, instanceAutoGovernanceConfiguration.modelVersionsConfig);
    }

    @Override
    @GHMandatoryTransaction
    public List<ArtifactAutoGovernanceConfigurationWithSource> getEffectiveConfigurationsForGovernProject(EnrichedArtifact governArtifact) throws IOException {
        List dssArtifactIds = governArtifact.artifact.fields.getOrDefault("dataiku_item", Collections.emptyList());
        ArrayList<ArtifactAutoGovernanceConfigurationWithSource> dataikuObjectsConfigurationList = new ArrayList<ArtifactAutoGovernanceConfigurationWithSource>();
        for (String id : dssArtifactIds) {
            dataikuObjectsConfigurationList.add(this.getEffectiveArtifactAutoGovernConfiguration(id));
        }
        return dataikuObjectsConfigurationList;
    }

    @Override
    @Nonnull
    @GHMandatoryTransaction
    public DSSProjectArtifactsContainer fillArtifactContainerWithEffectiveAutoGovernConfigurations(DSSProjectArtifactsContainer dssProjectArtifactsContainer) throws IOException {
        ProjectAutoGovernanceConfiguration autoGovernProjectLevelConfiguration = (ProjectAutoGovernanceConfiguration)this.getEffectiveArtifactAutoGovernConfiguration((String)dssProjectArtifactsContainer.getDSSProject().artifact.id).artifactAutoGovernanceConfiguration;
        List modelArtifactIds = dssProjectArtifactsContainer.getDSSSavedModels().values().stream().map(v -> v.artifact.id).collect(Collectors.toList());
        HashMap<String, ArtifactAutoGovernanceConfiguration> autoGovernModelsLevelConfiguration = new HashMap<String, ArtifactAutoGovernanceConfiguration>();
        for (String string : modelArtifactIds) {
            ArtifactAutoGovernanceConfiguration autoGovernConfiguration = this.getDSSArtifactAutoGovernConfigurationOrNull(string);
            autoGovernModelsLevelConfiguration.put(string, Optional.ofNullable(autoGovernConfiguration).orElse(autoGovernProjectLevelConfiguration));
        }
        if (autoGovernProjectLevelConfiguration != null) {
            if (autoGovernProjectLevelConfiguration.bundlesConfig != null) {
                for (Map.Entry entry : dssProjectArtifactsContainer.getDSSBundles().entrySet()) {
                    DSSArtifactContainer.DSSBundleArtifactContainer bundle = (DSSArtifactContainer.DSSBundleArtifactContainer)entry.getValue();
                    bundle.autoGovernanceConfiguration = autoGovernProjectLevelConfiguration.bundlesConfig;
                }
            }
            if (autoGovernProjectLevelConfiguration.modelsConfig != null) {
                for (Map.Entry entry : dssProjectArtifactsContainer.getDSSSavedModels().entrySet()) {
                    DSSArtifactContainer.DSSSavedModelArtifactContainer model = (DSSArtifactContainer.DSSSavedModelArtifactContainer)entry.getValue();
                    model.autoGovernanceConfiguration = autoGovernProjectLevelConfiguration.modelsConfig;
                }
            }
        }
        for (Map.Entry entry : dssProjectArtifactsContainer.getDSSSavedModelVersions().entrySet()) {
            DSSArtifactContainer.DSSSavedModelVersionArtifactContainer modelVersion = (DSSArtifactContainer.DSSSavedModelVersionArtifactContainer)entry.getValue();
            String parentModelArtifactId = (String)modelVersion.artifact.fields.get("dataiku_saved_model");
            if (parentModelArtifactId == null) {
                logger.error((Object)("Can't find the parent model for model version " + modelVersion.artifact.id));
                continue;
            }
            ArtifactAutoGovernanceConfiguration extractedConfiguration = (ArtifactAutoGovernanceConfiguration)autoGovernModelsLevelConfiguration.get(parentModelArtifactId);
            AutoGovernanceConfiguration autoGovernForModelVersions = AutoGovernanceConfigurationDataService.getAutoGovernConfiguration(extractedConfiguration);
            if (autoGovernForModelVersions == null) continue;
            modelVersion.autoGovernanceConfiguration = autoGovernForModelVersions;
        }
        return dssProjectArtifactsContainer;
    }

    @Nullable
    private static AutoGovernanceConfiguration getAutoGovernConfiguration(ArtifactAutoGovernanceConfiguration extractedConfiguration) {
        AutoGovernanceConfiguration autoGovernForModelVersions = null;
        if (extractedConfiguration instanceof ProjectAutoGovernanceConfiguration) {
            autoGovernForModelVersions = ((ProjectAutoGovernanceConfiguration)extractedConfiguration).modelVersionsConfig;
        } else if (extractedConfiguration instanceof ModelAutoGovernanceConfiguration) {
            autoGovernForModelVersions = ((ModelAutoGovernanceConfiguration)extractedConfiguration).modelVersionsConfig;
        }
        return autoGovernForModelVersions;
    }

    @GHMandatoryTransaction
    private void storeDSSArtifactAutoGovernConfiguration(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration, boolean creation) throws IOException {
        EnrichedArtifact artifact = this.artifactsDataService.getArtifact(artifactAutoGovernanceConfiguration.artifactId);
        String sentConfigurationBlueprintId = "";
        if (artifactAutoGovernanceConfiguration instanceof ProjectAutoGovernanceConfiguration) {
            sentConfigurationBlueprintId = SystemProvidedConstants.DATAIKU_PROJECT.blueprintId;
        }
        if (artifactAutoGovernanceConfiguration instanceof ModelAutoGovernanceConfiguration) {
            sentConfigurationBlueprintId = SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId;
        }
        if (!Objects.equals(sentConfigurationBlueprintId, artifact.blueprint.id)) {
            throw new ValidationException("Sent configuration does not correspond to the artifact blueprint in base, which is " + artifact.blueprint.id);
        }
        if (creation) {
            this.autoGovernConfigurationDAO.create(artifactAutoGovernanceConfiguration);
        } else {
            this.autoGovernConfigurationDAO.save(artifactAutoGovernanceConfiguration);
        }
    }

    @Override
    @GHMandatoryTransaction
    public ArtifactAutoGovernanceConfigurationWithSource upsertDSSArtifactAutoGovernConfiguration(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration) throws IOException {
        this.storeDSSArtifactAutoGovernConfiguration(artifactAutoGovernanceConfiguration, !this.autoGovernConfigurationDAO.exists(artifactAutoGovernanceConfiguration.artifactId));
        return this.getEffectiveArtifactAutoGovernConfiguration(artifactAutoGovernanceConfiguration.artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteDSSArtifactAutoGovernConfiguration(String artifactId) throws IOException {
        if (!this.autoGovernConfigurationDAO.exists(artifactId)) {
            throw new ValidationException("Autogovern Configuration for artifact ID: " + artifactId + " doesn't exist");
        }
        this.autoGovernConfigurationDAO.delete(artifactId);
    }

    @Override
    @Nonnull
    @GHMandatoryTransaction
    public Stream<ArtifactAutoGovernanceConfiguration> getConfigurationsUsingBPVStream(BlueprintVersionId blueprintVersionId) throws IOException {
        return this.autoGovernConfigurationDAO.listFromUsedBPV(blueprintVersionId);
    }

    @Override
    @GHMandatoryTransaction
    public DefaultAutoGovernanceConfiguration upsertInstanceAutoGovernConfiguration(InstanceAutoGovernanceConfiguration instanceDefaultAutoGovernanceConfiguration) throws IOException {
        DefaultAutoGovernanceConfiguration autoGovernInstanceLevelConfiguration = DefaultAutoGovernanceConfiguration.build(instanceDefaultAutoGovernanceConfiguration);
        return (DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.upsertConfigurationItem(autoGovernInstanceLevelConfiguration);
    }

    @Override
    @GHMandatoryTransaction
    public DefaultAutoGovernanceConfiguration getInstanceDefaultProjectAutoGovernConfiguration() throws IOException {
        return DefaultAutoGovernanceConfiguration.build(Optional.ofNullable((DefaultAutoGovernanceConfiguration)this.governConfigurationDataService.getConfigurationItemOrNull("default-autogovern")).map(cfg -> cfg.instanceAutoGovernanceConfiguration).orElse(InstanceAutoGovernanceConfiguration.build(AutoGovernanceConfiguration.buildDisabled(), AutoGovernanceConfiguration.buildDisabled(), AutoGovernanceConfiguration.buildDisabled(), AutoGovernanceConfiguration.buildDisabled())));
    }
}

