/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.config;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.configuration.DefaultAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfigurationWithSource;
import com.dataiku.gh.core.models.governance.AutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceStatus;
import com.dataiku.gh.core.models.governance.InstanceAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ModelAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.ProjectAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.dss.govern.IDSSIntegrationService;
import com.dataiku.gh.core.services.governance.config.IAdminAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoGovernanceConfigurationService
implements IAutoGovernanceConfigurationService,
IAdminAutoGovernanceConfigurationService {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IDSSIntegrationService dssIntegrationService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @Override
    @GHReadonlyTransaction
    public ArtifactAutoGovernanceConfigurationWithSource getEffectiveConfigurationForArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, false);
        this.validateFetchedConfigIsOnADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        return this.autoGovernanceConfigurationDataService.getEffectiveArtifactAutoGovernConfiguration(artifactId);
    }

    @Override
    @GHReadonlyTransaction
    public List<ArtifactAutoGovernanceConfigurationWithSource> getEffectiveConfigurationsForGovernProject(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact governItemToRead = this.artifactsDataService.getArtifact(artifactId);
        try (UserRolesCacheContext.ContextContainer ignored = UserRolesCacheContext.attachNewContext();){
            this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, governItemToRead, false);
            this.validateFetchedConfigIsOnAGovernProject(governItemToRead);
            ArrayList<ArtifactAutoGovernanceConfigurationWithSource> allowedToSeeDataikuConfigs = new ArrayList<ArtifactAutoGovernanceConfigurationWithSource>();
            for (ArtifactAutoGovernanceConfigurationWithSource cfg : this.autoGovernanceConfigurationDataService.getEffectiveConfigurationsForGovernProject(governItemToRead)) {
                String currId = cfg.artifactAutoGovernanceConfiguration.artifactId;
                try {
                    EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(currId);
                    this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, false);
                    this.validateFetchedConfigIsOnADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
                    allowedToSeeDataikuConfigs.add(cfg);
                }
                catch (UnauthorizedException unauthorizedException) {}
            }
            ArrayList<ArtifactAutoGovernanceConfigurationWithSource> arrayList = allowedToSeeDataikuConfigs;
            return arrayList;
        }
    }

    @Override
    @GHWriteTransaction
    public void deleteConfigurationForArtifact(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, true);
        this.validateFetchedConfigIsOnADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        this.checkUserCanDeleteGovernanceConfiguration(authCtx, artifactId);
        this.autoGovernanceConfigurationDataService.deleteDSSArtifactAutoGovernConfiguration(artifactId);
    }

    @Override
    @GHWriteTransaction
    public ArtifactAutoGovernanceConfigurationWithSource upsertConfigurationForArtifact(AuthCtx authCtx, ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration) throws IOException, DKUSecurityException {
        this.validateDSSArtifactAutoGovernInputFromUser(artifactAutoGovernanceConfiguration, false);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((String)artifactAutoGovernanceConfiguration.artifactId), "Artifact AutoGovernConfiguration should contain a well-defined artifactId", new Object[0]);
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(artifactAutoGovernanceConfiguration.artifactId);
        this.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, true);
        this.validateFetchedConfigIsOnADataikuArtifact(dataikuItemToGovernEnrichedArtifact);
        this.checkUserCanModifyGovernanceConfiguration(authCtx, artifactAutoGovernanceConfiguration);
        return this.autoGovernanceConfigurationDataService.upsertDSSArtifactAutoGovernConfiguration(artifactAutoGovernanceConfiguration);
    }

    private void checkUserCanDeleteGovernanceConfiguration(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        ArtifactAutoGovernanceConfiguration currentlyStoredConfiguration = this.autoGovernanceConfigurationDataService.getDSSArtifactAutoGovernConfigurationOrNull(artifactId);
        if (currentlyStoredConfiguration == null) {
            return;
        }
        try (UserRolesCacheContext.ContextContainer ignored = UserRolesCacheContext.attachNewContext();){
            boolean hasAtLeastOneBPVInModelConfiguration;
            boolean hasAtLeastOneBPVInEachProjectConfiguration = currentlyStoredConfiguration instanceof ProjectAutoGovernanceConfiguration && this.dssIntegrationService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL.blueprintId) && this.dssIntegrationService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId) && this.dssIntegrationService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId);
            boolean bl = hasAtLeastOneBPVInModelConfiguration = currentlyStoredConfiguration instanceof ModelAutoGovernanceConfiguration && this.dssIntegrationService.hasAtLeastOneBPVWithCreatePermission(authCtx, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId);
            if (!hasAtLeastOneBPVInModelConfiguration && !hasAtLeastOneBPVInEachProjectConfiguration) {
                String levelOfArtifact = currentlyStoredConfiguration instanceof ProjectAutoGovernanceConfiguration ? "project" : (currentlyStoredConfiguration instanceof ModelAutoGovernanceConfiguration ? "model" : "unknown");
                throw new UnauthorizedException("Permission denied: unable to delete AutoGovernance config for artifact: " + artifactId + " at level: " + levelOfArtifact, "autogovern-config-delete-denied");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkUserCanModifyGovernanceConfiguration(AuthCtx authCtx, ArtifactAutoGovernanceConfiguration pushedConfiguration) throws IOException, DKUSecurityException {
        ArtifactAutoGovernanceConfiguration currentlyStoredConfiguration = this.autoGovernanceConfigurationDataService.getDSSArtifactAutoGovernConfigurationOrNull(pushedConfiguration.artifactId);
        HashMap<String, AutoGovernanceConfiguration> blueprintIdAndCorrespondingAutoGovernConfigurationDiff = new HashMap<String, AutoGovernanceConfiguration>();
        if (pushedConfiguration instanceof ProjectAutoGovernanceConfiguration) {
            if (currentlyStoredConfiguration != null && !(currentlyStoredConfiguration instanceof ProjectAutoGovernanceConfiguration)) throw new ValidationException("Pushed configuration is of type DSSProjectAutoGovernConfiguration while current configuration is of type DSSModelAutoGovernConfiguration");
            ProjectAutoGovernanceConfiguration pushedDssProjectConfiguration = (ProjectAutoGovernanceConfiguration)pushedConfiguration;
            ProjectAutoGovernanceConfiguration currentlyStoredProjectConfiguration = (ProjectAutoGovernanceConfiguration)currentlyStoredConfiguration;
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.modelVersionsConfig.equals(currentlyStoredProjectConfiguration.modelVersionsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, pushedDssProjectConfiguration.modelVersionsConfig);
            }
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.modelsConfig.equals(currentlyStoredProjectConfiguration.modelsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL.blueprintId, pushedDssProjectConfiguration.modelsConfig);
            }
            if (currentlyStoredProjectConfiguration == null || !pushedDssProjectConfiguration.bundlesConfig.equals(currentlyStoredProjectConfiguration.bundlesConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, pushedDssProjectConfiguration.bundlesConfig);
            }
        } else if (pushedConfiguration instanceof ModelAutoGovernanceConfiguration) {
            if (currentlyStoredConfiguration != null && !(currentlyStoredConfiguration instanceof ModelAutoGovernanceConfiguration)) throw new ValidationException("Pushed configuration is of type DSSModelAutoGovernConfiguration while current configuration is of type DSSProjectAutoGovernConfiguration");
            if (currentlyStoredConfiguration == null || !((ModelAutoGovernanceConfiguration)pushedConfiguration).modelVersionsConfig.equals(((ModelAutoGovernanceConfiguration)currentlyStoredConfiguration).modelVersionsConfig)) {
                blueprintIdAndCorrespondingAutoGovernConfigurationDiff.put(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, ((ModelAutoGovernanceConfiguration)pushedConfiguration).modelVersionsConfig);
            }
        }
        try (UserRolesCacheContext.ContextContainer ignored = UserRolesCacheContext.attachNewContext();){
            for (Map.Entry bpIdAndAGC : blueprintIdAndCorrespondingAutoGovernConfigurationDiff.entrySet()) {
                String blueprintId = (String)bpIdAndAGC.getKey();
                AutoGovernanceConfiguration autoGovernanceConfiguration = (AutoGovernanceConfiguration)bpIdAndAGC.getValue();
                if (autoGovernanceConfiguration.status == AutoGovernanceStatus.ENABLED) {
                    this.validateAutoGovernConfig(autoGovernanceConfiguration, blueprintId, true);
                    EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(autoGovernanceConfiguration.blueprintVersionId);
                    AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion);
                    this.checkPermissionsService.checkArtifactCreatePermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, autoGovernanceConfiguration.blueprintVersionId.blueprintId);
                    continue;
                }
                if (autoGovernanceConfiguration.status != AutoGovernanceStatus.DISABLED || this.dssIntegrationService.hasAtLeastOneBPVWithCreatePermission(authCtx, blueprintId)) continue;
                throw new UnauthorizedException("Permission denied: unable to disable AutoGovernance config for artifact: " + pushedConfiguration.artifactId + " at level: " + blueprintId, "autogovern-config-upsert-denied");
            }
            return;
        }
    }

    @Override
    @GHReadonlyTransaction
    public void checkUserGovernLicenseAndArtifactReadPermissions(AuthCtx authCtx, EnrichedArtifact dataikuItemToGovernEnrichedArtifact, boolean needsWriteGovern) throws IOException, DKUSecurityException {
        if (needsWriteGovern) {
            this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        } else {
            this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        }
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, dataikuItemToGovernEnrichedArtifact);
        this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, dataikuItemToGovernEnrichedArtifact.artifact.id);
    }

    @Override
    @GHReadonlyTransaction
    public InstanceAutoGovernanceConfiguration getInstanceDefaultAutoGovernanceConfiguration(AuthCtx authCtx) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        return this.autoGovernanceConfigurationDataService.getInstanceDefaultProjectAutoGovernConfiguration().instanceAutoGovernanceConfiguration;
    }

    @Override
    @GHWriteTransaction
    public DefaultAutoGovernanceConfiguration upsertInstanceAutoGovernConfiguration(AuthCtx authCtx, DefaultAutoGovernanceConfiguration defaultAutoGovernanceConfiguration) throws IOException, DKUSecurityException {
        InstanceAutoGovernanceConfiguration instanceDefaultAutoGovernanceConfiguration = defaultAutoGovernanceConfiguration.instanceAutoGovernanceConfiguration;
        this.permissionsService.checkMayManageGovern(authCtx);
        ValidatorUtils.validateThat(instanceDefaultAutoGovernanceConfiguration.artifactId == null, "Instance AutoGovernConfiguration should contain a null artifactId", new Object[0]);
        this.validateDSSArtifactAutoGovernInputFromUser(instanceDefaultAutoGovernanceConfiguration, true);
        return this.autoGovernanceConfigurationDataService.upsertInstanceAutoGovernConfiguration(instanceDefaultAutoGovernanceConfiguration);
    }

    private void validateDSSArtifactAutoGovernInputFromUser(ArtifactAutoGovernanceConfiguration artifactAutoGovernanceConfiguration, boolean checkBPVExists) throws IOException {
        if (artifactAutoGovernanceConfiguration instanceof ProjectAutoGovernanceConfiguration) {
            ProjectAutoGovernanceConfiguration projectAutoGovernanceConfiguration = (ProjectAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration;
            this.validateAutoGovernConfig(projectAutoGovernanceConfiguration.bundlesConfig, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, checkBPVExists);
            this.validateAutoGovernConfig(projectAutoGovernanceConfiguration.modelsConfig, SystemProvidedConstants.GOVERN_MODEL.blueprintId, checkBPVExists);
            this.validateAutoGovernConfig(projectAutoGovernanceConfiguration.modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        } else if (artifactAutoGovernanceConfiguration instanceof InstanceAutoGovernanceConfiguration) {
            InstanceAutoGovernanceConfiguration instanceAutoGovernanceConfiguration = (InstanceAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration;
            this.validateAutoGovernConfig(instanceAutoGovernanceConfiguration.projectsConfig, SystemProvidedConstants.GOVERN_PROJECT.blueprintId, checkBPVExists);
            this.validateAutoGovernConfig(instanceAutoGovernanceConfiguration.bundlesConfig, SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, checkBPVExists);
            this.validateAutoGovernConfig(instanceAutoGovernanceConfiguration.modelsConfig, SystemProvidedConstants.GOVERN_MODEL.blueprintId, checkBPVExists);
            this.validateAutoGovernConfig(instanceAutoGovernanceConfiguration.modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        } else {
            this.validateAutoGovernConfig(((ModelAutoGovernanceConfiguration)artifactAutoGovernanceConfiguration).modelVersionsConfig, SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, checkBPVExists);
        }
    }

    private void validateAutoGovernConfig(AutoGovernanceConfiguration autoGovernanceConfiguration, String blueprintIdAtLevel, boolean checkBPVExists) throws IOException {
        ValidatorUtils.validateThat(autoGovernanceConfiguration != null, "AutoGovernConfiguration can't be null", new Object[0]);
        if (autoGovernanceConfiguration.status == AutoGovernanceStatus.ENABLED) {
            if (autoGovernanceConfiguration.blueprintVersionId == null || StringUtils.isBlank((String)autoGovernanceConfiguration.blueprintVersionId.blueprintId) || StringUtils.isBlank((String)autoGovernanceConfiguration.blueprintVersionId.versionId)) {
                throw new ValidationException("blueprintVersionId must be provided for an enabled autoGovernanceConfiguration for level: " + blueprintIdAtLevel);
            }
            if (!blueprintIdAtLevel.equals(autoGovernanceConfiguration.blueprintVersionId.blueprintId)) {
                throw new ValidationException("Can't use blueprint version id: " + String.valueOf(autoGovernanceConfiguration.blueprintVersionId) + " as an auto-govern template for level: " + blueprintIdAtLevel);
            }
            if (checkBPVExists) {
                ValidatorUtils.validateThat(this.blueprintVersionDAO.exists(autoGovernanceConfiguration.blueprintVersionId), "Blueprint version '%s' does not exists", autoGovernanceConfiguration.blueprintVersionId);
            }
        }
    }

    private void validateFetchedConfigIsOnADataikuArtifact(EnrichedArtifact artifact) {
        this.validateFetchedConfigBlueprintMatchesPossibleList(artifact.blueprint.id, List.of(SystemProvidedConstants.DATAIKU_PROJECT.blueprintId, SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId));
    }

    private void validateFetchedConfigIsOnAGovernProject(EnrichedArtifact artifact) {
        this.validateFetchedConfigBlueprintMatchesPossibleList(artifact.blueprint.id, List.of(SystemProvidedConstants.GOVERN_PROJECT.blueprintId));
    }

    private void validateFetchedConfigBlueprintMatchesPossibleList(String artifactBlueprintId, List<String> blueprintListToMatch) {
        String expectedValues = String.join((CharSequence)" or ", blueprintListToMatch);
        ValidatorUtils.validateThat(blueprintListToMatch.contains(artifactBlueprintId), "AutoGovernConfiguration can't be fetched for an artifact other than '%s', given '%s", expectedValues, artifactBlueprintId);
    }
}

