/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.manual;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.GovernProjectArtifactsContainer;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.ManualGovernanceSettings;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationUtils;
import com.dataiku.gh.core.services.dss.search_artifacts.IDSSIntegrationSearchArtifactsService;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.governance.AbstractGovernanceService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationService;
import com.dataiku.gh.core.services.governance.manual.IManualGovernanceService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.common.collect.Lists;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManualGovernanceService
extends AbstractGovernanceService
implements IManualGovernanceService {
    @Autowired
    private IDSSIntegrationSearchArtifactsService dssIntegrationSearchArtifactsService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IAutoGovernanceConfigurationService autoGovernanceConfigurationService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @Override
    @GHWriteTransaction
    public void governArtifactFromUserInput(AuthCtx authCtx, String dataikuItemArtifactId, ManualGovernanceSettings manualGovernanceSettings) throws IOException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException {
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(dataikuItemArtifactId);
        this.autoGovernanceConfigurationService.checkUserGovernLicenseAndArtifactReadPermissions(authCtx, dataikuItemToGovernEnrichedArtifact, true);
        boolean isAdvancedLicense = this.licenseEnforcementService.isGovernBlueprintDesignerAllowed();
        if (!isAdvancedLicense && !this.artifactIsGovernableWithAdvancedLicense(dataikuItemToGovernEnrichedArtifact.artifact)) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to govern this kind of item");
        }
        this.checkUserCanAllocateBPV(authCtx, manualGovernanceSettings);
        this.validateGovernArtifactInputsFromUser(dataikuItemToGovernEnrichedArtifact, manualGovernanceSettings);
        DSSProjectArtifactsContainer dssArtifacts = this.dssIntegrationSearchArtifactsService.findDSSProjectArtifacts(DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(dataikuItemToGovernEnrichedArtifact.artifact));
        GovernProjectArtifactsContainer governArtifacts = this.dssProjectToGovernProjectContainer(dssArtifacts);
        if (manualGovernanceSettings.projectAutoGovernanceConfiguration != null) {
            this.autoGovernanceConfigurationService.upsertConfigurationForArtifact(authCtx, manualGovernanceSettings.projectAutoGovernanceConfiguration);
        } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuItemToGovernEnrichedArtifact.artifact.blueprintVersionId) && manualGovernanceSettings.modelAutoGovernanceConfiguration != null) {
            this.autoGovernanceConfigurationService.upsertConfigurationForArtifact(authCtx, manualGovernanceSettings.modelAutoGovernanceConfiguration);
        } else if (manualGovernanceSettings.deleteAutoGovernanceConfiguration) {
            this.autoGovernanceConfigurationService.deleteConfigurationForArtifact(authCtx, dataikuItemArtifactId);
        }
        this.internalGovernArtifact(dssArtifacts, governArtifacts, dataikuItemToGovernEnrichedArtifact.artifact, manualGovernanceSettings, authCtx, isAdvancedLicense);
    }

    private void checkUserCanAllocateBPV(AuthCtx authCtx, ManualGovernanceSettings manualGovernanceSettings) throws IOException, DKUSecurityException {
        if (manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.CreateProjectSettings) {
            this.checkBPVCanBeCreated(authCtx, BlueprintVersionId.build(SystemProvidedConstants.GOVERN_PROJECT.blueprintId, ((ManualGovernanceSettings.CreateProjectSettings)manualGovernanceSettings.projectSettings).versionId));
        }
        if (manualGovernanceSettings.bundleSettings != null) {
            this.checkBPVCanBeCreated(authCtx, BlueprintVersionId.build(SystemProvidedConstants.GOVERN_BUNDLE.blueprintId, manualGovernanceSettings.bundleSettings.versionId));
        }
        if (manualGovernanceSettings.modelSettings != null) {
            this.checkBPVCanBeCreated(authCtx, BlueprintVersionId.build(SystemProvidedConstants.GOVERN_MODEL.blueprintId, manualGovernanceSettings.modelSettings.versionId));
        }
        if (manualGovernanceSettings.modelVersionSettings != null) {
            this.checkBPVCanBeCreated(authCtx, BlueprintVersionId.build(SystemProvidedConstants.GOVERN_MODEL_VERSION.blueprintId, manualGovernanceSettings.modelVersionSettings.versionId));
        }
    }

    private void checkBPVCanBeCreated(AuthCtx authCtx, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        EnrichedBlueprintVersion governingEnrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        if (governingEnrichedBlueprintVersion.blueprintVersionTrace.status != BlueprintVersionStatus.ACTIVE) {
            throw new ValidationException("Cannot govern with a non-active blueprint version: " + governingEnrichedBlueprintVersion.blueprintVersion.id.blueprintId + ", " + governingEnrichedBlueprintVersion.blueprintVersion.id.versionId);
        }
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(authCtx, governingEnrichedBlueprintVersion);
        this.checkPermissionsService.checkArtifactCreatePermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, blueprintVersionId.blueprintId);
    }

    private void validateGovernArtifactInputsFromUser(EnrichedArtifact dataikuItemToGovernEnrichedArtifact, ManualGovernanceSettings manualGovernanceSettings) throws IOException {
        String artifactId;
        SystemProvidedEnrichedBlueprint dssSystemContainer = SystemProvidedConstants.SYSTEM_BLUEPRINT_BY_ID.get(dataikuItemToGovernEnrichedArtifact.blueprint.id);
        if (dssSystemContainer == null || !Lists.newArrayList((Object[])new SystemProvidedEnrichedBlueprint[]{SystemProvidedConstants.DATAIKU_PROJECT, SystemProvidedConstants.DATAIKU_SAVED_MODEL, SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION, SystemProvidedConstants.DATAIKU_BUNDLE}).contains(dssSystemContainer)) {
            throw new ValidationException("Item " + dataikuItemToGovernEnrichedArtifact.artifact.id + " can't be governed as it's not a 'dataiku_project', a 'dataiku_saved_model', a 'dataiku_saved_model_version', or a 'dataiku_bundle' system Blueprint");
        }
        if (DSSIntegrationUtils.isGoverned(dataikuItemToGovernEnrichedArtifact.artifact)) {
            throw new ValidationException("Item " + dataikuItemToGovernEnrichedArtifact.artifact.id + " is already governed by " + String.valueOf(dataikuItemToGovernEnrichedArtifact.artifact.fields.get("governed_by")));
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprintVersion.id) && manualGovernanceSettings.projectSettings == null) {
            throw new ValidationException("Invalid Govern Setting for governing a project: projectSettings required");
        }
        if (manualGovernanceSettings.projectSettings != null && manualGovernanceSettings.projectSettings.governChildrenBundles && manualGovernanceSettings.bundleSettings == null) {
            throw new ValidationException("Invalid Govern Setting for auto-governing bundles: bundleSettings required");
        }
        if (manualGovernanceSettings.projectSettings != null && manualGovernanceSettings.projectSettings.governChildrenSavedModels && manualGovernanceSettings.modelSettings == null) {
            throw new ValidationException("Invalid Govern Setting for auto-governing models: modelSettings required");
        }
        if (SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprintVersion.id) && manualGovernanceSettings.bundleSettings == null) {
            throw new ValidationException("Invalid Govern Setting for governing a bundle: bundleSettings required");
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprintVersion.id) && manualGovernanceSettings.modelSettings == null) {
            throw new ValidationException("Invalid Govern Setting for governing a saved model: modelSettings required");
        }
        if (manualGovernanceSettings.modelSettings != null && manualGovernanceSettings.modelSettings.governChildrenSavedModelVersions && manualGovernanceSettings.modelVersionSettings == null) {
            throw new ValidationException("Invalid Govern Setting for auto-governing model versions: modelVersionSettings required");
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(dataikuItemToGovernEnrichedArtifact.blueprintVersion.id) && manualGovernanceSettings.modelVersionSettings == null) {
            throw new ValidationException("Invalid Govern Setting for governing a saved model version: modelVersionSettings required");
        }
        if (manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.CreateProjectSettings && StringUtils.isNotBlank((CharSequence)(artifactId = ((ManualGovernanceSettings.CreateProjectSettings)manualGovernanceSettings.projectSettings).businessInitiativeArtifactId))) {
            EnrichedArtifact businessInitiativeEnrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
            if (!StringUtils.equals((CharSequence)businessInitiativeEnrichedArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.BUSINESS_INITIATIVE.blueprintId)) {
                throw new ValidationException("The artifactId `" + artifactId + "` given for the Dataiku Govern Initiative doesn't reference a Dataiku Govern Initiative but a " + businessInitiativeEnrichedArtifact.blueprint.id);
            }
        }
        if (manualGovernanceSettings.projectSettings instanceof ManualGovernanceSettings.ExistingProjectSettings) {
            artifactId = ((ManualGovernanceSettings.ExistingProjectSettings)manualGovernanceSettings.projectSettings).artifactId;
            EnrichedArtifact governProjectArtifact = this.artifactsDataService.getArtifact(artifactId);
            if (!StringUtils.equals((CharSequence)governProjectArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GOVERN_PROJECT.blueprintId)) {
                throw new ValidationException("The artifactId `" + artifactId + "` given for the Dataiku Govern Project doesn't reference a Dataiku Govern Project but a " + governProjectArtifact.blueprint.id);
            }
        }
    }
}

