/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.history;

import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.history.HistoryAction;
import com.dataiku.gh.core.models.history.HistoryField;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.history.artifact.ArtifactAndHistoryActionEntry;
import com.dataiku.gh.core.models.history.artifact.ArtifactFullHistoryAction;
import com.dataiku.gh.core.models.history.timeline.ArtifactTimelineSearchConfig;
import com.dataiku.gh.core.models.history.timeline.TimelinePagination;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.history.IHistorySearchDAO;
import com.dataiku.gh.core.storage.history.IRevisionDAO;
import com.dataiku.gh.core.storage.search.IArtifactAtTimestampSearchDAO;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HistoryDataService
implements IHistoryDataService {
    @Autowired
    private IRevisionDAO revisionDAO;
    @Autowired
    private IHistorySearchDAO historySearchDAO;
    @Autowired
    private IArtifactAtTimestampSearchDAO artifactAtTimestampSearchDAO;

    @Override
    @GHMandatoryTransaction
    public HistoryRevision createRevision(RevisionType revisionType, EntityType entityType) throws IOException {
        GovernActionContext.ContextContainer ghContext = GovernActionContext.getContext();
        if (ghContext.transactionStart == null) {
            throw new IllegalStateException("Cannot create a revision without opening a Write transaction");
        }
        String userIdentifier = GovernActionContext.getAuthCtxIdentifier();
        if (ghContext.actionId == null) {
            ghContext.actionId = this.revisionDAO.newActionId();
            this.revisionDAO.createHistoryAction(HistoryAction.build(ghContext.actionId, ghContext.actionType, ghContext.actionStart.toInstant().toEpochMilli(), userIdentifier));
        }
        return HistoryRevision.build(this.revisionDAO.newRevisionId(), ghContext.actionId, ghContext.transactionStart.toInstant().toEpochMilli(), revisionType, entityType, userIdentifier);
    }

    @Override
    @GHMandatoryTransaction
    public Stream<ArtifactAndHistoryActionEntry> searchPartialArtifactHistoryStream(ArtifactTimelineSearchConfig artifactTimelineSearchConfig, TimelinePagination timelinePagination) throws IOException {
        return this.historySearchDAO.searchArtifactPartialHistoryActionStream(artifactTimelineSearchConfig, timelinePagination);
    }

    @Override
    @GHMandatoryTransaction
    public Stream<ArtifactFullHistoryAction> listArtifactsHistoryOfAction(long actionId, List<String> artifactIds) throws IOException {
        return this.historySearchDAO.listArtifactsHistoryOfAction(actionId, artifactIds);
    }

    @Override
    @GHMandatoryTransaction
    public List<EnrichedArtifactWithoutPermissions> listArtifactsAtTimestamp(List<String> artifactIds, long timestamp) throws IOException {
        return this.artifactAtTimestampSearchDAO.listAtTimestamp(timestamp, artifactIds);
    }

    @Override
    @GHMandatoryTransaction
    public Stream<HistoryField> getArtifactHistoryFields(String artifactId) throws IOException {
        return this.historySearchDAO.getHistoryFieldsStream(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public EnrichedArtifactWithoutPermissions getLastKnownEnrichedArtifact(String artifactId) throws IOException {
        return this.historySearchDAO.getLastKnownEnrichedArtifact(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public Map<ActionType, Long> getActionCounts() throws IOException {
        return this.revisionDAO.getActionCounts();
    }
}

