/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.handlers;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.gh.core.models.relationships.ReferenceRelationship;
import com.dataiku.gh.core.services.relationships.handlers.AbstractRelationshipHandler;
import com.dataiku.gh.core.services.relationships.handlers.IReferenceRelationshipHandler;
import com.dataiku.gh.core.services.relationships.handlers.RelationshipValidationContext;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.artifacts.IReferenceRelationshipDAO;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferenceRelationshipHandler
extends AbstractRelationshipHandler<ReferenceRelationship>
implements IReferenceRelationshipHandler {
    @Autowired
    private IArtifactDAO artifactDAO;
    @Autowired
    private IReferenceRelationshipDAO referenceRelationshipDAO;

    @Override
    public Class<ReferenceRelationship> getRelationshipClazz() {
        return ReferenceRelationship.class;
    }

    @Override
    @GHMandatoryTransaction
    public void validateRelationships(List<ReferenceRelationship> relationships, RelationshipValidationContext validationContext) throws IOException {
        Set<String> artifactIds = validationContext.artifactIdsAllowedBlueprintIds.stream().map(Pair::getLeft).collect(Collectors.toSet());
        Map<String, String> blueprintIdsMappedByArtifactIds = this.artifactDAO.getBlueprintsFromArtifactIds(artifactIds);
        for (Pair<String, List<String>> artifactIdAllowedBlueprintIds : validationContext.artifactIdsAllowedBlueprintIds) {
            String artifactId = (String)artifactIdAllowedBlueprintIds.getLeft();
            String blueprintId = blueprintIdsMappedByArtifactIds.get(artifactId);
            if (blueprintId == null) {
                throw new NotFoundException("Referenced artifact not found: " + artifactId);
            }
            List allowedBlueprints = (List)artifactIdAllowedBlueprintIds.getRight();
            if (allowedBlueprints == null || allowedBlueprints.isEmpty() || allowedBlueprints.contains(blueprintId)) continue;
            throw new ValidationException("Artifact " + artifactId + " is of type " + blueprintId + ", but allowedBlueprints are " + String.valueOf(allowedBlueprints));
        }
    }

    protected IReferenceRelationshipDAO getDAO() {
        return this.referenceRelationshipDAO;
    }
}

