/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.text.TextFieldDefinition;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingFieldValueCriterion;
import com.dataiku.gh.core.visitors.HierarchicalFieldDefinitionVisitor;
import com.dataiku.gh.core.visitors.IFieldValueVisitor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CriterionOperatorsUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.blueprint-role-assignments-operators");

    public static boolean doFieldValueRuleEqualsOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        return Objects.equals(criterionValue, JSON.toJsonElement((Object)fieldValue));
    }

    public static boolean doFieldValueRuleNotEqualsOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        return !Objects.equals(criterionValue, JSON.toJsonElement((Object)fieldValue));
    }

    public static boolean doFieldValueRuleInOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        JsonElement jsonFieldValue = JSON.toJsonElement((Object)fieldValue);
        JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        if (!criterionValue.isJsonArray()) {
            return false;
        }
        JsonArray providedList = criterionValue.getAsJsonArray();
        if (providedList.size() == 0) {
            return false;
        }
        boolean in = StreamSupport.stream(providedList.spliterator(), false).anyMatch(item -> Objects.equals(item, jsonFieldValue));
        return in;
    }

    public static boolean doFieldValueRuleNotInOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        JsonElement jsonFieldValue = JSON.toJsonElement((Object)fieldValue);
        JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        if (!criterionValue.isJsonArray()) {
            return false;
        }
        JsonArray providedList = criterionValue.getAsJsonArray();
        if (providedList.size() == 0) {
            return false;
        }
        boolean in = StreamSupport.stream(providedList.spliterator(), false).anyMatch(item -> Objects.equals(item, jsonFieldValue));
        return !in;
    }

    public static boolean doFieldValueRuleContainsOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        final Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        final JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        class ComplyChecker
        extends HierarchicalFieldDefinitionVisitor {
            public boolean comply = false;

            ComplyChecker() {
            }

            @Override
            public void visit(FieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(List<Object> listFieldValue) {
                        comply = listFieldValue.stream().anyMatch(item -> Objects.equals(JSON.toJsonElement((Object)item), criterionValue));
                    }
                }.visit(fieldValue);
            }

            @Override
            public void visit(TextFieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(String stringFieldValue) {
                        if (criterionValue == null || !criterionValue.isJsonPrimitive() || !criterionValue.getAsJsonPrimitive().isString()) {
                            return;
                        }
                        String providedStringValue = criterionValue.getAsJsonPrimitive().getAsString();
                        if (StringUtils.isBlank((CharSequence)providedStringValue)) {
                            return;
                        }
                        comply = StringUtils.isNotBlank((CharSequence)stringFieldValue) && StringUtils.contains((CharSequence)stringFieldValue, (CharSequence)providedStringValue);
                    }
                }.visit(fieldValue);
            }
        }
        ComplyChecker visitor = new ComplyChecker();
        fieldDefinition.accept(visitor, artifactExistingFieldValueCriterion.fieldId);
        return visitor.comply;
    }

    public static boolean doFieldValueRuleNotContainsOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        final Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        final JsonElement criterionValue = CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldDefinition.fieldType, artifactExistingFieldValueCriterion.value);
        class ComplyChecker
        extends HierarchicalFieldDefinitionVisitor {
            public boolean comply = false;

            ComplyChecker() {
            }

            @Override
            public void visit(FieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(List<Object> listFieldValue) {
                        comply = listFieldValue.stream().noneMatch(item -> Objects.equals(JSON.toJsonElement((Object)item), criterionValue));
                    }
                }.visit(fieldValue);
            }

            @Override
            public void visit(TextFieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(String stringFieldValue) {
                        if (criterionValue == null || !criterionValue.isJsonPrimitive() || !criterionValue.getAsJsonPrimitive().isString()) {
                            return;
                        }
                        String providedStringValue = criterionValue.getAsJsonPrimitive().getAsString();
                        if (StringUtils.isBlank((CharSequence)providedStringValue)) {
                            return;
                        }
                        comply = StringUtils.isNotBlank((CharSequence)stringFieldValue) && !StringUtils.contains((CharSequence)stringFieldValue, (CharSequence)providedStringValue);
                    }
                }.visit(fieldValue);
            }
        }
        ComplyChecker visitor = new ComplyChecker();
        fieldDefinition.accept(visitor, artifactExistingFieldValueCriterion.fieldId);
        return visitor.comply;
    }

    public static boolean doFieldValueRuleIsEmptyOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldValue == null) {
            return true;
        }
        class ComplyChecker
        extends HierarchicalFieldDefinitionVisitor {
            public boolean comply = false;
            final /* synthetic */ Object val$fieldValue;

            ComplyChecker(Object object) {
                this.val$fieldValue = object;
            }

            @Override
            public void visit(FieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(List<Object> listFieldValue) {
                        comply = CollectionUtils.isEmpty(listFieldValue);
                    }
                }.visit(this.val$fieldValue);
            }

            @Override
            public void visit(TextFieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(String stringFieldValue) {
                        comply = StringUtils.isBlank((CharSequence)stringFieldValue);
                    }
                }.visit(this.val$fieldValue);
            }
        }
        ComplyChecker visitor = new ComplyChecker(fieldValue);
        fieldDefinition.accept(visitor, artifactExistingFieldValueCriterion.fieldId);
        return visitor.comply;
    }

    public static boolean doFieldValueRuleIsNotEmptyOperatorComply(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        FieldDefinition fieldDefinition = CriterionOperatorsUtils.getFieldDefinitionOrNull(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldDefinition == null) {
            return false;
        }
        Object fieldValue = CriterionOperatorsUtils.getFieldValue(artifactExistingFieldValueCriterion, enrichedArtifact);
        if (fieldValue == null) {
            return false;
        }
        class ComplyChecker
        extends HierarchicalFieldDefinitionVisitor {
            public boolean comply = false;
            final /* synthetic */ Object val$fieldValue;

            ComplyChecker(Object object) {
                this.val$fieldValue = object;
            }

            @Override
            public void visit(FieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(List<Object> listFieldValue) {
                        comply = CollectionUtils.isNotEmpty(listFieldValue);
                    }
                }.visit(this.val$fieldValue);
            }

            @Override
            public void visit(TextFieldDefinition fieldDefinition, String fieldId) {
                super.visit(fieldDefinition, fieldId);
                new IFieldValueVisitor(){

                    @Override
                    public void visit(String stringFieldValue) {
                        comply = StringUtils.isNotBlank((CharSequence)stringFieldValue);
                    }
                }.visit(this.val$fieldValue);
            }
        }
        ComplyChecker visitor = new ComplyChecker(fieldValue);
        fieldDefinition.accept(visitor, artifactExistingFieldValueCriterion.fieldId);
        return visitor.comply;
    }

    private static JsonElement coerceCriterionValueToFieldType(FieldType fieldType, @Nullable JsonElement jsonElement) {
        if (jsonElement == null) {
            return JsonNull.INSTANCE;
        }
        if (jsonElement.isJsonPrimitive()) {
            String criterionValueAsString;
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (fieldType == FieldType.BOOLEAN && !jsonPrimitive.isBoolean() && ("true".equalsIgnoreCase(criterionValueAsString = jsonElement.getAsString()) || "false".equalsIgnoreCase(criterionValueAsString))) {
                return JSON.toJsonElement((Object)"true".equalsIgnoreCase(criterionValueAsString));
            }
            if (fieldType == FieldType.NUMBER && !jsonPrimitive.isNumber()) {
                try {
                    return JSON.toJsonElement((Object)jsonElement.getAsDouble());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (jsonElement.isJsonArray()) {
            List elements = StreamSupport.stream(jsonElement.getAsJsonArray().spliterator(), false).map(element -> CriterionOperatorsUtils.coerceCriterionValueToFieldType(fieldType, element)).collect(Collectors.toList());
            return JSON.toJsonArray(elements);
        }
        return jsonElement;
    }

    @Nullable
    private static FieldDefinition getFieldDefinitionOrNull(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        if (StringUtils.isBlank((CharSequence)artifactExistingFieldValueCriterion.fieldId)) {
            return null;
        }
        return enrichedArtifact.blueprintVersion.fieldDefinitions.get(artifactExistingFieldValueCriterion.fieldId);
    }

    @Nullable
    private static Object getFieldValue(ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion, EnrichedArtifact enrichedArtifact) {
        return enrichedArtifact.artifact.fields.get(artifactExistingFieldValueCriterion.fieldId);
    }
}

