/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public interface IUserBlueprintRoleAssignmentsComputationService {
    public Set<String> computeRolesAtBlueprintLevel(AuthCtx var1, EnrichedBlueprint var2) throws IOException;

    public Set<String> computeRolesAtBlueprintLevel(AuthCtx var1, EnrichedBlueprint var2, RolesAndPermissionsAudit.RolesAssignmentsAudit var3) throws IOException;

    public Set<String> computeRolesAtBlueprintVersionLevel(AuthCtx var1, EnrichedBlueprintVersion var2) throws IOException;

    public Set<String> computeRolesAtBlueprintVersionLevel(AuthCtx var1, EnrichedBlueprintVersion var2, RolesAndPermissionsAudit.RolesAssignmentsAudit var3) throws IOException;

    public Set<String> computeRolesAtArtifactExistingLevel(AuthCtx var1, EnrichedArtifact var2) throws IOException;

    public Set<String> computeRolesAtArtifactExistingLevel(AuthCtx var1, EnrichedArtifact var2, RolesAndPermissionsAudit.RolesAssignmentsAudit var3) throws IOException;

    public Set<String> computeRolesAtArtifactDeletedLevel(AuthCtx var1, EnrichedDeletedArtifact var2) throws IOException;

    public Set<String> computeRolesAtArtifactDeletedLevel(AuthCtx var1, EnrichedDeletedArtifact var2, RolesAndPermissionsAudit.RolesAssignmentsAudit var3) throws IOException;

    public static class UserLoginsAndAPIKeyIdsForRole {
        public Role role;
        public Set<String> userLogins = Sets.newHashSet();
        public Set<String> apiKeyIds = Sets.newHashSet();

        public boolean isEmpty() {
            return CollectionUtils.isEmpty(this.userLogins) && CollectionUtils.isEmpty(this.apiKeyIds);
        }

        public static UserLoginsAndAPIKeyIdsForRole build(Role role, Set<String> userLogins, Set<String> apiKeyIds) {
            UserLoginsAndAPIKeyIdsForRole userLoginsAndAPIKeyIdsForRole = new UserLoginsAndAPIKeyIdsForRole();
            userLoginsAndAPIKeyIdsForRole.role = role;
            userLoginsAndAPIKeyIdsForRole.userLogins = userLogins;
            userLoginsAndAPIKeyIdsForRole.apiKeyIds = apiKeyIds;
            return userLoginsAndAPIKeyIdsForRole;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UserLoginsAndAPIKeyIdsForRole other = (UserLoginsAndAPIKeyIdsForRole)object;
            return Objects.equals(this.role, other.role) && Objects.equals(this.userLogins, other.userLogins) && Objects.equals(this.apiKeyIds, other.apiKeyIds);
        }

        public int hashCode() {
            return Objects.hash(this.role, this.userLogins, this.apiKeyIds);
        }
    }
}

